
package org.opentravel.common.v02;

import java.io.Serializable;

/** 
 * Metadata that describes a contextual code.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://opentravel.org/common/v02" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ContextualCode">
 *   &lt;xs:simpleContent>
 *     &lt;xs:extension base="xs:string">
 *       &lt;xs:attribute type="xs:string" use="optional" name="context"/>
 *       &lt;xs:attribute type="xs:string" use="optional" name="URL"/>
 *     &lt;/xs:extension>
 *   &lt;/xs:simpleContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ContextualCode implements Serializable
{
    private String string;
    private String context;
    private String URL;

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public String getString() {
        return string;
    }

    /** 
     * Set the extension value.
     * 
     * @param string
     */
    public void setString(String string) {
        this.string = string;
    }

    /** 
     * Get the 'context' attribute value. The named context of the code.
     * 
     * @return value
     */
    public String getContext() {
        return context;
    }

    /** 
     * Set the 'context' attribute value. The named context of the code.
     * 
     * @param context
     */
    public void setContext(String context) {
        this.context = context;
    }

    /** 
     * Get the 'URL' attribute value. A URL to the source owner of the code.
     * 
     * @return value
     */
    public String getURL() {
        return URL;
    }

    /** 
     * Set the 'URL' attribute value. A URL to the source owner of the code.
     * 
     * @param URL
     */
    public void setURL(String URL) {
        this.URL = URL;
    }
}
