
package org.opentravel.common.v02;

import java.io.Serializable;

/** 
 * Summary data policy information.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://opentravel.org/common/v02" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DataPolicy">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:Enum_DataPolicyType" name="type" minOccurs="1"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="required" name="schemaFieldXPath"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class DataPolicy1 implements Serializable
{
    private EnumDataPolicyType type;
    private String schemaFieldXPath;

    /** 
     * Get the 'type' element value. An extensible list of data policy types.
     * 
     * @return value
     */
    public EnumDataPolicyType getType() {
        return type;
    }

    /** 
     * Set the 'type' element value. An extensible list of data policy types.
     * 
     * @param type
     */
    public void setType(EnumDataPolicyType type) {
        this.type = type;
    }

    /** 
     * Get the 'schemaFieldXPath' attribute value. An xPath to the tag of the schema element or attribute (field) that the data
                      policy(s) applies to.
                  
     * 
     * @return value
     */
    public String getSchemaFieldXPath() {
        return schemaFieldXPath;
    }

    /** 
     * Set the 'schemaFieldXPath' attribute value. An xPath to the tag of the schema element or attribute (field) that the data
                      policy(s) applies to.
                  
     * 
     * @param schemaFieldXPath
     */
    public void setSchemaFieldXPath(String schemaFieldXPath) {
        this.schemaFieldXPath = schemaFieldXPath;
    }
}
