
package org.opentravel.common.v02;

import java.io.Serializable;

/** 
 * An extensible list of identifiers for a type or category of a booking channel.
 Booking Channel Type (BCT)
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://opentravel.org/common/v02" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Enum_BookingChannel_Base">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Agent"/>
 *     &lt;xs:enumeration value="Alternative Distribution System (ADS)"/>
 *     &lt;xs:enumeration value="Central Reservation System (CRS)"/>
 *     &lt;xs:enumeration value="Global Distribution System (GDS)"/>
 *     &lt;xs:enumeration value="Internet"/>
 *     &lt;xs:enumeration value="Kiosk"/>
 *     &lt;xs:enumeration value="Property Management System (PMS)"/>
 *     &lt;xs:enumeration value="Sales And Catering System (SCS)"/>
 *     &lt;xs:enumeration value="Tour Operator System (TOS)"/>
 *     &lt;xs:enumeration value="Other_"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum EnumBookingChannelBase implements Serializable {
    AGENT("Agent"), ALTERNATIVE_DISTRIBUTION_SYSTEM_ADS(
            "Alternative Distribution System (ADS)"), CENTRAL_RESERVATION_SYSTEM_CRS(
            "Central Reservation System (CRS)"), GLOBAL_DISTRIBUTION_SYSTEM_GDS(
            "Global Distribution System (GDS)"), INTERNET("Internet"), KIOSK(
            "Kiosk"), PROPERTY_MANAGEMENT_SYSTEM_PMS(
            "Property Management System (PMS)"), SALES_AND_CATERING_SYSTEM_SCS(
            "Sales And Catering System (SCS)"), TOUR_OPERATOR_SYSTEM_TOS(
            "Tour Operator System (TOS)"), OTHER_("Other_");
    private final String value;

    private EnumBookingChannelBase(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static EnumBookingChannelBase convert(String value) {
        for (EnumBookingChannelBase inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
