
package org.opentravel.common.v02;

import java.io.Serializable;

/** 
 * Day of the Week types.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://opentravel.org/common/v02" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Enum_DayOfWeek">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Monday"/>
 *     &lt;xs:enumeration value="Tuesday"/>
 *     &lt;xs:enumeration value="Wednesday"/>
 *     &lt;xs:enumeration value="Thursday"/>
 *     &lt;xs:enumeration value="Friday"/>
 *     &lt;xs:enumeration value="Saturday"/>
 *     &lt;xs:enumeration value="Sunday"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum EnumDayOfWeek implements Serializable {
    MONDAY("Monday"), TUESDAY("Tuesday"), WEDNESDAY("Wednesday"), THURSDAY(
            "Thursday"), FRIDAY("Friday"), SATURDAY("Saturday"), SUNDAY(
            "Sunday");
    private final String value;

    private EnumDayOfWeek(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static EnumDayOfWeek convert(String value) {
        for (EnumDayOfWeek inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
