
package org.opentravel.common.v02;

import java.io.Serializable;

/** 
 * An extensible list of actions performed on a record.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://opentravel.org/common/v02" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Enum_RecordActionType_Base">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Create"/>
 *     &lt;xs:enumeration value="Delete"/>
 *     &lt;xs:enumeration value="Merge"/>
 *     &lt;xs:enumeration value="Read/Query"/>
 *     &lt;xs:enumeration value="Update"/>
 *     &lt;xs:enumeration value="Other_"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum EnumRecordActionTypeBase implements Serializable {
    CREATE("Create"), DELETE("Delete"), MERGE("Merge"), READ_QUERY("Read/Query"), UPDATE(
            "Update"), OTHER_("Other_");
    private final String value;

    private EnumRecordActionTypeBase(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static EnumRecordActionTypeBase convert(String value) {
        for (EnumRecordActionTypeBase inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
