
package org.opentravel.common.v02;

import java.io.Serializable;

/** 
 * An extensible list of target processing system types.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://opentravel.org/common/v02" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Enum_TargetProcessingSystem_Base">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Production"/>
 *     &lt;xs:enumeration value="Staging"/>
 *     &lt;xs:enumeration value="Test"/>
 *     &lt;xs:enumeration value="Other_"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum EnumTargetProcessingSystemBase implements Serializable {
    PRODUCTION("Production"), STAGING("Staging"), TEST("Test"), OTHER_("Other_");
    private final String value;

    private EnumTargetProcessingSystemBase(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static EnumTargetProcessingSystemBase convert(String value) {
        for (EnumTargetProcessingSystemBase inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
