
package org.opentravel.common.v02;

import java.io.Serializable;

/** 
 * An identifier for where this message falls within a sequence of messages.

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://opentravel.org/common/v02" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Enum_TransactionStatus">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Start"/>
 *     &lt;xs:enumeration value="End"/>
 *     &lt;xs:enumeration value="Rollback"/>
 *     &lt;xs:enumeration value="InSeries"/>
 *     &lt;xs:enumeration value="Continuation"/>
 *     &lt;xs:enumeration value="Subsequent"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum EnumTransactionStatus implements Serializable {
    START("Start"), END("End"), ROLLBACK("Rollback"), IN_SERIES("InSeries"), CONTINUATION(
            "Continuation"), SUBSEQUENT("Subsequent");
    private final String value;

    private EnumTransactionStatus(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static EnumTransactionStatus convert(String value) {
        for (EnumTransactionStatus inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
