
package org.opentravel.common.v02;

import java.io.Serializable;

/** 
 * An extensible list of URL contexts.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://opentravel.org/common/v02" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Enum_URL_Context_Base">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Company Website"/>
 *     &lt;xs:enumeration value="Descriptive Information"/>
 *     &lt;xs:enumeration value="More Information"/>
 *     &lt;xs:enumeration value="Reference Authority"/>
 *     &lt;xs:enumeration value="Other_"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum EnumURLContextBase implements Serializable {
    COMPANY_WEBSITE("Company Website"), DESCRIPTIVE_INFORMATION(
            "Descriptive Information"), MORE_INFORMATION("More Information"), REFERENCE_AUTHORITY(
            "Reference Authority"), OTHER_("Other_");
    private final String value;

    private EnumURLContextBase(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static EnumURLContextBase convert(String value) {
        for (EnumURLContextBase inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
