
package org.opentravel.common.v02;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/** 
 * Metadata that describes an exchange rate.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://opentravel.org/common/v02" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ExchangeRate">
 *   &lt;xs:simpleContent>
 *     &lt;xs:extension base="xs:string">
 *       &lt;xs:attribute type="xs:decimal" use="optional" name="baseNUC"/>
 *       &lt;xs:attribute type="xs:dateTime" use="required" name="exchangeDateTime"/>
 *       &lt;xs:attribute type="xs:decimal" use="required" name="exchangeRate"/>
 *       &lt;xs:attribute type="xs:string" use="optional" name="exchangeSourceName"/>
 *       &lt;xs:attribute type="xs:string" use="optional" name="exchangeSourceURL"/>
 *       &lt;xs:attribute type="xs:string" use="required" name="toCurrency"/>
 *     &lt;/xs:extension>
 *   &lt;/xs:simpleContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ExchangeRate implements Serializable
{
    private String string;
    private BigDecimal baseNUC;
    private Date exchangeDateTime;
    private BigDecimal exchangeRate;
    private String exchangeSourceName;
    private String exchangeSourceURL;
    private String toCurrency;

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public String getString() {
        return string;
    }

    /** 
     * Set the extension value.
     * 
     * @param string
     */
    public void setString(String string) {
        this.string = string;
    }

    /** 
     * Get the 'baseNUC' attribute value. The base neutral unit of construction amount.
     * 
     * @return value
     */
    public BigDecimal getBaseNUC() {
        return baseNUC;
    }

    /** 
     * Set the 'baseNUC' attribute value. The base neutral unit of construction amount.
     * 
     * @param baseNUC
     */
    public void setBaseNUC(BigDecimal baseNUC) {
        this.baseNUC = baseNUC;
    }

    /** 
     * Get the 'exchangeDateTime' attribute value. The date and time of the conversion rate.
     * 
     * @return value
     */
    public Date getExchangeDateTime() {
        return exchangeDateTime;
    }

    /** 
     * Set the 'exchangeDateTime' attribute value. The date and time of the conversion rate.
     * 
     * @param exchangeDateTime
     */
    public void setExchangeDateTime(Date exchangeDateTime) {
        this.exchangeDateTime = exchangeDateTime;
    }

    /** 
     * Get the 'exchangeRate' attribute value. The rate used for conversion from the source currency to the target
                              currency.
                          
     * 
     * @return value
     */
    public BigDecimal getExchangeRate() {
        return exchangeRate;
    }

    /** 
     * Set the 'exchangeRate' attribute value. The rate used for conversion from the source currency to the target
                              currency.
                          
     * 
     * @param exchangeRate
     */
    public void setExchangeRate(BigDecimal exchangeRate) {
        this.exchangeRate = exchangeRate;
    }

    /** 
     * Get the 'exchangeSourceName' attribute value. The name of the exchange rate source.
     * 
     * @return value
     */
    public String getExchangeSourceName() {
        return exchangeSourceName;
    }

    /** 
     * Set the 'exchangeSourceName' attribute value. The name of the exchange rate source.
     * 
     * @param exchangeSourceName
     */
    public void setExchangeSourceName(String exchangeSourceName) {
        this.exchangeSourceName = exchangeSourceName;
    }

    /** 
     * Get the 'exchangeSourceURL' attribute value. A URL for the source of the conversion rate.
     * 
     * @return value
     */
    public String getExchangeSourceURL() {
        return exchangeSourceURL;
    }

    /** 
     * Set the 'exchangeSourceURL' attribute value. A URL for the source of the conversion rate.
     * 
     * @param exchangeSourceURL
     */
    public void setExchangeSourceURL(String exchangeSourceURL) {
        this.exchangeSourceURL = exchangeSourceURL;
    }

    /** 
     * Get the 'toCurrency' attribute value. An ISO 4217 currency code for the final converted currency.
                          
     * 
     * @return value
     */
    public String getToCurrency() {
        return toCurrency;
    }

    /** 
     * Set the 'toCurrency' attribute value. An ISO 4217 currency code for the final converted currency.
                          
     * 
     * @param toCurrency
     */
    public void setToCurrency(String toCurrency) {
        this.toCurrency = toCurrency;
    }
}
