
package org.opentravel.common.v02;

import java.io.Serializable;

/** 
 * Metadata that describes a language.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://opentravel.org/common/v02" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Identifier_Language">
 *   &lt;xs:simpleContent>
 *     &lt;xs:extension base="xs:string">
 *       &lt;xs:attribute type="xs:string" use="optional" name="alpha3"/>
 *       &lt;xs:attribute type="xs:string" use="optional" name="name"/>
 *       &lt;xs:attribute type="xs:boolean" use="optional" name="primaryInd"/>
 *     &lt;/xs:extension>
 *   &lt;/xs:simpleContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class IdentifierLanguage implements Serializable
{
    private String string;
    private String alpha3;
    private String name;
    private Boolean primaryInd;

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public String getString() {
        return string;
    }

    /** 
     * Set the extension value.
     * 
     * @param string
     */
    public void setString(String string) {
        this.string = string;
    }

    /** 
     * Get the 'alpha3' attribute value. The three character alpha language code.
     * 
     * @return value
     */
    public String getAlpha3() {
        return alpha3;
    }

    /** 
     * Set the 'alpha3' attribute value. The three character alpha language code.
     * 
     * @param alpha3
     */
    public void setAlpha3(String alpha3) {
        this.alpha3 = alpha3;
    }

    /** 
     * Get the 'name' attribute value. The name of the language for display purposes.
     * 
     * @return value
     */
    public String getName() {
        return name;
    }

    /** 
     * Set the 'name' attribute value. The name of the language for display purposes.
     * 
     * @param name
     */
    public void setName(String name) {
        this.name = name;
    }

    /** 
     * Get the 'primaryInd' attribute value. If true, this is the primary (or preferred) language within a set of
                              specified languages.
                          
     * 
     * @return value
     */
    public Boolean getPrimaryInd() {
        return primaryInd;
    }

    /** 
     * Set the 'primaryInd' attribute value. If true, this is the primary (or preferred) language within a set of
                              specified languages.
                          
     * 
     * @param primaryInd
     */
    public void setPrimaryInd(Boolean primaryInd) {
        this.primaryInd = primaryInd;
    }
}
