
package org.opentravel.common.v02;

import java.io.Serializable;

/** 
 * Metadata that describes airline information for a message requestor or sender.
 http://bit.ly/OTA2_IATA_AirlineCode
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://opentravel.org/common/v02" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="InitiatorAirline">
 *   &lt;xs:simpleContent>
 *     &lt;xs:extension base="xs:string">
 *       &lt;xs:attribute type="xs:string" use="optional" name="airportCode"/>
 *       &lt;xs:attribute type="xs:string" use="optional" name="erspCode"/>
 *       &lt;xs:attribute type="xs:string" use="optional" name="firstDeparturePoint"/>
 *     &lt;/xs:extension>
 *   &lt;/xs:simpleContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class InitiatorAirline implements Serializable
{
    private String string;
    private String airportCode;
    private String erspCode;
    private String firstDeparturePoint;

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public String getString() {
        return string;
    }

    /** 
     * Set the extension value.
     * 
     * @param string
     */
    public void setString(String string) {
        this.string = string;
    }

    /** 
     * Get the 'airportCode' attribute value. A three character IATA assigned airport code.http://bit.ly/OTA2_IATA_AirportCodes
     * 
     * @return value
     */
    public String getAirportCode() {
        return airportCode;
    }

    /** 
     * Set the 'airportCode' attribute value. A three character IATA assigned airport code.http://bit.ly/OTA2_IATA_AirportCodes
     * 
     * @param airportCode
     */
    public void setAirportCode(String airportCode) {
        this.airportCode = airportCode;
    }

    /** 
     * Get the 'erspCode' attribute value. The IATA airline Electronic Reservation Services Provider (ERSP) code.
                          http://bit.ly/OTA2_ERSPAn ERSP is a unique IATA (in cooperation with ATA and ARC) code used as a
                              means of identification when performing online bookings with airlines.
                          
     * 
     * @return value
     */
    public String getErspCode() {
        return erspCode;
    }

    /** 
     * Set the 'erspCode' attribute value. The IATA airline Electronic Reservation Services Provider (ERSP) code.
                          http://bit.ly/OTA2_ERSPAn ERSP is a unique IATA (in cooperation with ATA and ARC) code used as a
                              means of identification when performing online bookings with airlines.
                          
     * 
     * @param erspCode
     */
    public void setErspCode(String erspCode) {
        this.erspCode = erspCode;
    }

    /** 
     * Get the 'firstDeparturePoint' attribute value. An IATA city code for the first departure point for a trip.
                          http://bit.ly/OTA2_IATA_AirportCodes
     * 
     * @return value
     */
    public String getFirstDeparturePoint() {
        return firstDeparturePoint;
    }

    /** 
     * Set the 'firstDeparturePoint' attribute value. An IATA city code for the first departure point for a trip.
                          http://bit.ly/OTA2_IATA_AirportCodes
     * 
     * @param firstDeparturePoint
     */
    public void setFirstDeparturePoint(String firstDeparturePoint) {
        this.firstDeparturePoint = firstDeparturePoint;
    }
}
