
package org.opentravel.common.v02;

import java.io.Serializable;

/** 
 * Metadata that describes a booking channel.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://opentravel.org/common/v02" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="InitiatorBookingChannel">
 *   &lt;xs:simpleContent>
 *     &lt;xs:extension base="ns:Enum_BookingChannel_Base">
 *       &lt;xs:attribute type="xs:string" name="extension"/>
 *       &lt;xs:attribute type="xs:string" use="optional" name="code"/>
 *       &lt;xs:attribute type="xs:string" use="optional" name="id"/>
 *       &lt;xs:attribute type="xs:string" use="optional" name="name"/>
 *       &lt;xs:attribute type="xs:boolean" use="optional" name="primaryInd"/>
 *     &lt;/xs:extension>
 *   &lt;/xs:simpleContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class InitiatorBookingChannel implements Serializable
{
    private EnumBookingChannelBase enumBookingChannelBase;
    private String extension;
    private String code;
    private String id;
    private String name;
    private Boolean primaryInd;

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public EnumBookingChannelBase getEnumBookingChannelBase() {
        return enumBookingChannelBase;
    }

    /** 
     * Set the extension value.
     * 
     * @param enumBookingChannelBase
     */
    public void setEnumBookingChannelBase(
            EnumBookingChannelBase enumBookingChannelBase) {
        this.enumBookingChannelBase = enumBookingChannelBase;
    }

    /** 
     * Get the 'extension' attribute value.
     * 
     * @return value
     */
    public String getExtension() {
        return extension;
    }

    /** 
     * Set the 'extension' attribute value.
     * 
     * @param extension
     */
    public void setExtension(String extension) {
        this.extension = extension;
    }

    /** 
     * Get the 'code' attribute value. A code for the booking channel.
     * 
     * @return value
     */
    public String getCode() {
        return code;
    }

    /** 
     * Set the 'code' attribute value. A code for the booking channel.
     * 
     * @param code
     */
    public void setCode(String code) {
        this.code = code;
    }

    /** 
     * Get the 'id' attribute value. A unique ID for the booking channel that is typically used for message
                              authentication.
                          
     * 
     * @return value
     */
    public String getId() {
        return id;
    }

    /** 
     * Set the 'id' attribute value. A unique ID for the booking channel that is typically used for message
                              authentication.
                          
     * 
     * @param id
     */
    public void setId(String id) {
        this.id = id;
    }

    /** 
     * Get the 'name' attribute value. The name of the booking channel.
     * 
     * @return value
     */
    public String getName() {
        return name;
    }

    /** 
     * Set the 'name' attribute value. The name of the booking channel.
     * 
     * @param name
     */
    public void setName(String name) {
        this.name = name;
    }

    /** 
     * Get the 'primaryInd' attribute value. If true, the booking channel type is the primary means of connectivity used
                              by the source.
                          
     * 
     * @return value
     */
    public Boolean getPrimaryInd() {
        return primaryInd;
    }

    /** 
     * Set the 'primaryInd' attribute value. If true, the booking channel type is the primary means of connectivity used
                              by the source.
                          
     * 
     * @param primaryInd
     */
    public void setPrimaryInd(Boolean primaryInd) {
        this.primaryInd = primaryInd;
    }
}
