
package org.opentravel.common.v02;

import java.io.Serializable;

/** 
 * Metadata that describes the currency used in a request message and the preferred
 response currency.

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://opentravel.org/common/v02" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Processing_Currency">
 *   &lt;xs:simpleContent>
 *     &lt;xs:extension base="xs:string">
 *       &lt;xs:attribute type="xs:string" use="optional" name="decimalPlaces"/>
 *       &lt;xs:attribute type="xs:boolean" use="optional" name="initiatorInd"/>
 *       &lt;xs:attribute type="xs:boolean" use="optional" name="responseInd"/>
 *       &lt;xs:attribute type="xs:boolean" use="optional" name="pricingFilingInd"/>
 *     &lt;/xs:extension>
 *   &lt;/xs:simpleContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ProcessingCurrency implements Serializable
{
    private String string;
    private String decimalPlaces;
    private Boolean initiatorInd;
    private Boolean responseInd;
    private Boolean pricingFilingInd;

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public String getString() {
        return string;
    }

    /** 
     * Set the extension value.
     * 
     * @param string
     */
    public void setString(String string) {
        this.string = string;
    }

    /** 
     * Get the 'decimalPlaces' attribute value. An ISO 4217 standard "minor unit" for the number of decimal places for the
                              associated currency.
                          
     * 
     * @return value
     */
    public String getDecimalPlaces() {
        return decimalPlaces;
    }

    /** 
     * Set the 'decimalPlaces' attribute value. An ISO 4217 standard "minor unit" for the number of decimal places for the
                              associated currency.
                          
     * 
     * @param decimalPlaces
     */
    public void setDecimalPlaces(String decimalPlaces) {
        this.decimalPlaces = decimalPlaces;
    }

    /** 
     * Get the 'initiatorInd' attribute value. If true, this is the currency that the initiating message is in.
                          
     * 
     * @return value
     */
    public Boolean getInitiatorInd() {
        return initiatorInd;
    }

    /** 
     * Set the 'initiatorInd' attribute value. If true, this is the currency that the initiating message is in.
                          
     * 
     * @param initiatorInd
     */
    public void setInitiatorInd(Boolean initiatorInd) {
        this.initiatorInd = initiatorInd;
    }

    /** 
     * Get the 'responseInd' attribute value. If true, this is the requested currency for message responses.
                          
     * 
     * @return value
     */
    public Boolean getResponseInd() {
        return responseInd;
    }

    /** 
     * Set the 'responseInd' attribute value. If true, this is the requested currency for message responses.
                          
     * 
     * @param responseInd
     */
    public void setResponseInd(Boolean responseInd) {
        this.responseInd = responseInd;
    }

    /** 
     * Get the 'pricingFilingInd' attribute value. If true, this is the pricing/filing currency.
     * 
     * @return value
     */
    public Boolean getPricingFilingInd() {
        return pricingFilingInd;
    }

    /** 
     * Set the 'pricingFilingInd' attribute value. If true, this is the pricing/filing currency.
     * 
     * @param pricingFilingInd
     */
    public void setPricingFilingInd(Boolean pricingFilingInd) {
        this.pricingFilingInd = pricingFilingInd;
    }
}
