
package org.opentravel.common.v02;

import java.io.Serializable;
import java.util.Date;

/** 
 * Metadata that describes a date and optional time with a time period that can be applied
 before and/or after the date.

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://opentravel.org/common/v02" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TimeWindow">
 *   &lt;xs:simpleContent>
 *     &lt;xs:extension base="xs:dateTime">
 *       &lt;xs:attribute type="xs:string" use="optional" name="windowAfter"/>
 *       &lt;xs:attribute type="xs:string" use="optional" name="windowBefore"/>
 *       &lt;xs:attribute type="xs:boolean" use="optional" name="crossDateInd"/>
 *     &lt;/xs:extension>
 *   &lt;/xs:simpleContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class TimeWindow implements Serializable
{
    private Date dateTime;
    private String windowAfter;
    private String windowBefore;
    private Boolean crossDateInd;

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public Date getDateTime() {
        return dateTime;
    }

    /** 
     * Set the extension value.
     * 
     * @param dateTime
     */
    public void setDateTime(Date dateTime) {
        this.dateTime = dateTime;
    }

    /** 
     * Get the 'windowAfter' attribute value. A period of time that can be applied to the base date/time resulting in a
                              later range of time.
                          
     * 
     * @return value
     */
    public String getWindowAfter() {
        return windowAfter;
    }

    /** 
     * Set the 'windowAfter' attribute value. A period of time that can be applied to the base date/time resulting in a
                              later range of time.
                          
     * 
     * @param windowAfter
     */
    public void setWindowAfter(String windowAfter) {
        this.windowAfter = windowAfter;
    }

    /** 
     * Get the 'windowBefore' attribute value. A period of time that can be applied to the base date/time resulting in an
                              earlier range of time.
                          
     * 
     * @return value
     */
    public String getWindowBefore() {
        return windowBefore;
    }

    /** 
     * Set the 'windowBefore' attribute value. A period of time that can be applied to the base date/time resulting in an
                              earlier range of time.
                          
     * 
     * @param windowBefore
     */
    public void setWindowBefore(String windowBefore) {
        this.windowBefore = windowBefore;
    }

    /** 
     * Get the 'crossDateInd' attribute value. If true, the requested period may extend over the previous or following day.
                              If false, the search period is restricted to the date/time specified.
                          Note that this indicator is typically used when the window duration is in
                              hours.
                          
     * 
     * @return value
     */
    public Boolean getCrossDateInd() {
        return crossDateInd;
    }

    /** 
     * Set the 'crossDateInd' attribute value. If true, the requested period may extend over the previous or following day.
                              If false, the search period is restricted to the date/time specified.
                          Note that this indicator is typically used when the window duration is in
                              hours.
                          
     * 
     * @param crossDateInd
     */
    public void setCrossDateInd(Boolean crossDateInd) {
        this.crossDateInd = crossDateInd;
    }
}
