
package org.opentravel.common.v02;

import java.io.Serializable;

/** 
 * Summary transaction initiator information.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://opentravel.org/common/v02" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TransactionInitiator">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:InitiatorID" name="ID" minOccurs="1"/>
 *     &lt;xs:element type="ns:Enum_UniqueID_Type" name="Type" minOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class TransactionInitiator1 implements Serializable
{
    private InitiatorID ID;
    private EnumUniqueIDType type;

    /** 
     * Get the 'ID' element value. A unique identifier for the requestor or sender of the message with other
                          metadata related to the ID.
                      
     * 
     * @return value
     */
    public InitiatorID getID() {
        return ID;
    }

    /** 
     * Set the 'ID' element value. A unique identifier for the requestor or sender of the message with other
                          metadata related to the ID.
                      
     * 
     * @param ID
     */
    public void setID(InitiatorID ID) {
        this.ID = ID;
    }

    /** 
     * Get the 'Type' element value. An extensible list of requestor or sender types.This type should be known between trading partners.
     * 
     * @return value
     */
    public EnumUniqueIDType getType() {
        return type;
    }

    /** 
     * Set the 'Type' element value. An extensible list of requestor or sender types.This type should be known between trading partners.
     * 
     * @param type
     */
    public void setType(EnumUniqueIDType type) {
        this.type = type;
    }
}
