
package org.opentravel.ns.ota2.appinfov0100;

import java.io.Serializable;
import java.util.Date;

/** 
 * 
 Used in the schema/wsdl-level Appinfo element to annotate the compiler version, source, and compilation date.

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.OpenTravel.org/ns/OTA2/AppInfo_v01_00" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Library">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="ProjectName" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="ServiceName" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="LibraryName" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="LibraryVersion" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="SourceFile" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="CompilerVersion" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="xs:dateTime" name="CompileDate" minOccurs="1" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class Library implements Serializable
{
    private String projectName;
    private String serviceName;
    private String libraryName;
    private String libraryVersion;
    private String sourceFile;
    private String compilerVersion;
    private Date compileDate;

    /** 
     * Get the 'ProjectName' element value.
     * 
     * @return value
     */
    public String getProjectName() {
        return projectName;
    }

    /** 
     * Set the 'ProjectName' element value.
     * 
     * @param projectName
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    /** 
     * Get the 'ServiceName' element value.
     * 
     * @return value
     */
    public String getServiceName() {
        return serviceName;
    }

    /** 
     * Set the 'ServiceName' element value.
     * 
     * @param serviceName
     */
    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    /** 
     * Get the 'LibraryName' element value.
     * 
     * @return value
     */
    public String getLibraryName() {
        return libraryName;
    }

    /** 
     * Set the 'LibraryName' element value.
     * 
     * @param libraryName
     */
    public void setLibraryName(String libraryName) {
        this.libraryName = libraryName;
    }

    /** 
     * Get the 'LibraryVersion' element value.
     * 
     * @return value
     */
    public String getLibraryVersion() {
        return libraryVersion;
    }

    /** 
     * Set the 'LibraryVersion' element value.
     * 
     * @param libraryVersion
     */
    public void setLibraryVersion(String libraryVersion) {
        this.libraryVersion = libraryVersion;
    }

    /** 
     * Get the 'SourceFile' element value.
     * 
     * @return value
     */
    public String getSourceFile() {
        return sourceFile;
    }

    /** 
     * Set the 'SourceFile' element value.
     * 
     * @param sourceFile
     */
    public void setSourceFile(String sourceFile) {
        this.sourceFile = sourceFile;
    }

    /** 
     * Get the 'CompilerVersion' element value.
     * 
     * @return value
     */
    public String getCompilerVersion() {
        return compilerVersion;
    }

    /** 
     * Set the 'CompilerVersion' element value.
     * 
     * @param compilerVersion
     */
    public void setCompilerVersion(String compilerVersion) {
        this.compilerVersion = compilerVersion;
    }

    /** 
     * Get the 'CompileDate' element value.
     * 
     * @return value
     */
    public Date getCompileDate() {
        return compileDate;
    }

    /** 
     * Set the 'CompileDate' element value.
     * 
     * @param compileDate
     */
    public void setCompileDate(Date compileDate) {
        this.compileDate = compileDate;
    }
}
