
package org.opentravel.otm.common.v0;

import java.io.Serializable;

/** 
 * Month of year types
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://www.opentravel.org/OTM/Common/v0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Enum_MonthOfYear">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="January"/>
 *     &lt;xs:enumeration value="February"/>
 *     &lt;xs:enumeration value="March"/>
 *     &lt;xs:enumeration value="April"/>
 *     &lt;xs:enumeration value="May"/>
 *     &lt;xs:enumeration value="June"/>
 *     &lt;xs:enumeration value="July"/>
 *     &lt;xs:enumeration value="August"/>
 *     &lt;xs:enumeration value="September"/>
 *     &lt;xs:enumeration value="October"/>
 *     &lt;xs:enumeration value="November"/>
 *     &lt;xs:enumeration value="December"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum EnumMonthOfYear implements Serializable {
    JANUARY("January"), FEBRUARY("February"), MARCH("March"), APRIL("April"), MAY(
            "May"), JUNE("June"), JULY("July"), AUGUST("August"), SEPTEMBER(
            "September"), OCTOBER("October"), NOVEMBER("November"), DECEMBER(
            "December");
    private final String value;

    private EnumMonthOfYear(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static EnumMonthOfYear convert(String value) {
        for (EnumMonthOfYear inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
