
package org.w3.xmldsig;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.w3.org/2000/09/xmldsig#" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DSAKeyValueType">
 *   &lt;xs:sequence>
 *     &lt;xs:sequence minOccurs="0">
 *       &lt;!-- Reference to inner class Sequence -->
 *     &lt;/xs:sequence>
 *     &lt;xs:element type="xs:base64Binary" name="G" minOccurs="0"/>
 *     &lt;xs:element type="xs:base64Binary" name="Y"/>
 *     &lt;xs:element type="xs:base64Binary" name="J" minOccurs="0"/>
 *     &lt;xs:sequence minOccurs="0">
 *       &lt;!-- Reference to inner class Sequence1 -->
 *     &lt;/xs:sequence>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class DSAKeyValueType implements Serializable
{
    private Sequence P;
    private byte[] G;
    private byte[] Y;
    private byte[] J;
    private Sequence1 seed;

    /** 
     * Get the sequence value.
     * 
     * @return value
     */
    public Sequence getP() {
        return P;
    }

    /** 
     * Set the sequence value.
     * 
     * @param p
     */
    public void setP(Sequence p) {
        P = p;
    }

    /** 
     * Get the 'G' element value.
     * 
     * @return value
     */
    public byte[] getG() {
        return G;
    }

    /** 
     * Set the 'G' element value.
     * 
     * @param g
     */
    public void setG(byte[] g) {
        G = g;
    }

    /** 
     * Get the 'Y' element value.
     * 
     * @return value
     */
    public byte[] getY() {
        return Y;
    }

    /** 
     * Set the 'Y' element value.
     * 
     * @param y
     */
    public void setY(byte[] y) {
        Y = y;
    }

    /** 
     * Get the 'J' element value.
     * 
     * @return value
     */
    public byte[] getJ() {
        return J;
    }

    /** 
     * Set the 'J' element value.
     * 
     * @param j
     */
    public void setJ(byte[] j) {
        J = j;
    }

    /** 
     * Get the sequence value.
     * 
     * @return value
     */
    public Sequence1 getSeed() {
        return seed;
    }

    /** 
     * Set the sequence value.
     * 
     * @param seed
     */
    public void setSeed(Sequence1 seed) {
        this.seed = seed;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:sequence xmlns:xs="http://www.w3.org/2001/XMLSchema" minOccurs="0">
     *   &lt;xs:element type="xs:base64Binary" name="P"/>
     *   &lt;xs:element type="xs:base64Binary" name="Q"/>
     * &lt;/xs:sequence>
     * </pre>
     */
    public static class Sequence implements Serializable
    {
        private byte[] P;
        private byte[] Q;

        /** 
         * Get the 'P' element value.
         * 
         * @return value
         */
        public byte[] getP() {
            return P;
        }

        /** 
         * Set the 'P' element value.
         * 
         * @param p
         */
        public void setP(byte[] p) {
            P = p;
        }

        /** 
         * Get the 'Q' element value.
         * 
         * @return value
         */
        public byte[] getQ() {
            return Q;
        }

        /** 
         * Set the 'Q' element value.
         * 
         * @param q
         */
        public void setQ(byte[] q) {
            Q = q;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:sequence xmlns:xs="http://www.w3.org/2001/XMLSchema" minOccurs="0">
     *   &lt;xs:element type="xs:base64Binary" name="Seed"/>
     *   &lt;xs:element type="xs:base64Binary" name="PgenCounter"/>
     * &lt;/xs:sequence>
     * </pre>
     */
    public static class Sequence1 implements Serializable
    {
        private byte[] seed;
        private byte[] pgenCounter;

        /** 
         * Get the 'Seed' element value.
         * 
         * @return value
         */
        public byte[] getSeed() {
            return seed;
        }

        /** 
         * Set the 'Seed' element value.
         * 
         * @param seed
         */
        public void setSeed(byte[] seed) {
            this.seed = seed;
        }

        /** 
         * Get the 'PgenCounter' element value.
         * 
         * @return value
         */
        public byte[] getPgenCounter() {
            return pgenCounter;
        }

        /** 
         * Set the 'PgenCounter' element value.
         * 
         * @param pgenCounter
         */
        public void setPgenCounter(byte[] pgenCounter) {
            this.pgenCounter = pgenCounter;
        }
    }
}
