
package org.w3.xmldsig;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.w3.org/2000/09/xmldsig#" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ManifestType">
 *   &lt;xs:sequence>
 *     &lt;xs:element ref="ns:Reference" maxOccurs="unbounded"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="optional" name="Id"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ManifestType implements Serializable
{
    private List<ReferenceType> referenceList = new ArrayList<ReferenceType>();
    private String id;

    /** 
     * Get the list of 'Reference' element items.
     * 
     * @return list
     */
    public List<ReferenceType> getReferenceList() {
        return referenceList;
    }

    /** 
     * Set the list of 'Reference' element items.
     * 
     * @param list
     */
    public void setReferenceList(List<ReferenceType> list) {
        referenceList = list;
    }

    /** 
     * Get the 'Id' attribute value.
     * 
     * @return value
     */
    public String getId() {
        return id;
    }

    /** 
     * Set the 'Id' attribute value.
     * 
     * @param id
     */
    public void setId(String id) {
        this.id = id;
    }
}
