
package org.w3.xmldsig;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.w3.org/2000/09/xmldsig#" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PGPDataType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:base64Binary" name="PGPKeyID"/>
 *     &lt;xs:element type="xs:base64Binary" name="PGPKeyPacket" minOccurs="0"/>
 *     &lt;xs:any minOccurs="0" maxOccurs="unbounded" processContents="lax" namespace="##other"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PGPDataType implements Serializable
{
    private byte[] PGPKeyID;
    private byte[] PGPKeyPacket;
    private List<Element> anyList = new ArrayList<Element>();

    /** 
     * Get the 'PGPKeyID' element value.
     * 
     * @return value
     */
    public byte[] getPGPKeyID() {
        return PGPKeyID;
    }

    /** 
     * Set the 'PGPKeyID' element value.
     * 
     * @param PGPKeyID
     */
    public void setPGPKeyID(byte[] PGPKeyID) {
        this.PGPKeyID = PGPKeyID;
    }

    /** 
     * Get the 'PGPKeyPacket' element value.
     * 
     * @return value
     */
    public byte[] getPGPKeyPacket() {
        return PGPKeyPacket;
    }

    /** 
     * Set the 'PGPKeyPacket' element value.
     * 
     * @param PGPKeyPacket
     */
    public void setPGPKeyPacket(byte[] PGPKeyPacket) {
        this.PGPKeyPacket = PGPKeyPacket;
    }

    /** 
     * Get the list of any items.
     * 
     * @return list
     */
    public List<Element> getAnyList() {
        return anyList;
    }

    /** 
     * Set the list of any items.
     * 
     * @param list
     */
    public void setAnyList(List<Element> list) {
        anyList = list;
    }
}
