
package org.w3.xmldsig;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.w3.org/2000/09/xmldsig#" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SPKIDataType">
 *   &lt;xs:sequence maxOccurs="unbounded">
 *     &lt;!-- Reference to inner class Sequence -->
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class SPKIDataType implements Serializable
{
    private List<Sequence> SPKISexpList = new ArrayList<Sequence>();

    /** 
     * Get the list of 'SPKIDataType' complexType items.
     * 
     * @return list
     */
    public List<Sequence> getSPKISexpList() {
        return SPKISexpList;
    }

    /** 
     * Set the list of 'SPKIDataType' complexType items.
     * 
     * @param list
     */
    public void setSPKISexpList(List<Sequence> list) {
        SPKISexpList = list;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:sequence xmlns:xs="http://www.w3.org/2001/XMLSchema" maxOccurs="unbounded">
     *   &lt;xs:element type="xs:base64Binary" name="SPKISexp"/>
     *   &lt;xs:any minOccurs="0" processContents="lax" namespace="##other"/>
     * &lt;/xs:sequence>
     * </pre>
     */
    public static class Sequence implements Serializable
    {
        private byte[] SPKISexp;
        private Element any;

        /** 
         * Get the 'SPKISexp' element value.
         * 
         * @return value
         */
        public byte[] getSPKISexp() {
            return SPKISexp;
        }

        /** 
         * Set the 'SPKISexp' element value.
         * 
         * @param SPKISexp
         */
        public void setSPKISexp(byte[] SPKISexp) {
            this.SPKISexp = SPKISexp;
        }

        /** 
         * Get the any value.
         * 
         * @return value
         */
        public Element getAny() {
            return any;
        }

        /** 
         * Set the any value.
         * 
         * @param any
         */
        public void setAny(Element any) {
            this.any = any;
        }
    }
}
