
package org.w3.xmldsig;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.w3.org/2000/09/xmldsig#" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SignatureType">
 *   &lt;xs:sequence>
 *     &lt;xs:element ref="ns:SignedInfo"/>
 *     &lt;xs:element ref="ns:SignatureValue"/>
 *     &lt;xs:element ref="ns:KeyInfo" minOccurs="0"/>
 *     &lt;xs:element ref="ns:Object" minOccurs="0" maxOccurs="unbounded"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="optional" name="Id"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class SignatureType implements Serializable
{
    private SignedInfoType signedInfo;
    private SignatureValueType signatureValue;
    private KeyInfoType keyInfo;
    private List<ObjectType> objectList = new ArrayList<ObjectType>();
    private String id;

    /** 
     * Get the 'SignedInfo' element value.
     * 
     * @return value
     */
    public SignedInfoType getSignedInfo() {
        return signedInfo;
    }

    /** 
     * Set the 'SignedInfo' element value.
     * 
     * @param signedInfo
     */
    public void setSignedInfo(SignedInfoType signedInfo) {
        this.signedInfo = signedInfo;
    }

    /** 
     * Get the 'SignatureValue' element value.
     * 
     * @return value
     */
    public SignatureValueType getSignatureValue() {
        return signatureValue;
    }

    /** 
     * Set the 'SignatureValue' element value.
     * 
     * @param signatureValue
     */
    public void setSignatureValue(SignatureValueType signatureValue) {
        this.signatureValue = signatureValue;
    }

    /** 
     * Get the 'KeyInfo' element value.
     * 
     * @return value
     */
    public KeyInfoType getKeyInfo() {
        return keyInfo;
    }

    /** 
     * Set the 'KeyInfo' element value.
     * 
     * @param keyInfo
     */
    public void setKeyInfo(KeyInfoType keyInfo) {
        this.keyInfo = keyInfo;
    }

    /** 
     * Get the list of 'Object' element items.
     * 
     * @return list
     */
    public List<ObjectType> getObjectList() {
        return objectList;
    }

    /** 
     * Set the list of 'Object' element items.
     * 
     * @param list
     */
    public void setObjectList(List<ObjectType> list) {
        objectList = list;
    }

    /** 
     * Get the 'Id' attribute value.
     * 
     * @return value
     */
    public String getId() {
        return id;
    }

    /** 
     * Set the 'Id' attribute value.
     * 
     * @param id
     */
    public void setId(String id) {
        this.id = id;
    }
}
