
package org.w3.xmldsig;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.w3.org/2000/09/xmldsig#" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SignedInfoType">
 *   &lt;xs:sequence>
 *     &lt;xs:element ref="ns:CanonicalizationMethod"/>
 *     &lt;xs:element ref="ns:SignatureMethod"/>
 *     &lt;xs:element ref="ns:Reference" maxOccurs="unbounded"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="optional" name="Id"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class SignedInfoType implements Serializable
{
    private CanonicalizationMethodType canonicalizationMethod;
    private SignatureMethodType signatureMethod;
    private List<ReferenceType> referenceList = new ArrayList<ReferenceType>();
    private String id;

    /** 
     * Get the 'CanonicalizationMethod' element value.
     * 
     * @return value
     */
    public CanonicalizationMethodType getCanonicalizationMethod() {
        return canonicalizationMethod;
    }

    /** 
     * Set the 'CanonicalizationMethod' element value.
     * 
     * @param canonicalizationMethod
     */
    public void setCanonicalizationMethod(
            CanonicalizationMethodType canonicalizationMethod) {
        this.canonicalizationMethod = canonicalizationMethod;
    }

    /** 
     * Get the 'SignatureMethod' element value.
     * 
     * @return value
     */
    public SignatureMethodType getSignatureMethod() {
        return signatureMethod;
    }

    /** 
     * Set the 'SignatureMethod' element value.
     * 
     * @param signatureMethod
     */
    public void setSignatureMethod(SignatureMethodType signatureMethod) {
        this.signatureMethod = signatureMethod;
    }

    /** 
     * Get the list of 'Reference' element items.
     * 
     * @return list
     */
    public List<ReferenceType> getReferenceList() {
        return referenceList;
    }

    /** 
     * Set the list of 'Reference' element items.
     * 
     * @param list
     */
    public void setReferenceList(List<ReferenceType> list) {
        referenceList = list;
    }

    /** 
     * Get the 'Id' attribute value.
     * 
     * @return value
     */
    public String getId() {
        return id;
    }

    /** 
     * Set the 'Id' attribute value.
     * 
     * @param id
     */
    public void setId(String id) {
        this.id = id;
    }
}
