
package org.w3.xmldsig;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.w3.org/2000/09/xmldsig#" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="X509DataType">
 *   &lt;xs:sequence>
 *     &lt;xs:choice maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class Choice -->
 *     &lt;/xs:choice>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class X509DataType implements Serializable
{
    private List<Choice> choiceList = new ArrayList<Choice>();

    /** 
     * Get the list of 'X509DataType' complexType items.
     * 
     * @return list
     */
    public List<Choice> getChoiceList() {
        return choiceList;
    }

    /** 
     * Set the list of 'X509DataType' complexType items.
     * 
     * @param list
     */
    public void setChoiceList(List<Choice> list) {
        choiceList = list;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:choice xmlns:ns="http://www.w3.org/2000/09/xmldsig#" xmlns:xs="http://www.w3.org/2001/XMLSchema" maxOccurs="unbounded">
     *   &lt;xs:element type="ns:X509IssuerSerialType" name="X509IssuerSerial"/>
     *   &lt;xs:element type="xs:base64Binary" name="X509SKI"/>
     *   &lt;xs:element type="xs:string" name="X509SubjectName"/>
     *   &lt;xs:element type="xs:base64Binary" name="X509Certificate"/>
     *   &lt;xs:element type="xs:base64Binary" name="X509CRL"/>
     *   &lt;xs:any processContents="lax" namespace="##other"/>
     * &lt;/xs:choice>
     * </pre>
     */
    public static class Choice implements Serializable
    {
        private int choiceListSelect = -1;
        private static final int X509_ISSUER_SERIAL_CHOICE = 0;
        private static final int X509_SKI_CHOICE = 1;
        private static final int X509_SUBJECT_NAME_CHOICE = 2;
        private static final int X509_CERTIFICATE_CHOICE = 3;
        private static final int X509_CRL_CHOICE = 4;
        private static final int ANY_CHOICE = 5;
        private X509IssuerSerialType x509IssuerSerial;
        private byte[] x509SKI;
        private String x509SubjectName;
        private byte[] x509Certificate;
        private byte[] x509CRL;
        private Element any;

        private void setChoiceListSelect(int choice) {
            if (choiceListSelect == -1) {
                choiceListSelect = choice;
            } else if (choiceListSelect != choice) {
                throw new IllegalStateException(
                        "Need to call clearChoiceListSelect() before changing existing choice");
            }
        }

        /** 
         * Clear the choice selection.
         */
        public void clearChoiceListSelect() {
            choiceListSelect = -1;
        }

        /** 
         * Check if X509IssuerSerial is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifX509IssuerSerial() {
            return choiceListSelect == X509_ISSUER_SERIAL_CHOICE;
        }

        /** 
         * Get the 'X509IssuerSerial' element value.
         * 
         * @return value
         */
        public X509IssuerSerialType getX509IssuerSerial() {
            return x509IssuerSerial;
        }

        /** 
         * Set the 'X509IssuerSerial' element value.
         * 
         * @param x509IssuerSerial
         */
        public void setX509IssuerSerial(X509IssuerSerialType x509IssuerSerial) {
            setChoiceListSelect(X509_ISSUER_SERIAL_CHOICE);
            this.x509IssuerSerial = x509IssuerSerial;
        }

        /** 
         * Check if X509SKI is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifX509SKI() {
            return choiceListSelect == X509_SKI_CHOICE;
        }

        /** 
         * Get the 'X509SKI' element value.
         * 
         * @return value
         */
        public byte[] getX509SKI() {
            return x509SKI;
        }

        /** 
         * Set the 'X509SKI' element value.
         * 
         * @param x509SKI
         */
        public void setX509SKI(byte[] x509SKI) {
            setChoiceListSelect(X509_SKI_CHOICE);
            this.x509SKI = x509SKI;
        }

        /** 
         * Check if X509SubjectName is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifX509SubjectName() {
            return choiceListSelect == X509_SUBJECT_NAME_CHOICE;
        }

        /** 
         * Get the 'X509SubjectName' element value.
         * 
         * @return value
         */
        public String getX509SubjectName() {
            return x509SubjectName;
        }

        /** 
         * Set the 'X509SubjectName' element value.
         * 
         * @param x509SubjectName
         */
        public void setX509SubjectName(String x509SubjectName) {
            setChoiceListSelect(X509_SUBJECT_NAME_CHOICE);
            this.x509SubjectName = x509SubjectName;
        }

        /** 
         * Check if X509Certificate is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifX509Certificate() {
            return choiceListSelect == X509_CERTIFICATE_CHOICE;
        }

        /** 
         * Get the 'X509Certificate' element value.
         * 
         * @return value
         */
        public byte[] getX509Certificate() {
            return x509Certificate;
        }

        /** 
         * Set the 'X509Certificate' element value.
         * 
         * @param x509Certificate
         */
        public void setX509Certificate(byte[] x509Certificate) {
            setChoiceListSelect(X509_CERTIFICATE_CHOICE);
            this.x509Certificate = x509Certificate;
        }

        /** 
         * Check if X509CRL is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifX509CRL() {
            return choiceListSelect == X509_CRL_CHOICE;
        }

        /** 
         * Get the 'X509CRL' element value.
         * 
         * @return value
         */
        public byte[] getX509CRL() {
            return x509CRL;
        }

        /** 
         * Set the 'X509CRL' element value.
         * 
         * @param x509CRL
         */
        public void setX509CRL(byte[] x509CRL) {
            setChoiceListSelect(X509_CRL_CHOICE);
            this.x509CRL = x509CRL;
        }

        /** 
         * Check if Any is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifAny() {
            return choiceListSelect == ANY_CHOICE;
        }

        /** 
         * Get the any value.
         * 
         * @return value
         */
        public Element getAny() {
            return any;
        }

        /** 
         * Set the any value.
         * 
         * @param any
         */
        public void setAny(Element any) {
            setChoiceListSelect(ANY_CHOICE);
            this.any = any;
        }
    }
}
