
package org.xmlsoap.schemas.ws.secext;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://schemas.xmlsoap.org/ws/2002/12/secext" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Security">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element name="UsernameToken" minOccurs="0">
 *         &lt;!-- Reference to inner class UsernameToken -->
 *       &lt;/xs:element>
 *       &lt;xs:element type="xs:string" name="SabreAth" minOccurs="0"/>
 *       &lt;xs:element type="xs:string" name="BinarySecurityToken" minOccurs="0"/>
 *     &lt;/xs:sequence>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class Security implements Serializable
{
    private UsernameToken usernameToken;
    private String sabreAth;
    private String binarySecurityToken;

    /** 
     * Get the 'UsernameToken' element value.
     * 
     * @return value
     */
    public UsernameToken getUsernameToken() {
        return usernameToken;
    }

    /** 
     * Set the 'UsernameToken' element value.
     * 
     * @param usernameToken
     */
    public void setUsernameToken(UsernameToken usernameToken) {
        this.usernameToken = usernameToken;
    }

    /** 
     * Get the 'SabreAth' element value.
     * 
     * @return value
     */
    public String getSabreAth() {
        return sabreAth;
    }

    /** 
     * Set the 'SabreAth' element value.
     * 
     * @param sabreAth
     */
    public void setSabreAth(String sabreAth) {
        this.sabreAth = sabreAth;
    }

    /** 
     * Get the 'BinarySecurityToken' element value.
     * 
     * @return value
     */
    public String getBinarySecurityToken() {
        return binarySecurityToken;
    }

    /** 
     * Set the 'BinarySecurityToken' element value.
     * 
     * @param binarySecurityToken
     */
    public void setBinarySecurityToken(String binarySecurityToken) {
        this.binarySecurityToken = binarySecurityToken;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://schemas.xmlsoap.org/ws/2002/12/secext" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="UsernameToken" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="Username" minOccurs="0"/>
     *       &lt;xs:element type="xs:string" name="Password" minOccurs="0"/>
     *       &lt;xs:element type="xs:string" name="NewPassword" minOccurs="0" maxOccurs="2"/>
     *       &lt;xs:element type="xs:string" form="unqualified" name="Organization" minOccurs="0"/>
     *       &lt;xs:element type="xs:string" form="unqualified" name="Domain" minOccurs="0"/>
     *       &lt;xs:element type="xs:string" form="unqualified" name="Lniata" minOccurs="0"/>
     *       &lt;xs:element type="xs:string" form="unqualified" name="LockId" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class UsernameToken implements Serializable
    {
        private String username;
        private String password;
        private List<String> newPasswordList = new ArrayList<String>();
        private String organization;
        private String domain;
        private String lniata;
        private String lockId;

        /** 
         * Get the 'Username' element value.
         * 
         * @return value
         */
        public String getUsername() {
            return username;
        }

        /** 
         * Set the 'Username' element value.
         * 
         * @param username
         */
        public void setUsername(String username) {
            this.username = username;
        }

        /** 
         * Get the 'Password' element value.
         * 
         * @return value
         */
        public String getPassword() {
            return password;
        }

        /** 
         * Set the 'Password' element value.
         * 
         * @param password
         */
        public void setPassword(String password) {
            this.password = password;
        }

        /** 
         * Get the list of 'NewPassword' element items.
         * 
         * @return list
         */
        public List<String> getNewPasswordList() {
            return newPasswordList;
        }

        /** 
         * Set the list of 'NewPassword' element items.
         * 
         * @param list
         */
        public void setNewPasswordList(List<String> list) {
            newPasswordList = list;
        }

        /** 
         * Get the 'Organization' element value.
         * 
         * @return value
         */
        public String getOrganization() {
            return organization;
        }

        /** 
         * Set the 'Organization' element value.
         * 
         * @param organization
         */
        public void setOrganization(String organization) {
            this.organization = organization;
        }

        /** 
         * Get the 'Domain' element value.
         * 
         * @return value
         */
        public String getDomain() {
            return domain;
        }

        /** 
         * Set the 'Domain' element value.
         * 
         * @param domain
         */
        public void setDomain(String domain) {
            this.domain = domain;
        }

        /** 
         * Get the 'Lniata' element value.
         * 
         * @return value
         */
        public String getLniata() {
            return lniata;
        }

        /** 
         * Set the 'Lniata' element value.
         * 
         * @param lniata
         */
        public void setLniata(String lniata) {
            this.lniata = lniata;
        }

        /** 
         * Get the 'LockId' element value.
         * 
         * @return value
         */
        public String getLockId() {
            return lockId;
        }

        /** 
         * Set the 'LockId' element value.
         * 
         * @param lockId
         */
        public void setLockId(String lockId) {
            this.lockId = lockId;
        }
    }
}
