
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ALaCarteOfferItemType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="Eligibility">
 *       &lt;xs:complexType>
 *         &lt;xs:sequence>
 *           &lt;xs:element name="PassengerRefs" minOccurs="0">
 *             &lt;!-- Reference to inner class PassengerRefs -->
 *           &lt;/xs:element>
 *           &lt;xs:element name="SegmentRefs" minOccurs="0">
 *             &lt;!-- Reference to inner class SegmentRefs -->
 *           &lt;/xs:element>
 *           &lt;xs:element type="xs:string" name="PriceClassRefs" minOccurs="0"/>
 *         &lt;/xs:sequence>
 *       &lt;/xs:complexType>
 *     &lt;/xs:element>
 *     &lt;xs:element name="UnitPriceDetail">
 *       &lt;xs:complexType>
 *         &lt;xs:sequence>
 *           &lt;xs:element name="TotalAmount">
 *             &lt;xs:complexType>
 *               &lt;xs:choice>
 *                 &lt;xs:element ref="ns:AwardPricing"/>
 *                 &lt;xs:element ref="ns:CombinationPricing"/>
 *                 &lt;xs:element ref="ns:DetailCurrencyPrice"/>
 *                 &lt;xs:element ref="ns:EncodedCurrencyPrice"/>
 *                 &lt;xs:element ref="ns:SimpleCurrencyPrice"/>
 *               &lt;/xs:choice>
 *             &lt;/xs:complexType>
 *           &lt;/xs:element>
 *           &lt;xs:element type="ns:CurrencyAmountOptType" name="BaseAmount" minOccurs="0"/>
 *           &lt;xs:element ref="ns:FareFiledIn" minOccurs="0"/>
 *           &lt;xs:element type="ns:DiscountType" name="Discount" minOccurs="0"/>
 *           &lt;xs:element name="Surcharges" minOccurs="0">
 *             &lt;!-- Reference to inner class Surcharges -->
 *           &lt;/xs:element>
 *           &lt;xs:element type="ns:TaxDetailType" name="Taxes" minOccurs="0"/>
 *           &lt;xs:element ref="ns:TaxExemption" minOccurs="0"/>
 *           &lt;xs:choice minOccurs="0">
 *             &lt;!-- Reference to inner class Choice -->
 *           &lt;/xs:choice>
 *           &lt;xs:element type="ns:FeeSurchargeType" name="Fees" minOccurs="0"/>
 *         &lt;/xs:sequence>
 *       &lt;/xs:complexType>
 *     &lt;/xs:element>
 *     &lt;xs:element name="Service">
 *       &lt;xs:complexType>
 *         &lt;xs:sequence>
 *           &lt;xs:element type="xs:string" name="ServiceRef" minOccurs="0"/>
 *           &lt;xs:element type="xs:string" name="ServiceDefinitionRef"/>
 *         &lt;/xs:sequence>
 *         &lt;xs:attribute type="xs:string" use="required" name="ServiceID"/>
 *       &lt;/xs:complexType>
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="required" name="OfferItemID"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ALaCarteOfferItemType implements Serializable
{
    private PassengerRefs passengerRefs;
    private SegmentRefs segmentRefs;
    private String eligibilityPriceClassRefs;
    private int unitPriceDetailTotalAmountSelect = -1;
    private static final int UNIT_PRICE_DETAIL_AWARD_PRICING_CHOICE = 0;
    private static final int UNIT_PRICE_DETAIL_COMBINATION_PRICING_CHOICE = 1;
    private static final int UNIT_PRICE_DETAIL_DETAIL_CURRENCY_PRICE_CHOICE = 2;
    private static final int UNIT_PRICE_DETAIL_ENCODED_CURRENCY_PRICE_CHOICE = 3;
    private static final int UNIT_PRICE_DETAIL_SIMPLE_CURRENCY_PRICE_CHOICE = 4;
    private AwardPriceUnitType unitPriceDetailAwardPricing;
    private CombinationPriceType unitPriceDetailCombinationPricing;
    private DetailCurrencyPriceType unitPriceDetailDetailCurrencyPrice;
    private EncodedCurrencyPrice unitPriceDetailEncodedCurrencyPrice;
    private SimpleCurrencyPrice unitPriceDetailSimpleCurrencyPrice;
    private CurrencyAmountOptType unitPriceDetailBaseAmount;
    private FareFilingType unitPriceDetailFareFiledIn;
    private DiscountType unitPriceDetailDiscount;
    private Surcharges surcharges;
    private TaxDetailType unitPriceDetailTaxes;
    private TaxExemptionType unitPriceDetailTaxExemption;
    private Choice choice;
    private FeeSurchargeType unitPriceDetailFees;
    private String serviceServiceRef;
    private String serviceServiceDefinitionRef;
    private String serviceServiceID;
    private String offerItemID;

    /** 
     * Get the 'PassengerRefs' element value. Refers to the Passengers, Price class or Segments for which this offer item is eligible.
     * 
     * @return value
     */
    public PassengerRefs getPassengerRefs() {
        return passengerRefs;
    }

    /** 
     * Set the 'PassengerRefs' element value. Refers to the Passengers, Price class or Segments for which this offer item is eligible.
     * 
     * @param passengerRefs
     */
    public void setPassengerRefs(PassengerRefs passengerRefs) {
        this.passengerRefs = passengerRefs;
    }

    /** 
     * Get the 'SegmentRefs' element value. Refers to the Passengers, Price class or Segments for which this offer item is eligible.
     * 
     * @return value
     */
    public SegmentRefs getSegmentRefs() {
        return segmentRefs;
    }

    /** 
     * Set the 'SegmentRefs' element value. Refers to the Passengers, Price class or Segments for which this offer item is eligible.
     * 
     * @param segmentRefs
     */
    public void setSegmentRefs(SegmentRefs segmentRefs) {
        this.segmentRefs = segmentRefs;
    }

    /** 
     * Get the 'PriceClassRefs' element value.
     * 
     * @return value
     */
    public String getEligibilityPriceClassRefs() {
        return eligibilityPriceClassRefs;
    }

    /** 
     * Set the 'PriceClassRefs' element value.
     * 
     * @param eligibilityPriceClassRefs
     */
    public void setEligibilityPriceClassRefs(String eligibilityPriceClassRefs) {
        this.eligibilityPriceClassRefs = eligibilityPriceClassRefs;
    }

    private void setUnitPriceDetailTotalAmountSelect(int choice) {
        if (unitPriceDetailTotalAmountSelect == -1) {
            unitPriceDetailTotalAmountSelect = choice;
        } else if (unitPriceDetailTotalAmountSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearUnitPriceDetailTotalAmountSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearUnitPriceDetailTotalAmountSelect() {
        unitPriceDetailTotalAmountSelect = -1;
    }

    /** 
     * Check if UnitPriceDetailAwardPricing is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifUnitPriceDetailAwardPricing() {
        return unitPriceDetailTotalAmountSelect == UNIT_PRICE_DETAIL_AWARD_PRICING_CHOICE;
    }

    /** 
     * Get the 'AwardPricing' element value.
     * 
     * @return value
     */
    public AwardPriceUnitType getUnitPriceDetailAwardPricing() {
        return unitPriceDetailAwardPricing;
    }

    /** 
     * Set the 'AwardPricing' element value.
     * 
     * @param unitPriceDetailAwardPricing
     */
    public void setUnitPriceDetailAwardPricing(
            AwardPriceUnitType unitPriceDetailAwardPricing) {
        setUnitPriceDetailTotalAmountSelect(UNIT_PRICE_DETAIL_AWARD_PRICING_CHOICE);
        this.unitPriceDetailAwardPricing = unitPriceDetailAwardPricing;
    }

    /** 
     * Check if UnitPriceDetailCombinationPricing is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifUnitPriceDetailCombinationPricing() {
        return unitPriceDetailTotalAmountSelect == UNIT_PRICE_DETAIL_COMBINATION_PRICING_CHOICE;
    }

    /** 
     * Get the 'CombinationPricing' element value.
     * 
     * @return value
     */
    public CombinationPriceType getUnitPriceDetailCombinationPricing() {
        return unitPriceDetailCombinationPricing;
    }

    /** 
     * Set the 'CombinationPricing' element value.
     * 
     * @param unitPriceDetailCombinationPricing
     */
    public void setUnitPriceDetailCombinationPricing(
            CombinationPriceType unitPriceDetailCombinationPricing) {
        setUnitPriceDetailTotalAmountSelect(UNIT_PRICE_DETAIL_COMBINATION_PRICING_CHOICE);
        this.unitPriceDetailCombinationPricing = unitPriceDetailCombinationPricing;
    }

    /** 
     * Check if UnitPriceDetailDetailCurrencyPrice is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifUnitPriceDetailDetailCurrencyPrice() {
        return unitPriceDetailTotalAmountSelect == UNIT_PRICE_DETAIL_DETAIL_CURRENCY_PRICE_CHOICE;
    }

    /** 
     * Get the 'DetailCurrencyPrice' element value.
     * 
     * @return value
     */
    public DetailCurrencyPriceType getUnitPriceDetailDetailCurrencyPrice() {
        return unitPriceDetailDetailCurrencyPrice;
    }

    /** 
     * Set the 'DetailCurrencyPrice' element value.
     * 
     * @param unitPriceDetailDetailCurrencyPrice
     */
    public void setUnitPriceDetailDetailCurrencyPrice(
            DetailCurrencyPriceType unitPriceDetailDetailCurrencyPrice) {
        setUnitPriceDetailTotalAmountSelect(UNIT_PRICE_DETAIL_DETAIL_CURRENCY_PRICE_CHOICE);
        this.unitPriceDetailDetailCurrencyPrice = unitPriceDetailDetailCurrencyPrice;
    }

    /** 
     * Check if UnitPriceDetailEncodedCurrencyPrice is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifUnitPriceDetailEncodedCurrencyPrice() {
        return unitPriceDetailTotalAmountSelect == UNIT_PRICE_DETAIL_ENCODED_CURRENCY_PRICE_CHOICE;
    }

    /** 
     * Get the 'EncodedCurrencyPrice' element value.
     * 
     * @return value
     */
    public EncodedCurrencyPrice getUnitPriceDetailEncodedCurrencyPrice() {
        return unitPriceDetailEncodedCurrencyPrice;
    }

    /** 
     * Set the 'EncodedCurrencyPrice' element value.
     * 
     * @param unitPriceDetailEncodedCurrencyPrice
     */
    public void setUnitPriceDetailEncodedCurrencyPrice(
            EncodedCurrencyPrice unitPriceDetailEncodedCurrencyPrice) {
        setUnitPriceDetailTotalAmountSelect(UNIT_PRICE_DETAIL_ENCODED_CURRENCY_PRICE_CHOICE);
        this.unitPriceDetailEncodedCurrencyPrice = unitPriceDetailEncodedCurrencyPrice;
    }

    /** 
     * Check if UnitPriceDetailSimpleCurrencyPrice is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifUnitPriceDetailSimpleCurrencyPrice() {
        return unitPriceDetailTotalAmountSelect == UNIT_PRICE_DETAIL_SIMPLE_CURRENCY_PRICE_CHOICE;
    }

    /** 
     * Get the 'SimpleCurrencyPrice' element value.
     * 
     * @return value
     */
    public SimpleCurrencyPrice getUnitPriceDetailSimpleCurrencyPrice() {
        return unitPriceDetailSimpleCurrencyPrice;
    }

    /** 
     * Set the 'SimpleCurrencyPrice' element value.
     * 
     * @param unitPriceDetailSimpleCurrencyPrice
     */
    public void setUnitPriceDetailSimpleCurrencyPrice(
            SimpleCurrencyPrice unitPriceDetailSimpleCurrencyPrice) {
        setUnitPriceDetailTotalAmountSelect(UNIT_PRICE_DETAIL_SIMPLE_CURRENCY_PRICE_CHOICE);
        this.unitPriceDetailSimpleCurrencyPrice = unitPriceDetailSimpleCurrencyPrice;
    }

    /** 
     * Get the 'BaseAmount' element value. Total Base Fare Amount.  Example: 200000

    Note: This includes  surcharges (if applicable).
     * 
     * @return value
     */
    public CurrencyAmountOptType getUnitPriceDetailBaseAmount() {
        return unitPriceDetailBaseAmount;
    }

    /** 
     * Set the 'BaseAmount' element value. Total Base Fare Amount.  Example: 200000

    Note: This includes  surcharges (if applicable).
     * 
     * @param unitPriceDetailBaseAmount
     */
    public void setUnitPriceDetailBaseAmount(
            CurrencyAmountOptType unitPriceDetailBaseAmount) {
        this.unitPriceDetailBaseAmount = unitPriceDetailBaseAmount;
    }

    /** 
     * Get the 'FareFiledIn' element value.
     * 
     * @return value
     */
    public FareFilingType getUnitPriceDetailFareFiledIn() {
        return unitPriceDetailFareFiledIn;
    }

    /** 
     * Set the 'FareFiledIn' element value.
     * 
     * @param unitPriceDetailFareFiledIn
     */
    public void setUnitPriceDetailFareFiledIn(
            FareFilingType unitPriceDetailFareFiledIn) {
        this.unitPriceDetailFareFiledIn = unitPriceDetailFareFiledIn;
    }

    /** 
     * Get the 'Discount' element value. Discount Information
     * 
     * @return value
     */
    public DiscountType getUnitPriceDetailDiscount() {
        return unitPriceDetailDiscount;
    }

    /** 
     * Set the 'Discount' element value. Discount Information
     * 
     * @param unitPriceDetailDiscount
     */
    public void setUnitPriceDetailDiscount(DiscountType unitPriceDetailDiscount) {
        this.unitPriceDetailDiscount = unitPriceDetailDiscount;
    }

    /** 
     * Get the 'Surcharges' element value. Flat price for an individual unit of the referenced Service.
     * 
     * @return value
     */
    public Surcharges getSurcharges() {
        return surcharges;
    }

    /** 
     * Set the 'Surcharges' element value. Flat price for an individual unit of the referenced Service.
     * 
     * @param surcharges
     */
    public void setSurcharges(Surcharges surcharges) {
        this.surcharges = surcharges;
    }

    /** 
     * Get the 'Taxes' element value. Ticket Tax/fee/charge details to indicate taxes that apply to country of commencement of travel and routing.
     * 
     * @return value
     */
    public TaxDetailType getUnitPriceDetailTaxes() {
        return unitPriceDetailTaxes;
    }

    /** 
     * Set the 'Taxes' element value. Ticket Tax/fee/charge details to indicate taxes that apply to country of commencement of travel and routing.
     * 
     * @param unitPriceDetailTaxes
     */
    public void setUnitPriceDetailTaxes(TaxDetailType unitPriceDetailTaxes) {
        this.unitPriceDetailTaxes = unitPriceDetailTaxes;
    }

    /** 
     * Get the 'TaxExemption' element value.
     * 
     * @return value
     */
    public TaxExemptionType getUnitPriceDetailTaxExemption() {
        return unitPriceDetailTaxExemption;
    }

    /** 
     * Set the 'TaxExemption' element value.
     * 
     * @param unitPriceDetailTaxExemption
     */
    public void setUnitPriceDetailTaxExemption(
            TaxExemptionType unitPriceDetailTaxExemption) {
        this.unitPriceDetailTaxExemption = unitPriceDetailTaxExemption;
    }

    /** 
     * Get the choice value. Flat price for an individual unit of the referenced Service.
     * 
     * @return value
     */
    public Choice getChoice() {
        return choice;
    }

    /** 
     * Set the choice value. Flat price for an individual unit of the referenced Service.
     * 
     * @param choice
     */
    public void setChoice(Choice choice) {
        this.choice = choice;
    }

    /** 
     * Get the 'Fees' element value. Individual fee/ surcharge information would appear on the accountable document.
     * 
     * @return value
     */
    public FeeSurchargeType getUnitPriceDetailFees() {
        return unitPriceDetailFees;
    }

    /** 
     * Set the 'Fees' element value. Individual fee/ surcharge information would appear on the accountable document.
     * 
     * @param unitPriceDetailFees
     */
    public void setUnitPriceDetailFees(FeeSurchargeType unitPriceDetailFees) {
        this.unitPriceDetailFees = unitPriceDetailFees;
    }

    /** 
     * Get the 'ServiceRef' element value. Create dependencies with parent services to which this particular Service is linked. Can reference ServiceItems across different OfferItems within the same Offer.
     * 
     * @return value
     */
    public String getServiceServiceRef() {
        return serviceServiceRef;
    }

    /** 
     * Set the 'ServiceRef' element value. Create dependencies with parent services to which this particular Service is linked. Can reference ServiceItems across different OfferItems within the same Offer.
     * 
     * @param serviceServiceRef
     */
    public void setServiceServiceRef(String serviceServiceRef) {
        this.serviceServiceRef = serviceServiceRef;
    }

    /** 
     * Get the 'ServiceDefinitionRef' element value.
     * 
     * @return value
     */
    public String getServiceServiceDefinitionRef() {
        return serviceServiceDefinitionRef;
    }

    /** 
     * Set the 'ServiceDefinitionRef' element value.
     * 
     * @param serviceServiceDefinitionRef
     */
    public void setServiceServiceDefinitionRef(
            String serviceServiceDefinitionRef) {
        this.serviceServiceDefinitionRef = serviceServiceDefinitionRef;
    }

    /** 
     * Get the 'ServiceID' attribute value. Unique identifier for this Service instance. 
     * 
     * @return value
     */
    public String getServiceServiceID() {
        return serviceServiceID;
    }

    /** 
     * Set the 'ServiceID' attribute value. Unique identifier for this Service instance. 
     * 
     * @param serviceServiceID
     */
    public void setServiceServiceID(String serviceServiceID) {
        this.serviceServiceID = serviceServiceID;
    }

    /** 
     * Get the 'OfferItemID' attribute value. Unique identifier for this OfferItem instance. Must be unique within XML message. Exceeding 64 characters or use of dashes is not recommended.
     * 
     * @return value
     */
    public String getOfferItemID() {
        return offerItemID;
    }

    /** 
     * Set the 'OfferItemID' attribute value. Unique identifier for this OfferItem instance. Must be unique within XML message. Exceeding 64 characters or use of dashes is not recommended.
     * 
     * @param offerItemID
     */
    public void setOfferItemID(String offerItemID) {
        this.offerItemID = offerItemID;
    }
    /** 
     * Reference to the passengers who are elibigle for this Offer Item
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PassengerRefs" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:simpleContent>
     *       &lt;xs:extension base="xs:string">
     *         &lt;xs:attribute type="xs:boolean" name="AnyPassengerInd"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:simpleContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class PassengerRefs implements Serializable
    {
        private String string;
        private Boolean anyPassengerInd;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public String getString() {
            return string;
        }

        /** 
         * Set the extension value.
         * 
         * @param string
         */
        public void setString(String string) {
            this.string = string;
        }

        /** 
         * Get the 'AnyPassengerInd' attribute value. If 'true', this service applies to any passenger
         * 
         * @return value
         */
        public Boolean getAnyPassengerInd() {
            return anyPassengerInd;
        }

        /** 
         * Set the 'AnyPassengerInd' attribute value. If 'true', this service applies to any passenger
         * 
         * @param anyPassengerInd
         */
        public void setAnyPassengerInd(Boolean anyPassengerInd) {
            this.anyPassengerInd = anyPassengerInd;
        }
    }
    /** 
     * Reference to the flight segments on which this Offer Item can be provided.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SegmentRefs" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:simpleContent>
     *       &lt;xs:extension base="xs:string">
     *         &lt;xs:attribute type="xs:boolean" name="AnySegmentInd"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:simpleContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class SegmentRefs implements Serializable
    {
        private String string;
        private Boolean anySegmentInd;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public String getString() {
            return string;
        }

        /** 
         * Set the extension value.
         * 
         * @param string
         */
        public void setString(String string) {
            this.string = string;
        }

        /** 
         * Get the 'AnySegmentInd' attribute value. If 'true', this service applies to any segment
         * 
         * @return value
         */
        public Boolean getAnySegmentInd() {
            return anySegmentInd;
        }

        /** 
         * Set the 'AnySegmentInd' attribute value. If 'true', this service applies to any segment
         * 
         * @param anySegmentInd
         */
        public void setAnySegmentInd(Boolean anySegmentInd) {
            this.anySegmentInd = anySegmentInd;
        }
    }
    /** 
     * Applicable Surcharge(s).
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Surcharges" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="ns:FeeSurchargeType" name="Surcharge" maxOccurs="unbounded"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Surcharges implements Serializable
    {
        private List<FeeSurchargeType> surchargeList = new ArrayList<FeeSurchargeType>();

        /** 
         * Get the list of 'Surcharge' element items. Surcharge detail.
         * 
         * @return list
         */
        public List<FeeSurchargeType> getSurchargeList() {
            return surchargeList;
        }

        /** 
         * Set the list of 'Surcharge' element items. Surcharge detail.
         * 
         * @param list
         */
        public void setSurchargeList(List<FeeSurchargeType> list) {
            surchargeList = list;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:choice xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" minOccurs="0">
     *   &lt;xs:element type="ns:AwardPriceUnitType" name="AwardPricing" minOccurs="0"/>
     *   &lt;xs:element type="ns:CombinationPriceType" name="CombinationPricing" minOccurs="0"/>
     * &lt;/xs:choice>
     * </pre>
     */
    public static class Choice implements Serializable
    {
        private int choiceSelect = -1;
        private static final int AWARD_PRICING_CHOICE = 0;
        private static final int COMBINATION_PRICING_CHOICE = 1;
        private AwardPriceUnitType awardPricing;
        private CombinationPriceType combinationPricing;

        private void setChoiceSelect(int choice) {
            if (choiceSelect == -1) {
                choiceSelect = choice;
            } else if (choiceSelect != choice) {
                throw new IllegalStateException(
                        "Need to call clearChoiceSelect() before changing existing choice");
            }
        }

        /** 
         * Clear the choice selection.
         */
        public void clearChoiceSelect() {
            choiceSelect = -1;
        }

        /** 
         * Check if AwardPricing is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifAwardPricing() {
            return choiceSelect == AWARD_PRICING_CHOICE;
        }

        /** 
         * Get the 'AwardPricing' element value. AWARD (Redemption Unit-based) Pricing information.
         * 
         * @return value
         */
        public AwardPriceUnitType getAwardPricing() {
            return awardPricing;
        }

        /** 
         * Set the 'AwardPricing' element value. AWARD (Redemption Unit-based) Pricing information.
         * 
         * @param awardPricing
         */
        public void setAwardPricing(AwardPriceUnitType awardPricing) {
            setChoiceSelect(AWARD_PRICING_CHOICE);
            this.awardPricing = awardPricing;
        }

        /** 
         * Check if CombinationPricing is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifCombinationPricing() {
            return choiceSelect == COMBINATION_PRICING_CHOICE;
        }

        /** 
         * Get the 'CombinationPricing' element value. PARTIAL CURRENCY and AWARD Pricing Combination information.
         * 
         * @return value
         */
        public CombinationPriceType getCombinationPricing() {
            return combinationPricing;
        }

        /** 
         * Set the 'CombinationPricing' element value. PARTIAL CURRENCY and AWARD Pricing Combination information.
         * 
         * @param combinationPricing
         */
        public void setCombinationPricing(
                CombinationPriceType combinationPricing) {
            setChoiceSelect(COMBINATION_PRICING_CHOICE);
            this.combinationPricing = combinationPricing;
        }
    }
}
