
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;

/** 
 * CORE ADDRESS representation.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AddressCoreType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="Address">
 *       &lt;xs:complexType>
 *         &lt;xs:sequence>
 *           &lt;xs:element ref="ns:PaymentAddress"/>
 *           &lt;xs:element ref="ns:SimpleAddress"/>
 *           &lt;xs:element ref="ns:StructuredAddress"/>
 *         &lt;/xs:sequence>
 *       &lt;/xs:complexType>
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 *   &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class AddressCoreType implements Serializable
{
    private PaymentAddrType addressPaymentAddress;
    private SimpleAddrType addressSimpleAddress;
    private StructuredAddress addressStructuredAddress;
    private String refs;

    /** 
     * Get the 'PaymentAddress' element value.
     * 
     * @return value
     */
    public PaymentAddrType getAddressPaymentAddress() {
        return addressPaymentAddress;
    }

    /** 
     * Set the 'PaymentAddress' element value.
     * 
     * @param addressPaymentAddress
     */
    public void setAddressPaymentAddress(PaymentAddrType addressPaymentAddress) {
        this.addressPaymentAddress = addressPaymentAddress;
    }

    /** 
     * Get the 'SimpleAddress' element value.
     * 
     * @return value
     */
    public SimpleAddrType getAddressSimpleAddress() {
        return addressSimpleAddress;
    }

    /** 
     * Set the 'SimpleAddress' element value.
     * 
     * @param addressSimpleAddress
     */
    public void setAddressSimpleAddress(SimpleAddrType addressSimpleAddress) {
        this.addressSimpleAddress = addressSimpleAddress;
    }

    /** 
     * Get the 'StructuredAddress' element value.
     * 
     * @return value
     */
    public StructuredAddress getAddressStructuredAddress() {
        return addressStructuredAddress;
    }

    /** 
     * Set the 'StructuredAddress' element value.
     * 
     * @param addressStructuredAddress
     */
    public void setAddressStructuredAddress(
            StructuredAddress addressStructuredAddress) {
        this.addressStructuredAddress = addressStructuredAddress;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getRefs() {
        return refs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param refs
     */
    public void setRefs(String refs) {
        this.refs = refs;
    }
}
