
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * A data type for ADDRESS Metadata.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AddressMetadataType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:MetadataObjectBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:element ref="ns:Position" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" name="AddressType" minOccurs="0"/>
 *         &lt;xs:element name="AddressFields" minOccurs="0">
 *           &lt;!-- Reference to inner class AddressFields -->
 *         &lt;/xs:element>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class AddressMetadataType extends MetadataObjectBaseType implements
    Serializable
{
    private PositionType position;
    private String addressType;
    private AddressFields addressFields;

    /** 
     * Get the 'Position' element value.
     * 
     * @return value
     */
    public PositionType getPosition() {
        return position;
    }

    /** 
     * Set the 'Position' element value.
     * 
     * @param position
     */
    public void setPosition(PositionType position) {
        this.position = position;
    }

    /** 
     * Get the 'AddressType' element value. type of address eg Billing, Business, Home
     * 
     * @return value
     */
    public String getAddressType() {
        return addressType;
    }

    /** 
     * Set the 'AddressType' element value. type of address eg Billing, Business, Home
     * 
     * @param addressType
     */
    public void setAddressType(String addressType) {
        this.addressType = addressType;
    }

    /** 
     * Get the 'AddressFields' element value.
     * 
     * @return value
     */
    public AddressFields getAddressFields() {
        return addressFields;
    }

    /** 
     * Set the 'AddressFields' element value.
     * 
     * @param addressFields
     */
    public void setAddressFields(AddressFields addressFields) {
        this.addressFields = addressFields;
    }
    /** 
     * list of address fields required by vendor
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AddressFields" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="FieldName" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class FieldName -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class AddressFields implements Serializable
    {
        private List<FieldName> fieldNameList = new ArrayList<FieldName>();

        /** 
         * Get the list of 'FieldName' element items.
         * 
         * @return list
         */
        public List<FieldName> getFieldNameList() {
            return fieldNameList;
        }

        /** 
         * Set the list of 'FieldName' element items.
         * 
         * @param list
         */
        public void setFieldNameList(List<FieldName> list) {
            fieldNameList = list;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FieldName" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:simpleContent>
         *       &lt;xs:extension base="xs:string">
         *         &lt;xs:attribute type="xs:boolean" use="required" name="Mandatory"/>
         *       &lt;/xs:extension>
         *     &lt;/xs:simpleContent>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class FieldName implements Serializable
        {
            private String string;
            private Boolean mandatory;

            /** 
             * Get the extension value.
             * 
             * @return value
             */
            public String getString() {
                return string;
            }

            /** 
             * Set the extension value.
             * 
             * @param string
             */
            public void setString(String string) {
                this.string = string;
            }

            /** 
             * Get the 'Mandatory' attribute value. If this field is required then true, otherwise false.
             * 
             * @return value
             */
            public Boolean getMandatory() {
                return mandatory;
            }

            /** 
             * Set the 'Mandatory' attribute value. If this field is required then true, otherwise false.
             * 
             * @param mandatory
             */
            public void setMandatory(Boolean mandatory) {
                this.mandatory = mandatory;
            }
        }
    }
}
