
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Pre-defined and Augmented ADDRESS Metadata.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AddressMetadatas">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element ref="ns:AddressMetadata" maxOccurs="unbounded"/>
 *     &lt;/xs:sequence>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class AddressMetadatas implements Serializable
{
    private List<AddressMetadataType> addressMetadataList = new ArrayList<AddressMetadataType>();

    /** 
     * Get the list of 'AddressMetadata' element items. ADDRESS Metadata.
     * 
     * @return list
     */
    public List<AddressMetadataType> getAddressMetadataList() {
        return addressMetadataList;
    }

    /** 
     * Set the list of 'AddressMetadata' element items. ADDRESS Metadata.
     * 
     * @param list
     */
    public void setAddressMetadataList(List<AddressMetadataType> list) {
        addressMetadataList = list;
    }
}
