
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;

/** 
 * A data type for Advanced Purchase list constraint.

 Examples: EARLIEST, LATEST, Other
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AdvPurchListType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="EARLIEST"/>
 *     &lt;xs:enumeration value="LATEST"/>
 *     &lt;xs:enumeration value="Other"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum AdvPurchListType implements Serializable {
    EARLIEST("EARLIEST"), LATEST("LATEST"), OTHER("Other");
    private final String value;

    private AdvPurchListType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static AdvPurchListType convert(String value) {
        for (AdvPurchListType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
