
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;

/** 
 * Information relating to published fare rules that define the time prior to the flight departure that a reservation must be made, or a ticket must be issued.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AdvanceTicketing">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element name="AdvanceReservation">
 *         &lt;xs:complexType>
 *           &lt;xs:simpleContent>
 *             &lt;xs:extension base="xs:string">
 *               &lt;xs:attribute type="xs:string" name="Context"/>
 *             &lt;/xs:extension>
 *           &lt;/xs:simpleContent>
 *         &lt;/xs:complexType>
 *       &lt;/xs:element>
 *       &lt;xs:element name="AdvanceDeparture">
 *         &lt;xs:complexType>
 *           &lt;xs:simpleContent>
 *             &lt;xs:extension base="xs:string">
 *               &lt;xs:attribute type="xs:string" name="Context"/>
 *             &lt;/xs:extension>
 *           &lt;/xs:simpleContent>
 *         &lt;/xs:complexType>
 *       &lt;/xs:element>
 *     &lt;/xs:sequence>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class AdvanceTicketing implements Serializable
{
    private String advanceReservationString;
    private String advanceReservationContext;
    private String advanceDepartureString;
    private String advanceDepartureContext;

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public String getAdvanceReservationString() {
        return advanceReservationString;
    }

    /** 
     * Set the extension value.
     * 
     * @param advanceReservationString
     */
    public void setAdvanceReservationString(String advanceReservationString) {
        this.advanceReservationString = advanceReservationString;
    }

    /** 
     * Get the 'Context' attribute value. Restriction context. Example: EARLIEST, LATEST, Other
     * 
     * @return value
     */
    public String getAdvanceReservationContext() {
        return advanceReservationContext;
    }

    /** 
     * Set the 'Context' attribute value. Restriction context. Example: EARLIEST, LATEST, Other
     * 
     * @param advanceReservationContext
     */
    public void setAdvanceReservationContext(String advanceReservationContext) {
        this.advanceReservationContext = advanceReservationContext;
    }

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public String getAdvanceDepartureString() {
        return advanceDepartureString;
    }

    /** 
     * Set the extension value.
     * 
     * @param advanceDepartureString
     */
    public void setAdvanceDepartureString(String advanceDepartureString) {
        this.advanceDepartureString = advanceDepartureString;
    }

    /** 
     * Get the 'Context' attribute value. Restriction context. Example: EARLIEST, LATEST, Other
     * 
     * @return value
     */
    public String getAdvanceDepartureContext() {
        return advanceDepartureContext;
    }

    /** 
     * Set the 'Context' attribute value. Restriction context. Example: EARLIEST, LATEST, Other
     * 
     * @param advanceDepartureContext
     */
    public void setAdvanceDepartureContext(String advanceDepartureContext) {
        this.advanceDepartureContext = advanceDepartureContext;
    }
}
