
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * The AirDocDisplay transaction set requests an Airline to return flight (ET) and/or ancillary (EMD) document details.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AirDocDisplayRQ">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element ref="ns:PointOfSale" minOccurs="0"/>
 *       &lt;xs:element ref="ns:Document"/>
 *       &lt;xs:element ref="ns:Party"/>
 *       &lt;xs:element name="Query">
 *         &lt;xs:complexType>
 *           &lt;xs:sequence>
 *             &lt;xs:element name="DisplayCriteria" minOccurs="0">
 *               &lt;!-- Reference to inner class DisplayCriteria -->
 *             &lt;/xs:element>
 *             &lt;xs:element name="Flight" minOccurs="0">
 *               &lt;!-- Reference to inner class Flight -->
 *             &lt;/xs:element>
 *             &lt;xs:element type="ns:TicketDocumentType" name="TicketDocument" minOccurs="0" maxOccurs="unbounded"/>
 *             &lt;xs:element type="ns:CouponOrderKeyType" name="OrderID" minOccurs="0"/>
 *             &lt;xs:element type="ns:TravelerFQTV_Type" name="FQTV" minOccurs="0"/>
 *             &lt;xs:element type="ns:TravelerFOID_Type" name="FOID" minOccurs="0"/>
 *             &lt;xs:element ref="ns:BookingReferences" minOccurs="0"/>
 *             &lt;xs:element name="DataLists" minOccurs="0">
 *               &lt;!-- Reference to inner class DataLists -->
 *             &lt;/xs:element>
 *           &lt;/xs:sequence>
 *         &lt;/xs:complexType>
 *       &lt;/xs:element>
 *     &lt;/xs:sequence>
 *     &lt;xs:attributeGroup ref="ns:IATA_PayloadStdAttributes"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class AirDocDisplayRQ implements Serializable
{
    private PointOfSaleType pointOfSale;
    private MsgDocumentType document;
    private MsgPartiesType party;
    private DisplayCriteria displayCriteria;
    private Flight flight;
    private List<TicketDocumentType> queryTicketDocumentList = new ArrayList<TicketDocumentType>();
    private CouponOrderKeyType queryOrderID;
    private TravelerFQTVType queryFQTV;
    private TravelerFOIDType queryFOID;
    private BookingReferences queryBookingReferences;
    private DataLists dataLists;
    private IATAPayloadStdAttributes IATAPayloadStdAttributes;

    /** 
     * Get the 'PointOfSale' element value.
     * 
     * @return value
     */
    public PointOfSaleType getPointOfSale() {
        return pointOfSale;
    }

    /** 
     * Set the 'PointOfSale' element value.
     * 
     * @param pointOfSale
     */
    public void setPointOfSale(PointOfSaleType pointOfSale) {
        this.pointOfSale = pointOfSale;
    }

    /** 
     * Get the 'Document' element value.
     * 
     * @return value
     */
    public MsgDocumentType getDocument() {
        return document;
    }

    /** 
     * Set the 'Document' element value.
     * 
     * @param document
     */
    public void setDocument(MsgDocumentType document) {
        this.document = document;
    }

    /** 
     * Get the 'Party' element value.
     * 
     * @return value
     */
    public MsgPartiesType getParty() {
        return party;
    }

    /** 
     * Set the 'Party' element value.
     * 
     * @param party
     */
    public void setParty(MsgPartiesType party) {
        this.party = party;
    }

    /** 
     * Get the 'DisplayCriteria' element value. Air Document Display Request Query.
     * 
     * @return value
     */
    public DisplayCriteria getDisplayCriteria() {
        return displayCriteria;
    }

    /** 
     * Set the 'DisplayCriteria' element value. Air Document Display Request Query.
     * 
     * @param displayCriteria
     */
    public void setDisplayCriteria(DisplayCriteria displayCriteria) {
        this.displayCriteria = displayCriteria;
    }

    /** 
     * Get the 'Flight' element value. Air Document Display Request Query.
     * 
     * @return value
     */
    public Flight getFlight() {
        return flight;
    }

    /** 
     * Set the 'Flight' element value. Air Document Display Request Query.
     * 
     * @param flight
     */
    public void setFlight(Flight flight) {
        this.flight = flight;
    }

    /** 
     * Get the list of 'TicketDocument' element items. The ticket/document number to be displayed.
     * 
     * @return list
     */
    public List<TicketDocumentType> getQueryTicketDocumentList() {
        return queryTicketDocumentList;
    }

    /** 
     * Set the list of 'TicketDocument' element items. The ticket/document number to be displayed.
     * 
     * @param list
     */
    public void setQueryTicketDocumentList(List<TicketDocumentType> list) {
        queryTicketDocumentList = list;
    }

    /** 
     * Get the 'OrderID' element value. The order id for which a ticket/document is requested.
     * 
     * @return value
     */
    public CouponOrderKeyType getQueryOrderID() {
        return queryOrderID;
    }

    /** 
     * Set the 'OrderID' element value. The order id for which a ticket/document is requested.
     * 
     * @param queryOrderID
     */
    public void setQueryOrderID(CouponOrderKeyType queryOrderID) {
        this.queryOrderID = queryOrderID;
    }

    /** 
     * Get the 'FQTV' element value. The frequent flier information  for which a ticket/document is requested.
     * 
     * @return value
     */
    public TravelerFQTVType getQueryFQTV() {
        return queryFQTV;
    }

    /** 
     * Set the 'FQTV' element value. The frequent flier information  for which a ticket/document is requested.
     * 
     * @param queryFQTV
     */
    public void setQueryFQTV(TravelerFQTVType queryFQTV) {
        this.queryFQTV = queryFQTV;
    }

    /** 
     * Get the 'FOID' element value. Passenger check in information for which a ticket/document is requested.
     * 
     * @return value
     */
    public TravelerFOIDType getQueryFOID() {
        return queryFOID;
    }

    /** 
     * Set the 'FOID' element value. Passenger check in information for which a ticket/document is requested.
     * 
     * @param queryFOID
     */
    public void setQueryFOID(TravelerFOIDType queryFOID) {
        this.queryFOID = queryFOID;
    }

    /** 
     * Get the 'BookingReferences' element value.
     * 
     * @return value
     */
    public BookingReferences getQueryBookingReferences() {
        return queryBookingReferences;
    }

    /** 
     * Set the 'BookingReferences' element value.
     * 
     * @param queryBookingReferences
     */
    public void setQueryBookingReferences(
            BookingReferences queryBookingReferences) {
        this.queryBookingReferences = queryBookingReferences;
    }

    /** 
     * Get the 'DataLists' element value. Air Document Display Request Query.
     * 
     * @return value
     */
    public DataLists getDataLists() {
        return dataLists;
    }

    /** 
     * Set the 'DataLists' element value. Air Document Display Request Query.
     * 
     * @param dataLists
     */
    public void setDataLists(DataLists dataLists) {
        this.dataLists = dataLists;
    }

    /** 
     * Get the 'IATA_PayloadStdAttributes' attributeGroup value.
     * 
     * @return value
     */
    public IATAPayloadStdAttributes getIATAPayloadStdAttributes() {
        return IATAPayloadStdAttributes;
    }

    /** 
     * Set the 'IATA_PayloadStdAttributes' attributeGroup value.
     * 
     * @param IATAPayloadStdAttributes
     */
    public void setIATAPayloadStdAttributes(
            IATAPayloadStdAttributes IATAPayloadStdAttributes) {
        this.IATAPayloadStdAttributes = IATAPayloadStdAttributes;
    }
    /** 
     * Used to specify they types of documents to display when requested by other than the ticket/document number.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DisplayCriteria" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:boolean" use="optional" name="ET_OnlyInd"/>
     *     &lt;xs:attribute type="xs:boolean" use="optional" name="EMD_OnlyInd"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class DisplayCriteria implements Serializable
    {
        private Boolean ETOnlyInd;
        private Boolean EMDOnlyInd;

        /** 
         * Get the 'ET_OnlyInd' attribute value. If true, only display electronic tickets.
         * 
         * @return value
         */
        public Boolean getETOnlyInd() {
            return ETOnlyInd;
        }

        /** 
         * Set the 'ET_OnlyInd' attribute value. If true, only display electronic tickets.
         * 
         * @param ETOnlyInd
         */
        public void setETOnlyInd(Boolean ETOnlyInd) {
            this.ETOnlyInd = ETOnlyInd;
        }

        /** 
         * Get the 'EMD_OnlyInd' attribute value. When true, only display EMDs.
         * 
         * @return value
         */
        public Boolean getEMDOnlyInd() {
            return EMDOnlyInd;
        }

        /** 
         * Set the 'EMD_OnlyInd' attribute value. When true, only display EMDs.
         * 
         * @param EMDOnlyInd
         */
        public void setEMDOnlyInd(Boolean EMDOnlyInd) {
            this.EMDOnlyInd = EMDOnlyInd;
        }
    }
    /** 
     * Flight information for which a ticket/document is requested.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Flight" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element ref="ns:AirlineID"/>
     *       &lt;xs:element ref="ns:FlightNumber"/>
     *       &lt;xs:element ref="ns:DepartureDate"/>
     *       &lt;xs:element ref="ns:DepartureCode"/>
     *       &lt;xs:element ref="ns:ArrivalCode"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Flight implements Serializable
    {
        private AirlineIDType airlineID;
        private FlightNumber flightNumber;
        private DepartureDate departureDate;
        private DepartureCode departureCode;
        private ArrivalCode arrivalCode;

        /** 
         * Get the 'AirlineID' element value.
         * 
         * @return value
         */
        public AirlineIDType getAirlineID() {
            return airlineID;
        }

        /** 
         * Set the 'AirlineID' element value.
         * 
         * @param airlineID
         */
        public void setAirlineID(AirlineIDType airlineID) {
            this.airlineID = airlineID;
        }

        /** 
         * Get the 'FlightNumber' element value.
         * 
         * @return value
         */
        public FlightNumber getFlightNumber() {
            return flightNumber;
        }

        /** 
         * Set the 'FlightNumber' element value.
         * 
         * @param flightNumber
         */
        public void setFlightNumber(FlightNumber flightNumber) {
            this.flightNumber = flightNumber;
        }

        /** 
         * Get the 'DepartureDate' element value.
         * 
         * @return value
         */
        public DepartureDate getDepartureDate() {
            return departureDate;
        }

        /** 
         * Set the 'DepartureDate' element value.
         * 
         * @param departureDate
         */
        public void setDepartureDate(DepartureDate departureDate) {
            this.departureDate = departureDate;
        }

        /** 
         * Get the 'DepartureCode' element value.
         * 
         * @return value
         */
        public DepartureCode getDepartureCode() {
            return departureCode;
        }

        /** 
         * Set the 'DepartureCode' element value.
         * 
         * @param departureCode
         */
        public void setDepartureCode(DepartureCode departureCode) {
            this.departureCode = departureCode;
        }

        /** 
         * Get the 'ArrivalCode' element value.
         * 
         * @return value
         */
        public ArrivalCode getArrivalCode() {
            return arrivalCode;
        }

        /** 
         * Set the 'ArrivalCode' element value.
         * 
         * @param arrivalCode
         */
        public void setArrivalCode(ArrivalCode arrivalCode) {
            this.arrivalCode = arrivalCode;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DataLists" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="PassengerList" minOccurs="0">
     *         &lt;!-- Reference to inner class PassengerList -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="ContactList" minOccurs="0">
     *         &lt;!-- Reference to inner class ContactList -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class DataLists implements Serializable
    {
        private PassengerList passengerList;
        private ContactList contactList;

        /** 
         * Get the 'PassengerList' element value.
         * 
         * @return value
         */
        public PassengerList getPassengerList() {
            return passengerList;
        }

        /** 
         * Set the 'PassengerList' element value.
         * 
         * @param passengerList
         */
        public void setPassengerList(PassengerList passengerList) {
            this.passengerList = passengerList;
        }

        /** 
         * Get the 'ContactList' element value.
         * 
         * @return value
         */
        public ContactList getContactList() {
            return contactList;
        }

        /** 
         * Set the 'ContactList' element value.
         * 
         * @param contactList
         */
        public void setContactList(ContactList contactList) {
            this.contactList = contactList;
        }
        /** 
         * Passenger data list definition.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PassengerList" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="ns:PassengerType" name="Passenger" maxOccurs="unbounded"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class PassengerList implements Serializable
        {
            private List<PassengerType> passengerList = new ArrayList<PassengerType>();

            /** 
             * Get the list of 'Passenger' element items. Any person except members of the crew carried or to be carried with the consent of the carrier, on board of any transport vehicle such as aircraft, train, bus, ship.
             * 
             * @return list
             */
            public List<PassengerType> getPassengerList() {
                return passengerList;
            }

            /** 
             * Set the list of 'Passenger' element items. Any person except members of the crew carried or to be carried with the consent of the carrier, on board of any transport vehicle such as aircraft, train, bus, ship.
             * 
             * @param list
             */
            public void setPassengerList(List<PassengerType> list) {
                passengerList = list;
            }
        }
        /** 
         * Contact data list definition.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ContactList" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="ns:ContactInformationType" name="ContactInformation" maxOccurs="unbounded"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class ContactList implements Serializable
        {
            private List<ContactInformationType> contactInformationList = new ArrayList<ContactInformationType>();

            /** 
             * Get the list of 'ContactInformation' element items. The electronic or geographic address which a party has provided as the contact channel. For example, contact email, contact postal address, contact phone number.
             * 
             * @return list
             */
            public List<ContactInformationType> getContactInformationList() {
                return contactInformationList;
            }

            /** 
             * Set the list of 'ContactInformation' element items. The electronic or geographic address which a party has provided as the contact channel. For example, contact email, contact postal address, contact phone number.
             * 
             * @param list
             */
            public void setContactInformationList(
                    List<ContactInformationType> list) {
                contactInformationList = list;
            }
        }
    }
}
