
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * The AirDocDisplay transaction returns the results of a payment and ticketing query.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AirDocDisplayRS">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element ref="ns:Document"/>
 *       &lt;xs:choice>
 *         &lt;xs:sequence>
 *           &lt;xs:element type="ns:SuccessType" name="Success"/>
 *           &lt;xs:element type="ns:WarningsType" name="Warnings" minOccurs="0"/>
 *           &lt;xs:element name="Response">
 *             &lt;xs:complexType>
 *               &lt;xs:sequence>
 *                 &lt;xs:element ref="ns:AirDocDisplayProcessing" minOccurs="0"/>
 *                 &lt;xs:element name="TicketDocInfos" minOccurs="0">
 *                   &lt;!-- Reference to inner class TicketDocInfos -->
 *                 &lt;/xs:element>
 *                 &lt;xs:element name="DataLists" minOccurs="0">
 *                   &lt;!-- Reference to inner class DataLists -->
 *                 &lt;/xs:element>
 *               &lt;/xs:sequence>
 *             &lt;/xs:complexType>
 *           &lt;/xs:element>
 *         &lt;/xs:sequence>
 *         &lt;xs:element ref="ns:Errors"/>
 *       &lt;/xs:choice>
 *     &lt;/xs:sequence>
 *     &lt;xs:attributeGroup ref="ns:IATA_PayloadStdAttributes"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class AirDocDisplayRS implements Serializable
{
    private MsgDocumentType document;
    private int choiceSelect = -1;
    private static final int SUCCESS_CHOICE = 0;
    private static final int ERRORS_CHOICE = 1;
    private SuccessType success;
    private WarningsType warnings;
    private AirDocDisplayResProcessType responseAirDocDisplayProcessing;
    private TicketDocInfos ticketDocInfos;
    private DataLists dataLists;
    private ErrorsType errors;
    private IATAPayloadStdAttributes IATAPayloadStdAttributes;

    /** 
     * Get the 'Document' element value.
     * 
     * @return value
     */
    public MsgDocumentType getDocument() {
        return document;
    }

    /** 
     * Set the 'Document' element value.
     * 
     * @param document
     */
    public void setDocument(MsgDocumentType document) {
        this.document = document;
    }

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if Success is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifSuccess() {
        return choiceSelect == SUCCESS_CHOICE;
    }

    /** 
     * Get the 'Success' element value. The presence of the empty Success element explicitly indicates that the message succeeded.
     * 
     * @return value
     */
    public SuccessType getSuccess() {
        return success;
    }

    /** 
     * Set the 'Success' element value. The presence of the empty Success element explicitly indicates that the message succeeded.
     * 
     * @param success
     */
    public void setSuccess(SuccessType success) {
        setChoiceSelect(SUCCESS_CHOICE);
        this.success = success;
    }

    /** 
     * Get the 'Warnings' element value. Used in conjunction with the Success element to define one or more business errors.
     * 
     * @return value
     */
    public WarningsType getWarnings() {
        return warnings;
    }

    /** 
     * Set the 'Warnings' element value. Used in conjunction with the Success element to define one or more business errors.
     * 
     * @param warnings
     */
    public void setWarnings(WarningsType warnings) {
        setChoiceSelect(SUCCESS_CHOICE);
        this.warnings = warnings;
    }

    /** 
     * Get the 'AirDocDisplayProcessing' element value.
     * 
     * @return value
     */
    public AirDocDisplayResProcessType getResponseAirDocDisplayProcessing() {
        return responseAirDocDisplayProcessing;
    }

    /** 
     * Set the 'AirDocDisplayProcessing' element value.
     * 
     * @param responseAirDocDisplayProcessing
     */
    public void setResponseAirDocDisplayProcessing(
            AirDocDisplayResProcessType responseAirDocDisplayProcessing) {
        setChoiceSelect(SUCCESS_CHOICE);
        this.responseAirDocDisplayProcessing = responseAirDocDisplayProcessing;
    }

    /** 
     * Get the 'TicketDocInfos' element value. Query Results.
     * 
     * @return value
     */
    public TicketDocInfos getTicketDocInfos() {
        return ticketDocInfos;
    }

    /** 
     * Set the 'TicketDocInfos' element value. Query Results.
     * 
     * @param ticketDocInfos
     */
    public void setTicketDocInfos(TicketDocInfos ticketDocInfos) {
        setChoiceSelect(SUCCESS_CHOICE);
        this.ticketDocInfos = ticketDocInfos;
    }

    /** 
     * Get the 'DataLists' element value. Query Results.
     * 
     * @return value
     */
    public DataLists getDataLists() {
        return dataLists;
    }

    /** 
     * Set the 'DataLists' element value. Query Results.
     * 
     * @param dataLists
     */
    public void setDataLists(DataLists dataLists) {
        setChoiceSelect(SUCCESS_CHOICE);
        this.dataLists = dataLists;
    }

    /** 
     * Check if Errors is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifErrors() {
        return choiceSelect == ERRORS_CHOICE;
    }

    /** 
     * Get the 'Errors' element value.
     * 
     * @return value
     */
    public ErrorsType getErrors() {
        return errors;
    }

    /** 
     * Set the 'Errors' element value.
     * 
     * @param errors
     */
    public void setErrors(ErrorsType errors) {
        setChoiceSelect(ERRORS_CHOICE);
        this.errors = errors;
    }

    /** 
     * Get the 'IATA_PayloadStdAttributes' attributeGroup value.
     * 
     * @return value
     */
    public IATAPayloadStdAttributes getIATAPayloadStdAttributes() {
        return IATAPayloadStdAttributes;
    }

    /** 
     * Set the 'IATA_PayloadStdAttributes' attributeGroup value.
     * 
     * @param IATAPayloadStdAttributes
     */
    public void setIATAPayloadStdAttributes(
            IATAPayloadStdAttributes IATAPayloadStdAttributes) {
        this.IATAPayloadStdAttributes = IATAPayloadStdAttributes;
    }
    /** 
     * Ticket/document information
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TicketDocInfos" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="TicketDocInfo" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class TicketDocInfo -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class TicketDocInfos implements Serializable
    {
        private List<TicketDocInfo> ticketDocInfoList = new ArrayList<TicketDocInfo>();

        /** 
         * Get the list of 'TicketDocInfo' element items.
         * 
         * @return list
         */
        public List<TicketDocInfo> getTicketDocInfoList() {
            return ticketDocInfoList;
        }

        /** 
         * Set the list of 'TicketDocInfo' element items.
         * 
         * @param list
         */
        public void setTicketDocInfoList(List<TicketDocInfo> list) {
            ticketDocInfoList = list;
        }
        /** 
         * Ticket/document information.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TicketDocInfo" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="xs:string" name="PassengerReference"/>
         *       &lt;xs:element name="AgentIDs" minOccurs="0">
         *         &lt;!-- Reference to inner class AgentIDs -->
         *       &lt;/xs:element>
         *       &lt;xs:element ref="ns:IssuingAirlineInfo"/>
         *       &lt;xs:element ref="ns:BookingReferences"/>
         *       &lt;xs:element name="Payments">
         *         &lt;xs:complexType>
         *           &lt;xs:sequence>
         *             &lt;xs:element type="ns:OrderPaymentFormType" name="Payment" maxOccurs="unbounded"/>
         *           &lt;/xs:sequence>
         *         &lt;/xs:complexType>
         *       &lt;/xs:element>
         *       &lt;xs:element name="OriginDestination" minOccurs="0">
         *         &lt;!-- Reference to inner class OriginDestination -->
         *       &lt;/xs:element>
         *       &lt;xs:element type="xs:string" name="EndorsementText" minOccurs="0"/>
         *       &lt;xs:element name="AddlReferenceIDs" minOccurs="0">
         *         &lt;!-- Reference to inner class AddlReferenceIDs -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="FareInfo" minOccurs="0">
         *         &lt;!-- Reference to inner class FareInfo -->
         *       &lt;/xs:element>
         *       &lt;xs:element ref="ns:TicketDocument" maxOccurs="4"/>
         *       &lt;xs:element type="ns:ServicePriceType" name="Price" minOccurs="0"/>
         *       &lt;xs:element type="ns:CouponOrderKeyType" name="OrderReference" minOccurs="0"/>
         *       &lt;xs:element type="ns:CommissionType" name="Commission" minOccurs="0"/>
         *       &lt;xs:element ref="ns:CarrierFeeInfo" minOccurs="0"/>
         *       &lt;xs:element ref="ns:OriginalIssueInfo" minOccurs="0"/>
         *       &lt;xs:element ref="ns:PricingInfo" minOccurs="0"/>
         *       &lt;xs:element type="xs:string" name="PassengerSpecificData" minOccurs="0"/>
         *       &lt;xs:element type="ns:TaxCouponInfoType" name="TaxCouponInfo" minOccurs="0"/>
         *       &lt;xs:element type="ns:ReissuedFlownType" name="ReissuedFlown" minOccurs="0"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class TicketDocInfo implements Serializable
        {
            private String passengerReference;
            private AgentIDs agentIDs;
            private AirlineIssuanceType issuingAirlineInfo;
            private BookingReferences bookingReferences;
            private List<OrderPaymentFormType> paymentList = new ArrayList<OrderPaymentFormType>();
            private OriginDestination originDestination;
            private String endorsementText;
            private AddlReferenceIDs addlReferenceIDs;
            private FareInfo fareInfo;
            private List<TicketDocument> ticketDocumentList = new ArrayList<TicketDocument>();
            private ServicePriceType price;
            private CouponOrderKeyType orderReference;
            private CommissionType commission;
            private CarrierFeeInfoType carrierFeeInfo;
            private OriginalIssueType originalIssueInfo;
            private PricingInfoType pricingInfo;
            private String passengerSpecificData;
            private TaxCouponInfoType taxCouponInfo;
            private ReissuedFlownType reissuedFlown;

            /** 
             * Get the 'PassengerReference' element value. Association to a passenger.
             * 
             * @return value
             */
            public String getPassengerReference() {
                return passengerReference;
            }

            /** 
             * Set the 'PassengerReference' element value. Association to a passenger.
             * 
             * @param passengerReference
             */
            public void setPassengerReference(String passengerReference) {
                this.passengerReference = passengerReference;
            }

            /** 
             * Get the 'AgentIDs' element value.
             * 
             * @return value
             */
            public AgentIDs getAgentIDs() {
                return agentIDs;
            }

            /** 
             * Set the 'AgentIDs' element value.
             * 
             * @param agentIDs
             */
            public void setAgentIDs(AgentIDs agentIDs) {
                this.agentIDs = agentIDs;
            }

            /** 
             * Get the 'IssuingAirlineInfo' element value.
             * 
             * @return value
             */
            public AirlineIssuanceType getIssuingAirlineInfo() {
                return issuingAirlineInfo;
            }

            /** 
             * Set the 'IssuingAirlineInfo' element value.
             * 
             * @param issuingAirlineInfo
             */
            public void setIssuingAirlineInfo(
                    AirlineIssuanceType issuingAirlineInfo) {
                this.issuingAirlineInfo = issuingAirlineInfo;
            }

            /** 
             * Get the 'BookingReferences' element value.
             * 
             * @return value
             */
            public BookingReferences getBookingReferences() {
                return bookingReferences;
            }

            /** 
             * Set the 'BookingReferences' element value.
             * 
             * @param bookingReferences
             */
            public void setBookingReferences(BookingReferences bookingReferences) {
                this.bookingReferences = bookingReferences;
            }

            /** 
             * Get the list of 'Payment' element items. Payment information.
             * 
             * @return list
             */
            public List<OrderPaymentFormType> getPaymentList() {
                return paymentList;
            }

            /** 
             * Set the list of 'Payment' element items. Payment information.
             * 
             * @param list
             */
            public void setPaymentList(List<OrderPaymentFormType> list) {
                paymentList = list;
            }

            /** 
             * Get the 'OriginDestination' element value.
             * 
             * @return value
             */
            public OriginDestination getOriginDestination() {
                return originDestination;
            }

            /** 
             * Set the 'OriginDestination' element value.
             * 
             * @param originDestination
             */
            public void setOriginDestination(OriginDestination originDestination) {
                this.originDestination = originDestination;
            }

            /** 
             * Get the 'EndorsementText' element value. Endorsement/ Restriction text.
             * 
             * @return value
             */
            public String getEndorsementText() {
                return endorsementText;
            }

            /** 
             * Set the 'EndorsementText' element value. Endorsement/ Restriction text.
             * 
             * @param endorsementText
             */
            public void setEndorsementText(String endorsementText) {
                this.endorsementText = endorsementText;
            }

            /** 
             * Get the 'AddlReferenceIDs' element value.
             * 
             * @return value
             */
            public AddlReferenceIDs getAddlReferenceIDs() {
                return addlReferenceIDs;
            }

            /** 
             * Set the 'AddlReferenceIDs' element value.
             * 
             * @param addlReferenceIDs
             */
            public void setAddlReferenceIDs(AddlReferenceIDs addlReferenceIDs) {
                this.addlReferenceIDs = addlReferenceIDs;
            }

            /** 
             * Get the 'FareInfo' element value.
             * 
             * @return value
             */
            public FareInfo getFareInfo() {
                return fareInfo;
            }

            /** 
             * Set the 'FareInfo' element value.
             * 
             * @param fareInfo
             */
            public void setFareInfo(FareInfo fareInfo) {
                this.fareInfo = fareInfo;
            }

            /** 
             * Get the list of 'TicketDocument' element items.
             * 
             * @return list
             */
            public List<TicketDocument> getTicketDocumentList() {
                return ticketDocumentList;
            }

            /** 
             * Set the list of 'TicketDocument' element items.
             * 
             * @param list
             */
            public void setTicketDocumentList(List<TicketDocument> list) {
                ticketDocumentList = list;
            }

            /** 
             * Get the 'Price' element value. Fare Tax information.
             * 
             * @return value
             */
            public ServicePriceType getPrice() {
                return price;
            }

            /** 
             * Set the 'Price' element value. Fare Tax information.
             * 
             * @param price
             */
            public void setPrice(ServicePriceType price) {
                this.price = price;
            }

            /** 
             * Get the 'OrderReference' element value. Associated Order ID(s) information.
             * 
             * @return value
             */
            public CouponOrderKeyType getOrderReference() {
                return orderReference;
            }

            /** 
             * Set the 'OrderReference' element value. Associated Order ID(s) information.
             * 
             * @param orderReference
             */
            public void setOrderReference(CouponOrderKeyType orderReference) {
                this.orderReference = orderReference;
            }

            /** 
             * Get the 'Commission' element value. Commission information.
             * 
             * @return value
             */
            public CommissionType getCommission() {
                return commission;
            }

            /** 
             * Set the 'Commission' element value. Commission information.
             * 
             * @param commission
             */
            public void setCommission(CommissionType commission) {
                this.commission = commission;
            }

            /** 
             * Get the 'CarrierFeeInfo' element value.
             * 
             * @return value
             */
            public CarrierFeeInfoType getCarrierFeeInfo() {
                return carrierFeeInfo;
            }

            /** 
             * Set the 'CarrierFeeInfo' element value.
             * 
             * @param carrierFeeInfo
             */
            public void setCarrierFeeInfo(CarrierFeeInfoType carrierFeeInfo) {
                this.carrierFeeInfo = carrierFeeInfo;
            }

            /** 
             * Get the 'OriginalIssueInfo' element value.
             * 
             * @return value
             */
            public OriginalIssueType getOriginalIssueInfo() {
                return originalIssueInfo;
            }

            /** 
             * Set the 'OriginalIssueInfo' element value.
             * 
             * @param originalIssueInfo
             */
            public void setOriginalIssueInfo(OriginalIssueType originalIssueInfo) {
                this.originalIssueInfo = originalIssueInfo;
            }

            /** 
             * Get the 'PricingInfo' element value.
             * 
             * @return value
             */
            public PricingInfoType getPricingInfo() {
                return pricingInfo;
            }

            /** 
             * Set the 'PricingInfo' element value.
             * 
             * @param pricingInfo
             */
            public void setPricingInfo(PricingInfoType pricingInfo) {
                this.pricingInfo = pricingInfo;
            }

            /** 
             * Get the 'PassengerSpecificData' element value. Agency or airline specified information associated to the passenger. 
             * 
             * @return value
             */
            public String getPassengerSpecificData() {
                return passengerSpecificData;
            }

            /** 
             * Set the 'PassengerSpecificData' element value. Agency or airline specified information associated to the passenger. 
             * 
             * @param passengerSpecificData
             */
            public void setPassengerSpecificData(String passengerSpecificData) {
                this.passengerSpecificData = passengerSpecificData;
            }

            /** 
             * Get the 'TaxCouponInfo' element value. Used to specify tax information for a coupon.
             * 
             * @return value
             */
            public TaxCouponInfoType getTaxCouponInfo() {
                return taxCouponInfo;
            }

            /** 
             * Set the 'TaxCouponInfo' element value. Used to specify tax information for a coupon.
             * 
             * @param taxCouponInfo
             */
            public void setTaxCouponInfo(TaxCouponInfoType taxCouponInfo) {
                this.taxCouponInfo = taxCouponInfo;
            }

            /** 
             * Get the 'ReissuedFlown' element value. The reissued flown flight coupon information.
             * 
             * @return value
             */
            public ReissuedFlownType getReissuedFlown() {
                return reissuedFlown;
            }

            /** 
             * Set the 'ReissuedFlown' element value. The reissued flown flight coupon information.
             * 
             * @param reissuedFlown
             */
            public void setReissuedFlown(ReissuedFlownType reissuedFlown) {
                this.reissuedFlown = reissuedFlown;
            }
            /** 
             * Booking and Servicing Agent information.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AgentIDs" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element ref="ns:AgentID" maxOccurs="2"/>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class AgentIDs implements Serializable
            {
                private List<CouponAgentType> agentIDList = new ArrayList<CouponAgentType>();

                /** 
                 * Get the list of 'AgentID' element items.
                 * 
                 * @return list
                 */
                public List<CouponAgentType> getAgentIDList() {
                    return agentIDList;
                }

                /** 
                 * Set the list of 'AgentID' element items.
                 * 
                 * @param list
                 */
                public void setAgentIDList(List<CouponAgentType> list) {
                    agentIDList = list;
                }
            }
            /** 
             * Origin and Destination Airport/ City.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OriginDestination" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="xs:string" name="Origin"/>
             *       &lt;xs:element type="xs:string" name="Destination"/>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class OriginDestination implements Serializable
            {
                private String origin;
                private String destination;

                /** 
                 * Get the 'Origin' element value. The origin city code.
                 * 
                 * @return value
                 */
                public String getOrigin() {
                    return origin;
                }

                /** 
                 * Set the 'Origin' element value. The origin city code.
                 * 
                 * @param origin
                 */
                public void setOrigin(String origin) {
                    this.origin = origin;
                }

                /** 
                 * Get the 'Destination' element value. The destination city code.
                 * 
                 * @return value
                 */
                public String getDestination() {
                    return destination;
                }

                /** 
                 * Set the 'Destination' element value. The destination city code.
                 * 
                 * @param destination
                 */
                public void setDestination(String destination) {
                    this.destination = destination;
                }
            }
            /** 
             * Additional Reference information.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AddlReferenceIDs" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element ref="ns:AddlReferenceID" maxOccurs="5"/>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class AddlReferenceIDs implements Serializable
            {
                private List<AdditionalReferenceType> addlReferenceIDList = new ArrayList<AdditionalReferenceType>();

                /** 
                 * Get the list of 'AddlReferenceID' element items.
                 * 
                 * @return list
                 */
                public List<AdditionalReferenceType> getAddlReferenceIDList() {
                    return addlReferenceIDList;
                }

                /** 
                 * Set the list of 'AddlReferenceID' element items.
                 * 
                 * @param list
                 */
                public void setAddlReferenceIDList(
                        List<AdditionalReferenceType> list) {
                    addlReferenceIDList = list;
                }
            }
            /** 
             * Fare Information
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareInfo" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element ref="ns:BaseFare" minOccurs="0" maxOccurs="3"/>
             *       &lt;xs:element ref="ns:EquivFare" minOccurs="0" maxOccurs="3"/>
             *       &lt;xs:element type="ns:TotalFareTransactionType" name="Total" minOccurs="0" maxOccurs="3"/>
             *       &lt;xs:element type="ns:TaxDetailType" name="Taxes" minOccurs="0"/>
             *       &lt;xs:element ref="ns:UnstructuredFareCalcInfo" minOccurs="0" maxOccurs="3"/>
             *       &lt;xs:element ref="ns:FareInfo" minOccurs="0"/>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class FareInfo implements Serializable
            {
                private List<BaseFareTransactionType> baseFareList = new ArrayList<BaseFareTransactionType>();
                private List<EquivFareTransactionType> equivFareList = new ArrayList<EquivFareTransactionType>();
                private List<TotalFareTransactionType> totalList = new ArrayList<TotalFareTransactionType>();
                private TaxDetailType taxes;
                private List<UnstructuredFareCalcType> unstructuredFareCalcInfoList = new ArrayList<UnstructuredFareCalcType>();
                private ETFareInfoType fareInfo;

                /** 
                 * Get the list of 'BaseFare' element items.
                 * 
                 * @return list
                 */
                public List<BaseFareTransactionType> getBaseFareList() {
                    return baseFareList;
                }

                /** 
                 * Set the list of 'BaseFare' element items.
                 * 
                 * @param list
                 */
                public void setBaseFareList(List<BaseFareTransactionType> list) {
                    baseFareList = list;
                }

                /** 
                 * Get the list of 'EquivFare' element items.
                 * 
                 * @return list
                 */
                public List<EquivFareTransactionType> getEquivFareList() {
                    return equivFareList;
                }

                /** 
                 * Set the list of 'EquivFare' element items.
                 * 
                 * @param list
                 */
                public void setEquivFareList(List<EquivFareTransactionType> list) {
                    equivFareList = list;
                }

                /** 
                 * Get the list of 'Total' element items.
                 * 
                 * @return list
                 */
                public List<TotalFareTransactionType> getTotalList() {
                    return totalList;
                }

                /** 
                 * Set the list of 'Total' element items.
                 * 
                 * @param list
                 */
                public void setTotalList(List<TotalFareTransactionType> list) {
                    totalList = list;
                }

                /** 
                 * Get the 'Taxes' element value. Fare Tax information.
                 * 
                 * @return value
                 */
                public TaxDetailType getTaxes() {
                    return taxes;
                }

                /** 
                 * Set the 'Taxes' element value. Fare Tax information.
                 * 
                 * @param taxes
                 */
                public void setTaxes(TaxDetailType taxes) {
                    this.taxes = taxes;
                }

                /** 
                 * Get the list of 'UnstructuredFareCalcInfo' element items.
                 * 
                 * @return list
                 */
                public List<UnstructuredFareCalcType> getUnstructuredFareCalcInfoList() {
                    return unstructuredFareCalcInfoList;
                }

                /** 
                 * Set the list of 'UnstructuredFareCalcInfo' element items.
                 * 
                 * @param list
                 */
                public void setUnstructuredFareCalcInfoList(
                        List<UnstructuredFareCalcType> list) {
                    unstructuredFareCalcInfoList = list;
                }

                /** 
                 * Get the 'FareInfo' element value.
                 * 
                 * @return value
                 */
                public ETFareInfoType getFareInfo() {
                    return fareInfo;
                }

                /** 
                 * Set the 'FareInfo' element value.
                 * 
                 * @param fareInfo
                 */
                public void setFareInfo(ETFareInfoType fareInfo) {
                    this.fareInfo = fareInfo;
                }
            }
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DataLists" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="PassengerList" minOccurs="0">
     *         &lt;!-- Reference to inner class PassengerList -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="ContactList" minOccurs="0">
     *         &lt;!-- Reference to inner class ContactList -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class DataLists implements Serializable
    {
        private PassengerList passengerList;
        private ContactList contactList;

        /** 
         * Get the 'PassengerList' element value.
         * 
         * @return value
         */
        public PassengerList getPassengerList() {
            return passengerList;
        }

        /** 
         * Set the 'PassengerList' element value.
         * 
         * @param passengerList
         */
        public void setPassengerList(PassengerList passengerList) {
            this.passengerList = passengerList;
        }

        /** 
         * Get the 'ContactList' element value.
         * 
         * @return value
         */
        public ContactList getContactList() {
            return contactList;
        }

        /** 
         * Set the 'ContactList' element value.
         * 
         * @param contactList
         */
        public void setContactList(ContactList contactList) {
            this.contactList = contactList;
        }
        /** 
         * Passenger data list definition.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PassengerList" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="ns:PassengerType" name="Passenger" maxOccurs="unbounded"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class PassengerList implements Serializable
        {
            private List<PassengerType> passengerList = new ArrayList<PassengerType>();

            /** 
             * Get the list of 'Passenger' element items. Any person except members of the crew carried or to be carried with the consent of the carrier, on board of any transport vehicle such as aircraft, train, bus, ship.
             * 
             * @return list
             */
            public List<PassengerType> getPassengerList() {
                return passengerList;
            }

            /** 
             * Set the list of 'Passenger' element items. Any person except members of the crew carried or to be carried with the consent of the carrier, on board of any transport vehicle such as aircraft, train, bus, ship.
             * 
             * @param list
             */
            public void setPassengerList(List<PassengerType> list) {
                passengerList = list;
            }
        }
        /** 
         * Contact data list definition.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ContactList" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="ns:ContactInformationType" name="ContactInformation" maxOccurs="unbounded"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class ContactList implements Serializable
        {
            private List<ContactInformationType> contactInformationList = new ArrayList<ContactInformationType>();

            /** 
             * Get the list of 'ContactInformation' element items. The electronic or geographic address which a party has provided as the contact channel. For example, contact email, contact postal address, contact phone number.
             * 
             * @return list
             */
            public List<ContactInformationType> getContactInformationList() {
                return contactInformationList;
            }

            /** 
             * Set the list of 'ContactInformation' element items. The electronic or geographic address which a party has provided as the contact channel. For example, contact email, contact postal address, contact phone number.
             * 
             * @param list
             */
            public void setContactInformationList(
                    List<ContactInformationType> list) {
                contactInformationList = list;
            }
        }
    }
}
