
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;

/** 
 * The AirDocHistory transaction returns the ticket/document history.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AirDocHistoryRS">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element ref="ns:Document"/>
 *       &lt;xs:choice>
 *         &lt;xs:sequence>
 *           &lt;xs:element type="ns:SuccessType" name="Success"/>
 *           &lt;xs:element type="ns:WarningsType" name="Warnings" minOccurs="0"/>
 *           &lt;xs:element name="Response">
 *             &lt;xs:complexType>
 *               &lt;xs:sequence>
 *                 &lt;xs:element ref="ns:AirDocHistoryProcessing" minOccurs="0"/>
 *                 &lt;xs:element name="TicketDocInfo">
 *                   &lt;xs:complexType>
 *                     &lt;xs:complexContent>
 *                       &lt;xs:extension base="ns:TicketDocHistoryType">
 *                         &lt;xs:attribute type="xs:boolean" use="optional" name="ExchTicketNbrInd"/>
 *                         &lt;xs:attribute type="xs:boolean" use="optional" name="PrimaryDocInd"/>
 *                       &lt;/xs:extension>
 *                     &lt;/xs:complexContent>
 *                   &lt;/xs:complexType>
 *                 &lt;/xs:element>
 *               &lt;/xs:sequence>
 *             &lt;/xs:complexType>
 *           &lt;/xs:element>
 *         &lt;/xs:sequence>
 *         &lt;xs:element ref="ns:Errors"/>
 *       &lt;/xs:choice>
 *     &lt;/xs:sequence>
 *     &lt;xs:attributeGroup ref="ns:IATA_PayloadStdAttributes"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class AirDocHistoryRS implements Serializable
{
    private MsgDocumentType document;
    private int choiceSelect = -1;
    private static final int SUCCESS_CHOICE = 0;
    private static final int ERRORS_CHOICE = 1;
    private SuccessType success;
    private WarningsType warnings;
    private AirDocHistoryResProcessType responseAirDocHistoryProcessing;
    private TicketDocHistoryType responseTicketDocInfoTicketDocHistoryType;
    private Boolean responseTicketDocInfoExchTicketNbrInd;
    private Boolean responseTicketDocInfoPrimaryDocInd;
    private ErrorsType errors;
    private IATAPayloadStdAttributes IATAPayloadStdAttributes;

    /** 
     * Get the 'Document' element value.
     * 
     * @return value
     */
    public MsgDocumentType getDocument() {
        return document;
    }

    /** 
     * Set the 'Document' element value.
     * 
     * @param document
     */
    public void setDocument(MsgDocumentType document) {
        this.document = document;
    }

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if Success is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifSuccess() {
        return choiceSelect == SUCCESS_CHOICE;
    }

    /** 
     * Get the 'Success' element value. The presence of the empty Success element explicitly indicates that the message succeeded.
     * 
     * @return value
     */
    public SuccessType getSuccess() {
        return success;
    }

    /** 
     * Set the 'Success' element value. The presence of the empty Success element explicitly indicates that the message succeeded.
     * 
     * @param success
     */
    public void setSuccess(SuccessType success) {
        setChoiceSelect(SUCCESS_CHOICE);
        this.success = success;
    }

    /** 
     * Get the 'Warnings' element value. Used in conjunction with the Success element to define one or more business errors.
     * 
     * @return value
     */
    public WarningsType getWarnings() {
        return warnings;
    }

    /** 
     * Set the 'Warnings' element value. Used in conjunction with the Success element to define one or more business errors.
     * 
     * @param warnings
     */
    public void setWarnings(WarningsType warnings) {
        setChoiceSelect(SUCCESS_CHOICE);
        this.warnings = warnings;
    }

    /** 
     * Get the 'AirDocHistoryProcessing' element value.
     * 
     * @return value
     */
    public AirDocHistoryResProcessType getResponseAirDocHistoryProcessing() {
        return responseAirDocHistoryProcessing;
    }

    /** 
     * Set the 'AirDocHistoryProcessing' element value.
     * 
     * @param responseAirDocHistoryProcessing
     */
    public void setResponseAirDocHistoryProcessing(
            AirDocHistoryResProcessType responseAirDocHistoryProcessing) {
        setChoiceSelect(SUCCESS_CHOICE);
        this.responseAirDocHistoryProcessing = responseAirDocHistoryProcessing;
    }

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public TicketDocHistoryType getResponseTicketDocInfoTicketDocHistoryType() {
        return responseTicketDocInfoTicketDocHistoryType;
    }

    /** 
     * Set the extension value.
     * 
     * @param responseTicketDocInfoTicketDocHistoryType
     */
    public void setResponseTicketDocInfoTicketDocHistoryType(
            TicketDocHistoryType responseTicketDocInfoTicketDocHistoryType) {
        setChoiceSelect(SUCCESS_CHOICE);
        this.responseTicketDocInfoTicketDocHistoryType = responseTicketDocInfoTicketDocHistoryType;
    }

    /** 
     * Get the 'ExchTicketNbrInd' attribute value. When true, this is the ticket/document number for a ticket/document that is being exchanged.
     * 
     * @return value
     */
    public Boolean getResponseTicketDocInfoExchTicketNbrInd() {
        return responseTicketDocInfoExchTicketNbrInd;
    }

    /** 
     * Set the 'ExchTicketNbrInd' attribute value. When true, this is the ticket/document number for a ticket/document that is being exchanged.
     * 
     * @param responseTicketDocInfoExchTicketNbrInd
     */
    public void setResponseTicketDocInfoExchTicketNbrInd(
            Boolean responseTicketDocInfoExchTicketNbrInd) {
        setChoiceSelect(SUCCESS_CHOICE);
        this.responseTicketDocInfoExchTicketNbrInd = responseTicketDocInfoExchTicketNbrInd;
    }

    /** 
     * Get the 'PrimaryDocInd' attribute value. When true, this is the primary ticket/document number. 
     * 
     * @return value
     */
    public Boolean getResponseTicketDocInfoPrimaryDocInd() {
        return responseTicketDocInfoPrimaryDocInd;
    }

    /** 
     * Set the 'PrimaryDocInd' attribute value. When true, this is the primary ticket/document number. 
     * 
     * @param responseTicketDocInfoPrimaryDocInd
     */
    public void setResponseTicketDocInfoPrimaryDocInd(
            Boolean responseTicketDocInfoPrimaryDocInd) {
        setChoiceSelect(SUCCESS_CHOICE);
        this.responseTicketDocInfoPrimaryDocInd = responseTicketDocInfoPrimaryDocInd;
    }

    /** 
     * Check if Errors is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifErrors() {
        return choiceSelect == ERRORS_CHOICE;
    }

    /** 
     * Get the 'Errors' element value.
     * 
     * @return value
     */
    public ErrorsType getErrors() {
        return errors;
    }

    /** 
     * Set the 'Errors' element value.
     * 
     * @param errors
     */
    public void setErrors(ErrorsType errors) {
        setChoiceSelect(ERRORS_CHOICE);
        this.errors = errors;
    }

    /** 
     * Get the 'IATA_PayloadStdAttributes' attributeGroup value.
     * 
     * @return value
     */
    public IATAPayloadStdAttributes getIATAPayloadStdAttributes() {
        return IATAPayloadStdAttributes;
    }

    /** 
     * Set the 'IATA_PayloadStdAttributes' attributeGroup value.
     * 
     * @param IATAPayloadStdAttributes
     */
    public void setIATAPayloadStdAttributes(
            IATAPayloadStdAttributes IATAPayloadStdAttributes) {
        this.IATAPayloadStdAttributes = IATAPayloadStdAttributes;
    }
}
