
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * The AirDocIssue transaction set requests an Airline to issue flight (ET) and/or ancillary (EMD) document(s).
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AirDocIssueRQ">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element ref="ns:PointOfSale" minOccurs="0"/>
 *       &lt;xs:element ref="ns:Document"/>
 *       &lt;xs:element ref="ns:Party"/>
 *       &lt;xs:element name="Query">
 *         &lt;xs:complexType>
 *           &lt;xs:sequence>
 *             &lt;xs:element ref="ns:TicketDocQuantity"/>
 *             &lt;xs:element name="TicketDocInfo" maxOccurs="unbounded">
 *               &lt;!-- Reference to inner class TicketDocInfo -->
 *             &lt;/xs:element>
 *             &lt;xs:element name="DataLists" minOccurs="0">
 *               &lt;!-- Reference to inner class DataLists -->
 *             &lt;/xs:element>
 *           &lt;/xs:sequence>
 *         &lt;/xs:complexType>
 *       &lt;/xs:element>
 *     &lt;/xs:sequence>
 *     &lt;xs:attributeGroup ref="ns:IATA_PayloadStdAttributes"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class AirDocIssueRQ implements Serializable
{
    private PointOfSaleType pointOfSale;
    private MsgDocumentType document;
    private MsgPartiesType party;
    private TicketDocQuantity queryTicketDocQuantity;
    private List<TicketDocInfo> ticketDocInfoList = new ArrayList<TicketDocInfo>();
    private DataLists dataLists;
    private IATAPayloadStdAttributes IATAPayloadStdAttributes;

    /** 
     * Get the 'PointOfSale' element value.
     * 
     * @return value
     */
    public PointOfSaleType getPointOfSale() {
        return pointOfSale;
    }

    /** 
     * Set the 'PointOfSale' element value.
     * 
     * @param pointOfSale
     */
    public void setPointOfSale(PointOfSaleType pointOfSale) {
        this.pointOfSale = pointOfSale;
    }

    /** 
     * Get the 'Document' element value.
     * 
     * @return value
     */
    public MsgDocumentType getDocument() {
        return document;
    }

    /** 
     * Set the 'Document' element value.
     * 
     * @param document
     */
    public void setDocument(MsgDocumentType document) {
        this.document = document;
    }

    /** 
     * Get the 'Party' element value.
     * 
     * @return value
     */
    public MsgPartiesType getParty() {
        return party;
    }

    /** 
     * Set the 'Party' element value.
     * 
     * @param party
     */
    public void setParty(MsgPartiesType party) {
        this.party = party;
    }

    /** 
     * Get the 'TicketDocQuantity' element value.
     * 
     * @return value
     */
    public TicketDocQuantity getQueryTicketDocQuantity() {
        return queryTicketDocQuantity;
    }

    /** 
     * Set the 'TicketDocQuantity' element value.
     * 
     * @param queryTicketDocQuantity
     */
    public void setQueryTicketDocQuantity(
            TicketDocQuantity queryTicketDocQuantity) {
        this.queryTicketDocQuantity = queryTicketDocQuantity;
    }

    /** 
     * Get the list of 'TicketDocInfo' element items. Air Document Issue Request Query.
     * 
     * @return list
     */
    public List<TicketDocInfo> getTicketDocInfoList() {
        return ticketDocInfoList;
    }

    /** 
     * Set the list of 'TicketDocInfo' element items. Air Document Issue Request Query.
     * 
     * @param list
     */
    public void setTicketDocInfoList(List<TicketDocInfo> list) {
        ticketDocInfoList = list;
    }

    /** 
     * Get the 'DataLists' element value. Air Document Issue Request Query.
     * 
     * @return value
     */
    public DataLists getDataLists() {
        return dataLists;
    }

    /** 
     * Set the 'DataLists' element value. Air Document Issue Request Query.
     * 
     * @param dataLists
     */
    public void setDataLists(DataLists dataLists) {
        this.dataLists = dataLists;
    }

    /** 
     * Get the 'IATA_PayloadStdAttributes' attributeGroup value.
     * 
     * @return value
     */
    public IATAPayloadStdAttributes getIATAPayloadStdAttributes() {
        return IATAPayloadStdAttributes;
    }

    /** 
     * Set the 'IATA_PayloadStdAttributes' attributeGroup value.
     * 
     * @param IATAPayloadStdAttributes
     */
    public void setIATAPayloadStdAttributes(
            IATAPayloadStdAttributes IATAPayloadStdAttributes) {
        this.IATAPayloadStdAttributes = IATAPayloadStdAttributes;
    }
    /** 
     * Coupon Creation Information, including Traveler; Order/ Booking Reference ID(s); Promotions and Commission.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TicketDocInfo" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="PassengerReference"/>
     *       &lt;xs:element ref="ns:BookingReference" minOccurs="0"/>
     *       &lt;xs:element type="ns:CouponOrderKeyType" name="OrderReference" minOccurs="0"/>
     *       &lt;xs:element name="Promotions" minOccurs="0">
     *         &lt;!-- Reference to inner class Promotions -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="Payments" minOccurs="0">
     *         &lt;!-- Reference to inner class Payments -->
     *       &lt;/xs:element>
     *       &lt;xs:element type="ns:CommissionType" name="Commission" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class TicketDocInfo implements Serializable
    {
        private String passengerReference;
        private BookingReferenceType bookingReference;
        private CouponOrderKeyType orderReference;
        private Promotions promotions;
        private Payments payments;
        private CommissionType commission;

        /** 
         * Get the 'PassengerReference' element value. Association to a passenger.
         * 
         * @return value
         */
        public String getPassengerReference() {
            return passengerReference;
        }

        /** 
         * Set the 'PassengerReference' element value. Association to a passenger.
         * 
         * @param passengerReference
         */
        public void setPassengerReference(String passengerReference) {
            this.passengerReference = passengerReference;
        }

        /** 
         * Get the 'BookingReference' element value. Booking Reference information.

         * 
         * @return value
         */
        public BookingReferenceType getBookingReference() {
            return bookingReference;
        }

        /** 
         * Set the 'BookingReference' element value. Booking Reference information.

         * 
         * @param bookingReference
         */
        public void setBookingReference(BookingReferenceType bookingReference) {
            this.bookingReference = bookingReference;
        }

        /** 
         * Get the 'OrderReference' element value. The order id for which a ticket/document should be issued.
         * 
         * @return value
         */
        public CouponOrderKeyType getOrderReference() {
            return orderReference;
        }

        /** 
         * Set the 'OrderReference' element value. The order id for which a ticket/document should be issued.
         * 
         * @param orderReference
         */
        public void setOrderReference(CouponOrderKeyType orderReference) {
            this.orderReference = orderReference;
        }

        /** 
         * Get the 'Promotions' element value.
         * 
         * @return value
         */
        public Promotions getPromotions() {
            return promotions;
        }

        /** 
         * Set the 'Promotions' element value.
         * 
         * @param promotions
         */
        public void setPromotions(Promotions promotions) {
            this.promotions = promotions;
        }

        /** 
         * Get the 'Payments' element value.
         * 
         * @return value
         */
        public Payments getPayments() {
            return payments;
        }

        /** 
         * Set the 'Payments' element value.
         * 
         * @param payments
         */
        public void setPayments(Payments payments) {
            this.payments = payments;
        }

        /** 
         * Get the 'Commission' element value. Commission information
         * 
         * @return value
         */
        public CommissionType getCommission() {
            return commission;
        }

        /** 
         * Set the 'Commission' element value. Commission information
         * 
         * @param commission
         */
        public void setCommission(CommissionType commission) {
            this.commission = commission;
        }
        /** 
         * Promotion information.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Promotions" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="ns:PromotionType" name="Promotion" maxOccurs="unbounded"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Promotions implements Serializable
        {
            private List<PromotionType> promotionList = new ArrayList<PromotionType>();

            /** 
             * Get the list of 'Promotion' element items. Promotion Code.
             * 
             * @return list
             */
            public List<PromotionType> getPromotionList() {
                return promotionList;
            }

            /** 
             * Set the list of 'Promotion' element items. Promotion Code.
             * 
             * @param list
             */
            public void setPromotionList(List<PromotionType> list) {
                promotionList = list;
            }
        }
        /** 
         * Payment information.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Payments" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="Payment" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class Payment -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Payments implements Serializable
        {
            private List<Payment> paymentList = new ArrayList<Payment>();

            /** 
             * Get the list of 'Payment' element items.
             * 
             * @return list
             */
            public List<Payment> getPaymentList() {
                return paymentList;
            }

            /** 
             * Set the list of 'Payment' element items.
             * 
             * @param list
             */
            public void setPaymentList(List<Payment> list) {
                paymentList = list;
            }
            /** 
             * Payment detail, including association(s).
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Payment" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:complexContent>
             *       &lt;xs:extension base="ns:OrderPaymentFormType">
             *         &lt;xs:sequence>
             *           &lt;xs:element name="Order" maxOccurs="unbounded">
             *             &lt;!-- Reference to inner class Order -->
             *           &lt;/xs:element>
             *         &lt;/xs:sequence>
             *       &lt;/xs:extension>
             *     &lt;/xs:complexContent>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Payment extends OrderPaymentFormType implements
                Serializable
            {
                private List<Order> orderList = new ArrayList<Order>();

                /** 
                 * Get the list of 'Order' element items.
                 * 
                 * @return list
                 */
                public List<Order> getOrderList() {
                    return orderList;
                }

                /** 
                 * Set the list of 'Order' element items.
                 * 
                 * @param list
                 */
                public void setOrderList(List<Order> list) {
                    orderList = list;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Order" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element type="xs:string" name="OrderItemID" minOccurs="0" maxOccurs="unbounded"/>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:string" use="required" name="OrderID"/>
                 *     &lt;xs:attribute type="xs:string" use="required" name="Owner"/>
                 *     &lt;xs:attribute name="OwnerType">
                 *       &lt;xs:simpleType>
                 *         &lt;!-- Reference to inner class OwnerType -->
                 *       &lt;/xs:simpleType>
                 *     &lt;/xs:attribute>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Order implements Serializable
                {
                    private List<String> orderItemIDList = new ArrayList<String>();
                    private String orderID;
                    private String owner;
                    private OwnerType ownerType;

                    /** 
                     * Get the list of 'OrderItemID' element items. 
                                      Association to one or multiple Order Items instance(s). Example:OI1 OI2
                                    
                     * 
                     * @return list
                     */
                    public List<String> getOrderItemIDList() {
                        return orderItemIDList;
                    }

                    /** 
                     * Set the list of 'OrderItemID' element items. 
                                      Association to one or multiple Order Items instance(s). Example:OI1 OI2
                                    
                     * 
                     * @param list
                     */
                    public void setOrderItemIDList(List<String> list) {
                        orderItemIDList = list;
                    }

                    /** 
                     * Get the 'OrderID' attribute value. The airline-assigned unique Order ID. Example: ORDER-c98c-4759-a20b
                     * 
                     * @return value
                     */
                    public String getOrderID() {
                        return orderID;
                    }

                    /** 
                     * Set the 'OrderID' attribute value. The airline-assigned unique Order ID. Example: ORDER-c98c-4759-a20b
                     * 
                     * @param orderID
                     */
                    public void setOrderID(String orderID) {
                        this.orderID = orderID;
                    }

                    /** 
                     * Get the 'Owner' attribute value. Airline Designator of airline that owns/ assigned this ID. Example: BA

                    Encoding Scheme: IATA/ A4A (two or three character) Airline Designator Codes
                     * 
                     * @return value
                     */
                    public String getOwner() {
                        return owner;
                    }

                    /** 
                     * Set the 'Owner' attribute value. Airline Designator of airline that owns/ assigned this ID. Example: BA

                    Encoding Scheme: IATA/ A4A (two or three character) Airline Designator Codes
                     * 
                     * @param owner
                     */
                    public void setOwner(String owner) {
                        this.owner = owner;
                    }

                    /** 
                     * Get the 'OwnerType' attribute value. The POA OrderID should only go to the ORA, not back to the seller.
                    1. ORA
                    2. POA
                     * 
                     * @return value
                     */
                    public OwnerType getOwnerType() {
                        return ownerType;
                    }

                    /** 
                     * Set the 'OwnerType' attribute value. The POA OrderID should only go to the ORA, not back to the seller.
                    1. ORA
                    2. POA
                     * 
                     * @param ownerType
                     */
                    public void setOwnerType(OwnerType ownerType) {
                        this.ownerType = ownerType;
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
                     *   &lt;xs:restriction base="xs:string">
                     *     &lt;xs:enumeration value="ORA"/>
                     *     &lt;xs:enumeration value="POA"/>
                     *   &lt;/xs:restriction>
                     * &lt;/xs:simpleType>
                     * </pre>
                     */
                    public static enum OwnerType implements Serializable {
                        ORA, POA
                    }
                }
            }
        }
    }
    /** 
     * Data Lists(s).
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DataLists" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="PassengerList" minOccurs="0">
     *         &lt;!-- Reference to inner class PassengerList -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="ContactList" minOccurs="0">
     *         &lt;!-- Reference to inner class ContactList -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class DataLists implements Serializable
    {
        private PassengerList passengerList;
        private ContactList contactList;

        /** 
         * Get the 'PassengerList' element value.
         * 
         * @return value
         */
        public PassengerList getPassengerList() {
            return passengerList;
        }

        /** 
         * Set the 'PassengerList' element value.
         * 
         * @param passengerList
         */
        public void setPassengerList(PassengerList passengerList) {
            this.passengerList = passengerList;
        }

        /** 
         * Get the 'ContactList' element value.
         * 
         * @return value
         */
        public ContactList getContactList() {
            return contactList;
        }

        /** 
         * Set the 'ContactList' element value.
         * 
         * @param contactList
         */
        public void setContactList(ContactList contactList) {
            this.contactList = contactList;
        }
        /** 
         * Passenger data list definition.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PassengerList" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="ns:PassengerType" name="Passenger" maxOccurs="unbounded"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class PassengerList implements Serializable
        {
            private List<PassengerType> passengerList = new ArrayList<PassengerType>();

            /** 
             * Get the list of 'Passenger' element items. Any person except members of the crew carried or to be carried with the consent of the carrier, on board of any transport vehicle such as aircraft, train, bus, ship.
             * 
             * @return list
             */
            public List<PassengerType> getPassengerList() {
                return passengerList;
            }

            /** 
             * Set the list of 'Passenger' element items. Any person except members of the crew carried or to be carried with the consent of the carrier, on board of any transport vehicle such as aircraft, train, bus, ship.
             * 
             * @param list
             */
            public void setPassengerList(List<PassengerType> list) {
                passengerList = list;
            }
        }
        /** 
         * Contact data list definition.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ContactList" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="ns:ContactInformationType" name="ContactInformation" maxOccurs="unbounded"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class ContactList implements Serializable
        {
            private List<ContactInformationType> contactInformationList = new ArrayList<ContactInformationType>();

            /** 
             * Get the list of 'ContactInformation' element items. The electronic or geographic address which a party has provided as the contact channel. For example, contact email, contact postal address, contact phone number.
             * 
             * @return list
             */
            public List<ContactInformationType> getContactInformationList() {
                return contactInformationList;
            }

            /** 
             * Set the list of 'ContactInformation' element items. The electronic or geographic address which a party has provided as the contact channel. For example, contact email, contact postal address, contact phone number.
             * 
             * @param list
             */
            public void setContactInformationList(
                    List<ContactInformationType> list) {
                contactInformationList = list;
            }
        }
    }
}
