
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;
import java.math.BigInteger;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

/** 
 * The AirDocNotifRQ transaction sends an unsolicited document change notification message. The Acknowledgement message may be returned to acknowledge receipt of the notification request.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AirDocNotifRQ">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element ref="ns:Document"/>
 *       &lt;xs:element ref="ns:Party"/>
 *       &lt;xs:element name="Query">
 *         &lt;xs:complexType>
 *           &lt;xs:sequence>
 *             &lt;xs:element name="DocumentNotif" maxOccurs="unbounded">
 *               &lt;!-- Reference to inner class DocumentNotif -->
 *             &lt;/xs:element>
 *             &lt;xs:element name="DataLists" minOccurs="0">
 *               &lt;!-- Reference to inner class DataLists -->
 *             &lt;/xs:element>
 *           &lt;/xs:sequence>
 *         &lt;/xs:complexType>
 *       &lt;/xs:element>
 *     &lt;/xs:sequence>
 *     &lt;xs:attributeGroup ref="ns:IATA_PayloadStdAttributes"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class AirDocNotifRQ implements Serializable
{
    private MsgDocumentType document;
    private MsgPartiesType party;
    private List<DocumentNotif> documentNotifList = new ArrayList<DocumentNotif>();
    private DataLists dataLists;
    private IATAPayloadStdAttributes IATAPayloadStdAttributes;

    /** 
     * Get the 'Document' element value.
     * 
     * @return value
     */
    public MsgDocumentType getDocument() {
        return document;
    }

    /** 
     * Set the 'Document' element value.
     * 
     * @param document
     */
    public void setDocument(MsgDocumentType document) {
        this.document = document;
    }

    /** 
     * Get the 'Party' element value.
     * 
     * @return value
     */
    public MsgPartiesType getParty() {
        return party;
    }

    /** 
     * Set the 'Party' element value.
     * 
     * @param party
     */
    public void setParty(MsgPartiesType party) {
        this.party = party;
    }

    /** 
     * Get the list of 'DocumentNotif' element items.
     * 
     * @return list
     */
    public List<DocumentNotif> getDocumentNotifList() {
        return documentNotifList;
    }

    /** 
     * Set the list of 'DocumentNotif' element items.
     * 
     * @param list
     */
    public void setDocumentNotifList(List<DocumentNotif> list) {
        documentNotifList = list;
    }

    /** 
     * Get the 'DataLists' element value.
     * 
     * @return value
     */
    public DataLists getDataLists() {
        return dataLists;
    }

    /** 
     * Set the 'DataLists' element value.
     * 
     * @param dataLists
     */
    public void setDataLists(DataLists dataLists) {
        this.dataLists = dataLists;
    }

    /** 
     * Get the 'IATA_PayloadStdAttributes' attributeGroup value.
     * 
     * @return value
     */
    public IATAPayloadStdAttributes getIATAPayloadStdAttributes() {
        return IATAPayloadStdAttributes;
    }

    /** 
     * Set the 'IATA_PayloadStdAttributes' attributeGroup value.
     * 
     * @param IATAPayloadStdAttributes
     */
    public void setIATAPayloadStdAttributes(
            IATAPayloadStdAttributes IATAPayloadStdAttributes) {
        this.IATAPayloadStdAttributes = IATAPayloadStdAttributes;
    }
    /** 
     * Ticket document Notification details.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DocumentNotif" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="PassengerReference"/>
     *       &lt;xs:element type="xs:string" name="Type"/>
     *       &lt;xs:element ref="ns:OrderID"/>
     *       &lt;xs:element type="xs:string" name="TicketDocNbr"/>
     *       &lt;xs:element type="xs:date" name="DateOfIssue"/>
     *       &lt;xs:element name="CouponNotif" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class CouponNotif -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class DocumentNotif implements Serializable
    {
        private String passengerReference;
        private String type;
        private OrderIDType orderID;
        private String ticketDocNbr;
        private Date dateOfIssue;
        private List<CouponNotif> couponNotifList = new ArrayList<CouponNotif>();

        /** 
         * Get the 'PassengerReference' element value. Association to a passenger.
         * 
         * @return value
         */
        public String getPassengerReference() {
            return passengerReference;
        }

        /** 
         * Set the 'PassengerReference' element value. Association to a passenger.
         * 
         * @param passengerReference
         */
        public void setPassengerReference(String passengerReference) {
            this.passengerReference = passengerReference;
        }

        /** 
         * Get the 'Type' element value. Coupon Type. Example: Y (EMD-S Standalone)

        Encoding Scheme: IATA Padis Codeset - List for data element 1001 (Document/ Message Name, coded)
         * 
         * @return value
         */
        public String getType() {
            return type;
        }

        /** 
         * Set the 'Type' element value. Coupon Type. Example: Y (EMD-S Standalone)

        Encoding Scheme: IATA Padis Codeset - List for data element 1001 (Document/ Message Name, coded)
         * 
         * @param type
         */
        public void setType(String type) {
            this.type = type;
        }

        /** 
         * Get the 'OrderID' element value.
         * 
         * @return value
         */
        public OrderIDType getOrderID() {
            return orderID;
        }

        /** 
         * Set the 'OrderID' element value.
         * 
         * @param orderID
         */
        public void setOrderID(OrderIDType orderID) {
            this.orderID = orderID;
        }

        /** 
         * Get the 'TicketDocNbr' element value. Coupon Document Number.

        Note: This is the document number comprised of the airline code, form code, and serial number.
         * 
         * @return value
         */
        public String getTicketDocNbr() {
            return ticketDocNbr;
        }

        /** 
         * Set the 'TicketDocNbr' element value. Coupon Document Number.

        Note: This is the document number comprised of the airline code, form code, and serial number.
         * 
         * @param ticketDocNbr
         */
        public void setTicketDocNbr(String ticketDocNbr) {
            this.ticketDocNbr = ticketDocNbr;
        }

        /** 
         * Get the 'DateOfIssue' element value. Date of Issue. Example: 2017-01-13
         * 
         * @return value
         */
        public Date getDateOfIssue() {
            return dateOfIssue;
        }

        /** 
         * Set the 'DateOfIssue' element value. Date of Issue. Example: 2017-01-13
         * 
         * @param dateOfIssue
         */
        public void setDateOfIssue(Date dateOfIssue) {
            this.dateOfIssue = dateOfIssue;
        }

        /** 
         * Get the list of 'CouponNotif' element items.
         * 
         * @return list
         */
        public List<CouponNotif> getCouponNotifList() {
            return couponNotifList;
        }

        /** 
         * Set the list of 'CouponNotif' element items.
         * 
         * @param list
         */
        public void setCouponNotifList(List<CouponNotif> list) {
            couponNotifList = list;
        }
        /** 
         * Coupon Notification details.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CouponNotif" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="xs:integer" name="CouponNumber" minOccurs="0"/>
         *       &lt;xs:element ref="ns:OrderItemID" minOccurs="0"/>
         *       &lt;xs:element ref="ns:ServiceID" minOccurs="0"/>
         *       &lt;xs:element ref="ns:AirlineID"/>
         *       &lt;xs:element type="xs:string" name="ServiceType" minOccurs="0"/>
         *       &lt;xs:element type="xs:date" name="ServiceDate" minOccurs="0"/>
         *       &lt;xs:element name="ServiceDetails" minOccurs="0">
         *         &lt;!-- Reference to inner class ServiceDetails -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="FlightDetails" minOccurs="0">
         *         &lt;!-- Reference to inner class FlightDetails -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class CouponNotif implements Serializable
        {
            private BigInteger couponNumber;
            private OrderItemID orderItemID;
            private ServiceIDType serviceID;
            private AirlineIDType airlineID;
            private String serviceType;
            private Date serviceDate;
            private ServiceDetails serviceDetails;
            private FlightDetails flightDetails;

            /** 
             * Get the 'CouponNumber' element value. Applicable coupon number. Example: 1234
             * 
             * @return value
             */
            public BigInteger getCouponNumber() {
                return couponNumber;
            }

            /** 
             * Set the 'CouponNumber' element value. Applicable coupon number. Example: 1234
             * 
             * @param couponNumber
             */
            public void setCouponNumber(BigInteger couponNumber) {
                this.couponNumber = couponNumber;
            }

            /** 
             * Get the 'OrderItemID' element value.
             * 
             * @return value
             */
            public OrderItemID getOrderItemID() {
                return orderItemID;
            }

            /** 
             * Set the 'OrderItemID' element value.
             * 
             * @param orderItemID
             */
            public void setOrderItemID(OrderItemID orderItemID) {
                this.orderItemID = orderItemID;
            }

            /** 
             * Get the 'ServiceID' element value.
             * 
             * @return value
             */
            public ServiceIDType getServiceID() {
                return serviceID;
            }

            /** 
             * Set the 'ServiceID' element value.
             * 
             * @param serviceID
             */
            public void setServiceID(ServiceIDType serviceID) {
                this.serviceID = serviceID;
            }

            /** 
             * Get the 'AirlineID' element value.
             * 
             * @return value
             */
            public AirlineIDType getAirlineID() {
                return airlineID;
            }

            /** 
             * Set the 'AirlineID' element value.
             * 
             * @param airlineID
             */
            public void setAirlineID(AirlineIDType airlineID) {
                this.airlineID = airlineID;
            }

            /** 
             * Get the 'ServiceType' element value. Type of Service.
             * 
             * @return value
             */
            public String getServiceType() {
                return serviceType;
            }

            /** 
             * Set the 'ServiceType' element value. Type of Service.
             * 
             * @param serviceType
             */
            public void setServiceType(String serviceType) {
                this.serviceType = serviceType;
            }

            /** 
             * Get the 'ServiceDate' element value. Service date. Example : 15-08-2015
             * 
             * @return value
             */
            public Date getServiceDate() {
                return serviceDate;
            }

            /** 
             * Set the 'ServiceDate' element value. Service date. Example : 15-08-2015
             * 
             * @param serviceDate
             */
            public void setServiceDate(Date serviceDate) {
                this.serviceDate = serviceDate;
            }

            /** 
             * Get the 'ServiceDetails' element value.
             * 
             * @return value
             */
            public ServiceDetails getServiceDetails() {
                return serviceDetails;
            }

            /** 
             * Set the 'ServiceDetails' element value.
             * 
             * @param serviceDetails
             */
            public void setServiceDetails(ServiceDetails serviceDetails) {
                this.serviceDetails = serviceDetails;
            }

            /** 
             * Get the 'FlightDetails' element value.
             * 
             * @return value
             */
            public FlightDetails getFlightDetails() {
                return flightDetails;
            }

            /** 
             * Set the 'FlightDetails' element value.
             * 
             * @param flightDetails
             */
            public void setFlightDetails(FlightDetails flightDetails) {
                this.flightDetails = flightDetails;
            }
            /** 
             * Service Details.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ServiceDetails" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="xs:string" name="ServiceActionCode"/>
             *       &lt;xs:element type="xs:int" name="ServiceQuantity"/>
             *       &lt;xs:element name="LocationCode" minOccurs="0">
             *         &lt;!-- Reference to inner class LocationCode -->
             *       &lt;/xs:element>
             *       &lt;xs:element type="xs:string" name="Name"/>
             *       &lt;xs:element ref="ns:RFIC" minOccurs="0"/>
             *       &lt;xs:element type="xs:string" name="RFISC" minOccurs="0"/>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class ServiceDetails implements Serializable
            {
                private String serviceActionCode;
                private int serviceQuantity;
                private LocationCode locationCode;
                private String name;
                private RFIC RFIC;
                private String RFISC;

                /** 
                 * Get the 'ServiceActionCode' element value. Service Action Code       E.g. HK, HL (use PADIS Codeset)
                 * 
                 * @return value
                 */
                public String getServiceActionCode() {
                    return serviceActionCode;
                }

                /** 
                 * Set the 'ServiceActionCode' element value. Service Action Code       E.g. HK, HL (use PADIS Codeset)
                 * 
                 * @param serviceActionCode
                 */
                public void setServiceActionCode(String serviceActionCode) {
                    this.serviceActionCode = serviceActionCode;
                }

                /** 
                 * Get the 'ServiceQuantity' element value. Quantity of Services. Example : 3
                 * 
                 * @return value
                 */
                public int getServiceQuantity() {
                    return serviceQuantity;
                }

                /** 
                 * Set the 'ServiceQuantity' element value. Quantity of Services. Example : 3
                 * 
                 * @param serviceQuantity
                 */
                public void setServiceQuantity(int serviceQuantity) {
                    this.serviceQuantity = serviceQuantity;
                }

                /** 
                 * Get the 'LocationCode' element value.
                 * 
                 * @return value
                 */
                public LocationCode getLocationCode() {
                    return locationCode;
                }

                /** 
                 * Set the 'LocationCode' element value.
                 * 
                 * @param locationCode
                 */
                public void setLocationCode(LocationCode locationCode) {
                    this.locationCode = locationCode;
                }

                /** 
                 * Get the 'Name' element value. Service name. Example: Lounge Pass
                 * 
                 * @return value
                 */
                public String getName() {
                    return name;
                }

                /** 
                 * Set the 'Name' element value. Service name. Example: Lounge Pass
                 * 
                 * @param name
                 */
                public void setName(String name) {
                    this.name = name;
                }

                /** 
                 * Get the 'RFIC' element value.
                 * 
                 * @return value
                 */
                public RFIC getRFIC() {
                    return RFIC;
                }

                /** 
                 * Set the 'RFIC' element value.
                 * 
                 * @param RFIC
                 */
                public void setRFIC(RFIC RFIC) {
                    this.RFIC = RFIC;
                }

                /** 
                 * Get the 'RFISC' element value. Reason For Issuance Sub Codes
                 * 
                 * @return value
                 */
                public String getRFISC() {
                    return RFISC;
                }

                /** 
                 * Set the 'RFISC' element value. Reason For Issuance Sub Codes
                 * 
                 * @param RFISC
                 */
                public void setRFISC(String RFISC) {
                    this.RFISC = RFISC;
                }
                /** 
                 * Location Code.          Example : LON 
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="LocationCode" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:simpleContent>
                 *       &lt;xs:extension base="xs:string">
                 *         &lt;xs:attribute type="xs:string" name="LocationType"/>
                 *       &lt;/xs:extension>
                 *     &lt;/xs:simpleContent>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class LocationCode implements Serializable
                {
                    private String string;
                    private String locationType;

                    /** 
                     * Get the extension value.
                     * 
                     * @return value
                     */
                    public String getString() {
                        return string;
                    }

                    /** 
                     * Set the extension value.
                     * 
                     * @param string
                     */
                    public void setString(String string) {
                        this.string = string;
                    }

                    /** 
                     * Get the 'LocationType' attribute value. Location Indicator Type. Example :  Primary or Secondary
                     * 
                     * @return value
                     */
                    public String getLocationType() {
                        return locationType;
                    }

                    /** 
                     * Set the 'LocationType' attribute value. Location Indicator Type. Example :  Primary or Secondary
                     * 
                     * @param locationType
                     */
                    public void setLocationType(String locationType) {
                        this.locationType = locationType;
                    }
                }
            }
            /** 
             * Flight Details.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FlightDetails" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element ref="ns:FlightNumber"/>
             *       &lt;xs:element ref="ns:Departure"/>
             *       &lt;xs:element ref="ns:Arrival" minOccurs="0"/>
             *       &lt;xs:element type="xs:string" name="ServiceActionCode" minOccurs="0"/>
             *       &lt;xs:element ref="ns:CabinType" minOccurs="0"/>
             *       &lt;xs:element ref="ns:ClassOfService" minOccurs="0"/>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class FlightDetails implements Serializable
            {
                private FlightNumber flightNumber;
                private FlightDepartureType departure;
                private FlightArrivalType arrival;
                private String serviceActionCode;
                private CabinType cabinType;
                private FlightCOSCoreType classOfService;

                /** 
                 * Get the 'FlightNumber' element value.
                 * 
                 * @return value
                 */
                public FlightNumber getFlightNumber() {
                    return flightNumber;
                }

                /** 
                 * Set the 'FlightNumber' element value.
                 * 
                 * @param flightNumber
                 */
                public void setFlightNumber(FlightNumber flightNumber) {
                    this.flightNumber = flightNumber;
                }

                /** 
                 * Get the 'Departure' element value.
                 * 
                 * @return value
                 */
                public FlightDepartureType getDeparture() {
                    return departure;
                }

                /** 
                 * Set the 'Departure' element value.
                 * 
                 * @param departure
                 */
                public void setDeparture(FlightDepartureType departure) {
                    this.departure = departure;
                }

                /** 
                 * Get the 'Arrival' element value.
                 * 
                 * @return value
                 */
                public FlightArrivalType getArrival() {
                    return arrival;
                }

                /** 
                 * Set the 'Arrival' element value.
                 * 
                 * @param arrival
                 */
                public void setArrival(FlightArrivalType arrival) {
                    this.arrival = arrival;
                }

                /** 
                 * Get the 'ServiceActionCode' element value. Service Action Code       E.g. HK, HL (use PADIS Codeset)
                 * 
                 * @return value
                 */
                public String getServiceActionCode() {
                    return serviceActionCode;
                }

                /** 
                 * Set the 'ServiceActionCode' element value. Service Action Code       E.g. HK, HL (use PADIS Codeset)
                 * 
                 * @param serviceActionCode
                 */
                public void setServiceActionCode(String serviceActionCode) {
                    this.serviceActionCode = serviceActionCode;
                }

                /** 
                 * Get the 'CabinType' element value.
                 * 
                 * @return value
                 */
                public CabinType getCabinType() {
                    return cabinType;
                }

                /** 
                 * Set the 'CabinType' element value.
                 * 
                 * @param cabinType
                 */
                public void setCabinType(CabinType cabinType) {
                    this.cabinType = cabinType;
                }

                /** 
                 * Get the 'ClassOfService' element value.
                 * 
                 * @return value
                 */
                public FlightCOSCoreType getClassOfService() {
                    return classOfService;
                }

                /** 
                 * Set the 'ClassOfService' element value.
                 * 
                 * @param classOfService
                 */
                public void setClassOfService(FlightCOSCoreType classOfService) {
                    this.classOfService = classOfService;
                }
            }
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DataLists" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="PassengerList" minOccurs="0">
     *         &lt;!-- Reference to inner class PassengerList -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="ContactList" minOccurs="0">
     *         &lt;!-- Reference to inner class ContactList -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class DataLists implements Serializable
    {
        private PassengerList passengerList;
        private ContactList contactList;

        /** 
         * Get the 'PassengerList' element value.
         * 
         * @return value
         */
        public PassengerList getPassengerList() {
            return passengerList;
        }

        /** 
         * Set the 'PassengerList' element value.
         * 
         * @param passengerList
         */
        public void setPassengerList(PassengerList passengerList) {
            this.passengerList = passengerList;
        }

        /** 
         * Get the 'ContactList' element value.
         * 
         * @return value
         */
        public ContactList getContactList() {
            return contactList;
        }

        /** 
         * Set the 'ContactList' element value.
         * 
         * @param contactList
         */
        public void setContactList(ContactList contactList) {
            this.contactList = contactList;
        }
        /** 
         * Passenger data list definition.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PassengerList" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="ns:PassengerType" name="Passenger" maxOccurs="unbounded"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class PassengerList implements Serializable
        {
            private List<PassengerType> passengerList = new ArrayList<PassengerType>();

            /** 
             * Get the list of 'Passenger' element items. Any person except members of the crew carried or to be carried with the consent of the carrier, on board of any transport vehicle such as aircraft, train, bus, ship.
             * 
             * @return list
             */
            public List<PassengerType> getPassengerList() {
                return passengerList;
            }

            /** 
             * Set the list of 'Passenger' element items. Any person except members of the crew carried or to be carried with the consent of the carrier, on board of any transport vehicle such as aircraft, train, bus, ship.
             * 
             * @param list
             */
            public void setPassengerList(List<PassengerType> list) {
                passengerList = list;
            }
        }
        /** 
         * Contact data list definition.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ContactList" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="ns:ContactInformationType" name="ContactInformation" maxOccurs="unbounded"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class ContactList implements Serializable
        {
            private List<ContactInformationType> contactInformationList = new ArrayList<ContactInformationType>();

            /** 
             * Get the list of 'ContactInformation' element items. The electronic or geographic address which a party has provided as the contact channel. For example, contact email, contact postal address, contact phone number.
             * 
             * @return list
             */
            public List<ContactInformationType> getContactInformationList() {
                return contactInformationList;
            }

            /** 
             * Set the list of 'ContactInformation' element items. The electronic or geographic address which a party has provided as the contact channel. For example, contact email, contact postal address, contact phone number.
             * 
             * @param list
             */
            public void setContactInformationList(
                    List<ContactInformationType> list) {
                contactInformationList = list;
            }
        }
    }
}
