
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * The AirShopping transaction set supports both demanding and flexible shopping experiences for anonymous or personalized shopping.

 The combination of functionally-rich attribute and affinity shopping support date range or specific month (calendar) shopping as an example.

 The response returns offers which may include branded offers or itinerary-priced offers with or without ancillary services. It also returns applicable rules for the integrated fares as well as for each service.

 The message also returns multi-media content at message level as well as media references at the individual offer level.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AirShoppingRQ">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element ref="ns:PointOfSale" minOccurs="0"/>
 *       &lt;xs:element ref="ns:Document"/>
 *       &lt;xs:element ref="ns:Party"/>
 *       &lt;xs:element type="ns:AirShopReqParamsType" name="Parameters" minOccurs="0"/>
 *       &lt;xs:element name="CoreQuery">
 *         &lt;xs:complexType>
 *           &lt;xs:choice>
 *             &lt;xs:element ref="ns:Affinity"/>
 *             &lt;xs:element type="ns:AirShopReqAttributeQueryType" name="OriginDestinations"/>
 *             &lt;xs:element ref="ns:FlightSpecific"/>
 *             &lt;xs:element ref="ns:ShoppingResponseID"/>
 *           &lt;/xs:choice>
 *         &lt;/xs:complexType>
 *       &lt;/xs:element>
 *       &lt;xs:element name="Qualifier" minOccurs="0">
 *         &lt;!-- Reference to inner class Qualifier -->
 *       &lt;/xs:element>
 *       &lt;xs:element name="Preference" minOccurs="0">
 *         &lt;!-- Reference to inner class Preference -->
 *       &lt;/xs:element>
 *       &lt;xs:element name="DataLists" minOccurs="0">
 *         &lt;!-- Reference to inner class DataLists -->
 *       &lt;/xs:element>
 *       &lt;xs:element type="ns:AirShopReqMetadataType" name="Metadata" minOccurs="0"/>
 *       &lt;xs:element ref="ns:Policies" minOccurs="0"/>
 *     &lt;/xs:sequence>
 *     &lt;xs:attributeGroup ref="ns:IATA_PayloadStdAttributes"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class AirShoppingRQ implements Serializable
{
    private PointOfSaleType pointOfSale;
    private MsgDocumentType document;
    private MsgPartiesType party;
    private AirShopReqParamsType parameters;
    private int coreQuerySelect = -1;
    private static final int CORE_QUERY_AFFINITY_CHOICE = 0;
    private static final int CORE_QUERY_ORIGIN_DESTINATIONS_CHOICE = 1;
    private static final int CORE_QUERY_FLIGHT_SPECIFIC_CHOICE = 2;
    private static final int CORE_QUERY_SHOPPING_RESPONSE_ID_CHOICE = 3;
    private AirShopReqAffinityQueryType coreQueryAffinity;
    private AirShopReqAttributeQueryType coreQueryOriginDestinations;
    private AirShopFlightSpecificType coreQueryFlightSpecific;
    private ShoppingResponseIDType coreQueryShoppingResponseID;
    private Qualifier qualifier;
    private Preference preference;
    private DataLists dataLists;
    private AirShopReqMetadataType metadata;
    private Policies policies;
    private IATAPayloadStdAttributes IATAPayloadStdAttributes;

    /** 
     * Get the 'PointOfSale' element value.
     * 
     * @return value
     */
    public PointOfSaleType getPointOfSale() {
        return pointOfSale;
    }

    /** 
     * Set the 'PointOfSale' element value.
     * 
     * @param pointOfSale
     */
    public void setPointOfSale(PointOfSaleType pointOfSale) {
        this.pointOfSale = pointOfSale;
    }

    /** 
     * Get the 'Document' element value.
     * 
     * @return value
     */
    public MsgDocumentType getDocument() {
        return document;
    }

    /** 
     * Set the 'Document' element value.
     * 
     * @param document
     */
    public void setDocument(MsgDocumentType document) {
        this.document = document;
    }

    /** 
     * Get the 'Party' element value.
     * 
     * @return value
     */
    public MsgPartiesType getParty() {
        return party;
    }

    /** 
     * Set the 'Party' element value.
     * 
     * @param party
     */
    public void setParty(MsgPartiesType party) {
        this.party = party;
    }

    /** 
     * Get the 'Parameters' element value. Parameters that influence overall message results.

    Supported Parameter Groups: Inventory Guarantee (offer-associated); Service Filter (offer-associated); Pricing.

    Note: These capabilities may not be supported by all NDC-enabled systems or may be supported by bilateral agreement only. The technical implementation of this capability is not dictated by this specification. 
     * 
     * @return value
     */
    public AirShopReqParamsType getParameters() {
        return parameters;
    }

    /** 
     * Set the 'Parameters' element value. Parameters that influence overall message results.

    Supported Parameter Groups: Inventory Guarantee (offer-associated); Service Filter (offer-associated); Pricing.

    Note: These capabilities may not be supported by all NDC-enabled systems or may be supported by bilateral agreement only. The technical implementation of this capability is not dictated by this specification. 
     * 
     * @param parameters
     */
    public void setParameters(AirShopReqParamsType parameters) {
        this.parameters = parameters;
    }

    private void setCoreQuerySelect(int choice) {
        if (coreQuerySelect == -1) {
            coreQuerySelect = choice;
        } else if (coreQuerySelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearCoreQuerySelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearCoreQuerySelect() {
        coreQuerySelect = -1;
    }

    /** 
     * Check if CoreQueryAffinity is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifCoreQueryAffinity() {
        return coreQuerySelect == CORE_QUERY_AFFINITY_CHOICE;
    }

    /** 
     * Get the 'Affinity' element value.
     * 
     * @return value
     */
    public AirShopReqAffinityQueryType getCoreQueryAffinity() {
        return coreQueryAffinity;
    }

    /** 
     * Set the 'Affinity' element value.
     * 
     * @param coreQueryAffinity
     */
    public void setCoreQueryAffinity(
            AirShopReqAffinityQueryType coreQueryAffinity) {
        setCoreQuerySelect(CORE_QUERY_AFFINITY_CHOICE);
        this.coreQueryAffinity = coreQueryAffinity;
    }

    /** 
     * Check if CoreQueryOriginDestinations is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifCoreQueryOriginDestinations() {
        return coreQuerySelect == CORE_QUERY_ORIGIN_DESTINATIONS_CHOICE;
    }

    /** 
     * Get the 'OriginDestinations' element value. ATTRIBUTE Query ORIGIN/ DESTINATION qualifiers and preferences.

    Note:
    1. An Attribute Query is a search specifying one or more attributes to get more focused results   Note that this node only contains Origin/ Destination Airport/ City code information which are mandatory.

    2. Other Attribute Query parameters that may be specified (in other document nodes) include Aircraft Equipment preferences, Seat types and characteristics, Meal preferences and Special Need qualifiers.
     * 
     * @return value
     */
    public AirShopReqAttributeQueryType getCoreQueryOriginDestinations() {
        return coreQueryOriginDestinations;
    }

    /** 
     * Set the 'OriginDestinations' element value. ATTRIBUTE Query ORIGIN/ DESTINATION qualifiers and preferences.

    Note:
    1. An Attribute Query is a search specifying one or more attributes to get more focused results   Note that this node only contains Origin/ Destination Airport/ City code information which are mandatory.

    2. Other Attribute Query parameters that may be specified (in other document nodes) include Aircraft Equipment preferences, Seat types and characteristics, Meal preferences and Special Need qualifiers.
     * 
     * @param coreQueryOriginDestinations
     */
    public void setCoreQueryOriginDestinations(
            AirShopReqAttributeQueryType coreQueryOriginDestinations) {
        setCoreQuerySelect(CORE_QUERY_ORIGIN_DESTINATIONS_CHOICE);
        this.coreQueryOriginDestinations = coreQueryOriginDestinations;
    }

    /** 
     * Check if CoreQueryFlightSpecific is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifCoreQueryFlightSpecific() {
        return coreQuerySelect == CORE_QUERY_FLIGHT_SPECIFIC_CHOICE;
    }

    /** 
     * Get the 'FlightSpecific' element value.
     * 
     * @return value
     */
    public AirShopFlightSpecificType getCoreQueryFlightSpecific() {
        return coreQueryFlightSpecific;
    }

    /** 
     * Set the 'FlightSpecific' element value.
     * 
     * @param coreQueryFlightSpecific
     */
    public void setCoreQueryFlightSpecific(
            AirShopFlightSpecificType coreQueryFlightSpecific) {
        setCoreQuerySelect(CORE_QUERY_FLIGHT_SPECIFIC_CHOICE);
        this.coreQueryFlightSpecific = coreQueryFlightSpecific;
    }

    /** 
     * Check if CoreQueryShoppingResponseID is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifCoreQueryShoppingResponseID() {
        return coreQuerySelect == CORE_QUERY_SHOPPING_RESPONSE_ID_CHOICE;
    }

    /** 
     * Get the 'ShoppingResponseID' element value.
     * 
     * @return value
     */
    public ShoppingResponseIDType getCoreQueryShoppingResponseID() {
        return coreQueryShoppingResponseID;
    }

    /** 
     * Set the 'ShoppingResponseID' element value.
     * 
     * @param coreQueryShoppingResponseID
     */
    public void setCoreQueryShoppingResponseID(
            ShoppingResponseIDType coreQueryShoppingResponseID) {
        setCoreQuerySelect(CORE_QUERY_SHOPPING_RESPONSE_ID_CHOICE);
        this.coreQueryShoppingResponseID = coreQueryShoppingResponseID;
    }

    /** 
     * Get the 'Qualifier' element value.
     * 
     * @return value
     */
    public Qualifier getQualifier() {
        return qualifier;
    }

    /** 
     * Set the 'Qualifier' element value.
     * 
     * @param qualifier
     */
    public void setQualifier(Qualifier qualifier) {
        this.qualifier = qualifier;
    }

    /** 
     * Get the 'Preference' element value.
     * 
     * @return value
     */
    public Preference getPreference() {
        return preference;
    }

    /** 
     * Set the 'Preference' element value.
     * 
     * @param preference
     */
    public void setPreference(Preference preference) {
        this.preference = preference;
    }

    /** 
     * Get the 'DataLists' element value.
     * 
     * @return value
     */
    public DataLists getDataLists() {
        return dataLists;
    }

    /** 
     * Set the 'DataLists' element value.
     * 
     * @param dataLists
     */
    public void setDataLists(DataLists dataLists) {
        this.dataLists = dataLists;
    }

    /** 
     * Get the 'Metadata' element value. Metadata List(s).
     * 
     * @return value
     */
    public AirShopReqMetadataType getMetadata() {
        return metadata;
    }

    /** 
     * Set the 'Metadata' element value. Metadata List(s).
     * 
     * @param metadata
     */
    public void setMetadata(AirShopReqMetadataType metadata) {
        this.metadata = metadata;
    }

    /** 
     * Get the 'Policies' element value. Message Policy information.
     * 
     * @return value
     */
    public Policies getPolicies() {
        return policies;
    }

    /** 
     * Set the 'Policies' element value. Message Policy information.
     * 
     * @param policies
     */
    public void setPolicies(Policies policies) {
        this.policies = policies;
    }

    /** 
     * Get the 'IATA_PayloadStdAttributes' attributeGroup value.
     * 
     * @return value
     */
    public IATAPayloadStdAttributes getIATAPayloadStdAttributes() {
        return IATAPayloadStdAttributes;
    }

    /** 
     * Set the 'IATA_PayloadStdAttributes' attributeGroup value.
     * 
     * @param IATAPayloadStdAttributes
     */
    public void setIATAPayloadStdAttributes(
            IATAPayloadStdAttributes IATAPayloadStdAttributes) {
        this.IATAPayloadStdAttributes = IATAPayloadStdAttributes;
    }
    /** 
     * Qualifier choices.

    Notes: 
    1. These qualifiers may be specified for (e.g. apply to) both Attribute and Affinity queries.
    2. These capabilities may not be supported by all NDC-enabled systems or may be supported by bilateral agreement only. If supported, the technical implementation of the capability is not dictated by this specification. 
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Qualifier" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element ref="ns:BaggagePricingQualifier" minOccurs="0"/>
     *       &lt;xs:element ref="ns:ExistingOrderQualifier" minOccurs="0"/>
     *       &lt;xs:element ref="ns:PaymentCardQualifiers" minOccurs="0" maxOccurs="unbounded"/>
     *       &lt;xs:element ref="ns:ProgramQualifiers" minOccurs="0"/>
     *       &lt;xs:element ref="ns:PromotionQualifiers" minOccurs="0"/>
     *       &lt;xs:element ref="ns:SeatQualifier" minOccurs="0"/>
     *       &lt;xs:element ref="ns:ServiceQualifier" minOccurs="0"/>
     *       &lt;xs:element ref="ns:SocialMediaQualifiers" minOccurs="0"/>
     *       &lt;xs:element ref="ns:SpecialFareQualifiers" minOccurs="0"/>
     *       &lt;xs:element ref="ns:SpecialNeedQualifiers" minOccurs="0"/>
     *       &lt;xs:element ref="ns:TripPurposeQualifier" minOccurs="0"/>
     *       &lt;xs:element name="FOPQualifier" minOccurs="0">
     *         &lt;!-- Reference to inner class FOPQualifier -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Qualifier implements Serializable
    {
        private BaggagePricingQualifierType baggagePricingQualifier;
        private ExistingOrderQualifier existingOrderQualifier;
        private List<CardQualifierType> paymentCardQualifierList = new ArrayList<CardQualifierType>();
        private ProgramQualifiers programQualifiers;
        private PromotionQualifiers promotionQualifiers;
        private SeatQualifier seatQualifier;
        private ServiceQualifierPriceType serviceQualifier;
        private SocialMediaQualifierType socialMediaQualifiers;
        private FareQualifierType specialFareQualifiers;
        private SpecialType specialNeedQualifiers;
        private TripPurposeQualifier tripPurposeQualifier;
        private FOPQualifier FOPQualifier1;

        /** 
         * Get the 'BaggagePricingQualifier' element value.
         * 
         * @return value
         */
        public BaggagePricingQualifierType getBaggagePricingQualifier() {
            return baggagePricingQualifier;
        }

        /** 
         * Set the 'BaggagePricingQualifier' element value.
         * 
         * @param baggagePricingQualifier
         */
        public void setBaggagePricingQualifier(
                BaggagePricingQualifierType baggagePricingQualifier) {
            this.baggagePricingQualifier = baggagePricingQualifier;
        }

        /** 
         * Get the 'ExistingOrderQualifier' element value.
         * 
         * @return value
         */
        public ExistingOrderQualifier getExistingOrderQualifier() {
            return existingOrderQualifier;
        }

        /** 
         * Set the 'ExistingOrderQualifier' element value.
         * 
         * @param existingOrderQualifier
         */
        public void setExistingOrderQualifier(
                ExistingOrderQualifier existingOrderQualifier) {
            this.existingOrderQualifier = existingOrderQualifier;
        }

        /** 
         * Get the list of 'PaymentCardQualifiers' element items.
         * 
         * @return list
         */
        public List<CardQualifierType> getPaymentCardQualifierList() {
            return paymentCardQualifierList;
        }

        /** 
         * Set the list of 'PaymentCardQualifiers' element items.
         * 
         * @param list
         */
        public void setPaymentCardQualifierList(List<CardQualifierType> list) {
            paymentCardQualifierList = list;
        }

        /** 
         * Get the 'ProgramQualifiers' element value.
         * 
         * @return value
         */
        public ProgramQualifiers getProgramQualifiers() {
            return programQualifiers;
        }

        /** 
         * Set the 'ProgramQualifiers' element value.
         * 
         * @param programQualifiers
         */
        public void setProgramQualifiers(ProgramQualifiers programQualifiers) {
            this.programQualifiers = programQualifiers;
        }

        /** 
         * Get the 'PromotionQualifiers' element value.
         * 
         * @return value
         */
        public PromotionQualifiers getPromotionQualifiers() {
            return promotionQualifiers;
        }

        /** 
         * Set the 'PromotionQualifiers' element value.
         * 
         * @param promotionQualifiers
         */
        public void setPromotionQualifiers(
                PromotionQualifiers promotionQualifiers) {
            this.promotionQualifiers = promotionQualifiers;
        }

        /** 
         * Get the 'SeatQualifier' element value.
         * 
         * @return value
         */
        public SeatQualifier getSeatQualifier() {
            return seatQualifier;
        }

        /** 
         * Set the 'SeatQualifier' element value.
         * 
         * @param seatQualifier
         */
        public void setSeatQualifier(SeatQualifier seatQualifier) {
            this.seatQualifier = seatQualifier;
        }

        /** 
         * Get the 'ServiceQualifier' element value.
         * 
         * @return value
         */
        public ServiceQualifierPriceType getServiceQualifier() {
            return serviceQualifier;
        }

        /** 
         * Set the 'ServiceQualifier' element value.
         * 
         * @param serviceQualifier
         */
        public void setServiceQualifier(
                ServiceQualifierPriceType serviceQualifier) {
            this.serviceQualifier = serviceQualifier;
        }

        /** 
         * Get the 'SocialMediaQualifiers' element value.
         * 
         * @return value
         */
        public SocialMediaQualifierType getSocialMediaQualifiers() {
            return socialMediaQualifiers;
        }

        /** 
         * Set the 'SocialMediaQualifiers' element value.
         * 
         * @param socialMediaQualifiers
         */
        public void setSocialMediaQualifiers(
                SocialMediaQualifierType socialMediaQualifiers) {
            this.socialMediaQualifiers = socialMediaQualifiers;
        }

        /** 
         * Get the 'SpecialFareQualifiers' element value.
         * 
         * @return value
         */
        public FareQualifierType getSpecialFareQualifiers() {
            return specialFareQualifiers;
        }

        /** 
         * Set the 'SpecialFareQualifiers' element value.
         * 
         * @param specialFareQualifiers
         */
        public void setSpecialFareQualifiers(
                FareQualifierType specialFareQualifiers) {
            this.specialFareQualifiers = specialFareQualifiers;
        }

        /** 
         * Get the 'SpecialNeedQualifiers' element value.
         * 
         * @return value
         */
        public SpecialType getSpecialNeedQualifiers() {
            return specialNeedQualifiers;
        }

        /** 
         * Set the 'SpecialNeedQualifiers' element value.
         * 
         * @param specialNeedQualifiers
         */
        public void setSpecialNeedQualifiers(SpecialType specialNeedQualifiers) {
            this.specialNeedQualifiers = specialNeedQualifiers;
        }

        /** 
         * Get the 'TripPurposeQualifier' element value.
         * 
         * @return value
         */
        public TripPurposeQualifier getTripPurposeQualifier() {
            return tripPurposeQualifier;
        }

        /** 
         * Set the 'TripPurposeQualifier' element value.
         * 
         * @param tripPurposeQualifier
         */
        public void setTripPurposeQualifier(
                TripPurposeQualifier tripPurposeQualifier) {
            this.tripPurposeQualifier = tripPurposeQualifier;
        }

        /** 
         * Get the 'FOPQualifier' element value.
         * 
         * @return value
         */
        public FOPQualifier getFOPQualifier1() {
            return FOPQualifier1;
        }

        /** 
         * Set the 'FOPQualifier' element value.
         * 
         * @param FOPQualifier1
         */
        public void setFOPQualifier1(FOPQualifier FOPQualifier1) {
            this.FOPQualifier1 = FOPQualifier1;
        }
        /** 
         * Contains Forms of Payment type and may include a reference to a passenger.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FOPQualifier" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="xs:string" name="PassengerReferences" minOccurs="0"/>
         *       &lt;xs:element type="xs:string" name="Type" maxOccurs="unbounded"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class FOPQualifier implements Serializable
        {
            private String passengerReferences;
            private List<String> typeList = new ArrayList<String>();

            /** 
             * Get the 'PassengerReferences' element value. Association to multiple Passenger instance(s). Example: Passenger1 Passenger2

            Note: May be Recognized or Anonymous Passenger (by PTC) instance(s).
             * 
             * @return value
             */
            public String getPassengerReferences() {
                return passengerReferences;
            }

            /** 
             * Set the 'PassengerReferences' element value. Association to multiple Passenger instance(s). Example: Passenger1 Passenger2

            Note: May be Recognized or Anonymous Passenger (by PTC) instance(s).
             * 
             * @param passengerReferences
             */
            public void setPassengerReferences(String passengerReferences) {
                this.passengerReferences = passengerReferences;
            }

            /** 
             * Get the list of 'Type' element items. The form of payment type. Examples: Credit Card, Cash.

            Encoding Scheme: IATA PADIS code list data element [9888] Form of Payment Identification
             * 
             * @return list
             */
            public List<String> getTypeList() {
                return typeList;
            }

            /** 
             * Set the list of 'Type' element items. The form of payment type. Examples: Credit Card, Cash.

            Encoding Scheme: IATA PADIS code list data element [9888] Form of Payment Identification
             * 
             * @param list
             */
            public void setTypeList(List<String> list) {
                typeList = list;
            }
        }
    }
    /** 
     * Preference choices.

    Notes: 
    1. These preferences may be specified for (e.g. apply to) both Attribute and Affinity queries.
    2. These capabilities may not be supported by all NDC-enabled systems or may be supported by bilateral agreement only. If supported, the technical implementation of the capability is not dictated by this specification. 
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Preference" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element ref="ns:AirlinePreferences" minOccurs="0"/>
     *       &lt;xs:element ref="ns:AlliancePreferences" minOccurs="0"/>
     *       &lt;xs:element ref="ns:FarePreferences" minOccurs="0"/>
     *       &lt;xs:element ref="ns:FlightPreferences" minOccurs="0"/>
     *       &lt;xs:element ref="ns:PricingMethodPreference" minOccurs="0"/>
     *       &lt;xs:element ref="ns:SegMaxTimePreferences" minOccurs="0"/>
     *       &lt;xs:element ref="ns:ServicePricingOnlyPreference" minOccurs="0"/>
     *       &lt;xs:element ref="ns:TransferPreferences" minOccurs="0"/>
     *       &lt;xs:element ref="ns:CabinPreferences" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Preference implements Serializable
    {
        private AirlinePreferencesType airlinePreferences;
        private AlliancePreferencesType alliancePreferences;
        private FarePreferencesType farePreferences;
        private FlightPreferencesType flightPreferences;
        private BestPricingPreferencesType pricingMethodPreference;
        private FltSegmentMaxTimePreferencesType segMaxTimePreferences;
        private ServicePricingOnlyPreference servicePricingOnlyPreference;
        private TransferPreferencesType transferPreferences;
        private CabinPreferencesType cabinPreferences;

        /** 
         * Get the 'AirlinePreferences' element value.
         * 
         * @return value
         */
        public AirlinePreferencesType getAirlinePreferences() {
            return airlinePreferences;
        }

        /** 
         * Set the 'AirlinePreferences' element value.
         * 
         * @param airlinePreferences
         */
        public void setAirlinePreferences(
                AirlinePreferencesType airlinePreferences) {
            this.airlinePreferences = airlinePreferences;
        }

        /** 
         * Get the 'AlliancePreferences' element value.
         * 
         * @return value
         */
        public AlliancePreferencesType getAlliancePreferences() {
            return alliancePreferences;
        }

        /** 
         * Set the 'AlliancePreferences' element value.
         * 
         * @param alliancePreferences
         */
        public void setAlliancePreferences(
                AlliancePreferencesType alliancePreferences) {
            this.alliancePreferences = alliancePreferences;
        }

        /** 
         * Get the 'FarePreferences' element value.
         * 
         * @return value
         */
        public FarePreferencesType getFarePreferences() {
            return farePreferences;
        }

        /** 
         * Set the 'FarePreferences' element value.
         * 
         * @param farePreferences
         */
        public void setFarePreferences(FarePreferencesType farePreferences) {
            this.farePreferences = farePreferences;
        }

        /** 
         * Get the 'FlightPreferences' element value.
         * 
         * @return value
         */
        public FlightPreferencesType getFlightPreferences() {
            return flightPreferences;
        }

        /** 
         * Set the 'FlightPreferences' element value.
         * 
         * @param flightPreferences
         */
        public void setFlightPreferences(FlightPreferencesType flightPreferences) {
            this.flightPreferences = flightPreferences;
        }

        /** 
         * Get the 'PricingMethodPreference' element value.
         * 
         * @return value
         */
        public BestPricingPreferencesType getPricingMethodPreference() {
            return pricingMethodPreference;
        }

        /** 
         * Set the 'PricingMethodPreference' element value.
         * 
         * @param pricingMethodPreference
         */
        public void setPricingMethodPreference(
                BestPricingPreferencesType pricingMethodPreference) {
            this.pricingMethodPreference = pricingMethodPreference;
        }

        /** 
         * Get the 'SegMaxTimePreferences' element value.
         * 
         * @return value
         */
        public FltSegmentMaxTimePreferencesType getSegMaxTimePreferences() {
            return segMaxTimePreferences;
        }

        /** 
         * Set the 'SegMaxTimePreferences' element value.
         * 
         * @param segMaxTimePreferences
         */
        public void setSegMaxTimePreferences(
                FltSegmentMaxTimePreferencesType segMaxTimePreferences) {
            this.segMaxTimePreferences = segMaxTimePreferences;
        }

        /** 
         * Get the 'ServicePricingOnlyPreference' element value.
         * 
         * @return value
         */
        public ServicePricingOnlyPreference getServicePricingOnlyPreference() {
            return servicePricingOnlyPreference;
        }

        /** 
         * Set the 'ServicePricingOnlyPreference' element value.
         * 
         * @param servicePricingOnlyPreference
         */
        public void setServicePricingOnlyPreference(
                ServicePricingOnlyPreference servicePricingOnlyPreference) {
            this.servicePricingOnlyPreference = servicePricingOnlyPreference;
        }

        /** 
         * Get the 'TransferPreferences' element value.
         * 
         * @return value
         */
        public TransferPreferencesType getTransferPreferences() {
            return transferPreferences;
        }

        /** 
         * Set the 'TransferPreferences' element value.
         * 
         * @param transferPreferences
         */
        public void setTransferPreferences(
                TransferPreferencesType transferPreferences) {
            this.transferPreferences = transferPreferences;
        }

        /** 
         * Get the 'CabinPreferences' element value.
         * 
         * @return value
         */
        public CabinPreferencesType getCabinPreferences() {
            return cabinPreferences;
        }

        /** 
         * Set the 'CabinPreferences' element value.
         * 
         * @param cabinPreferences
         */
        public void setCabinPreferences(CabinPreferencesType cabinPreferences) {
            this.cabinPreferences = cabinPreferences;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DataLists" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="PassengerList" minOccurs="0">
     *         &lt;!-- Reference to inner class PassengerList -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="ContactList" minOccurs="0">
     *         &lt;!-- Reference to inner class ContactList -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class DataLists implements Serializable
    {
        private PassengerList passengerList;
        private ContactList contactList;

        /** 
         * Get the 'PassengerList' element value.
         * 
         * @return value
         */
        public PassengerList getPassengerList() {
            return passengerList;
        }

        /** 
         * Set the 'PassengerList' element value.
         * 
         * @param passengerList
         */
        public void setPassengerList(PassengerList passengerList) {
            this.passengerList = passengerList;
        }

        /** 
         * Get the 'ContactList' element value.
         * 
         * @return value
         */
        public ContactList getContactList() {
            return contactList;
        }

        /** 
         * Set the 'ContactList' element value.
         * 
         * @param contactList
         */
        public void setContactList(ContactList contactList) {
            this.contactList = contactList;
        }
        /** 
         * Passenger data list definition.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PassengerList" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="ns:PassengerType" name="Passenger" maxOccurs="unbounded"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class PassengerList implements Serializable
        {
            private List<PassengerType> passengerList = new ArrayList<PassengerType>();

            /** 
             * Get the list of 'Passenger' element items. Any person except members of the crew carried or to be carried with the consent of the carrier, on board of any transport vehicle such as aircraft, train, bus, ship.
             * 
             * @return list
             */
            public List<PassengerType> getPassengerList() {
                return passengerList;
            }

            /** 
             * Set the list of 'Passenger' element items. Any person except members of the crew carried or to be carried with the consent of the carrier, on board of any transport vehicle such as aircraft, train, bus, ship.
             * 
             * @param list
             */
            public void setPassengerList(List<PassengerType> list) {
                passengerList = list;
            }
        }
        /** 
         * Contact data list definition.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ContactList" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="ns:ContactInformationType" name="ContactInformation" maxOccurs="unbounded"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class ContactList implements Serializable
        {
            private List<ContactInformationType> contactInformationList = new ArrayList<ContactInformationType>();

            /** 
             * Get the list of 'ContactInformation' element items. The electronic or geographic address which a party has provided as the contact channel. For example, contact email, contact postal address, contact phone number.
             * 
             * @return list
             */
            public List<ContactInformationType> getContactInformationList() {
                return contactInformationList;
            }

            /** 
             * Set the list of 'ContactInformation' element items. The electronic or geographic address which a party has provided as the contact channel. For example, contact email, contact postal address, contact phone number.
             * 
             * @param list
             */
            public void setContactInformationList(
                    List<ContactInformationType> list) {
                contactInformationList = list;
            }
        }
    }
}
