
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * AIRCRAFT EQUIPMENT CODE QUERY representation.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AircraftTailNmbrQueryType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="TailNumber" maxOccurs="unbounded"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class AircraftTailNmbrQueryType implements Serializable
{
    private List<String> tailNumberList = new ArrayList<String>();
    private String refs;

    /** 
     * Get the list of 'TailNumber' element items. Aircraft Equipment Tail Number.
     * 
     * @return list
     */
    public List<String> getTailNumberList() {
        return tailNumberList;
    }

    /** 
     * Set the list of 'TailNumber' element items. Aircraft Equipment Tail Number.
     * 
     * @param list
     */
    public void setTailNumberList(List<String> list) {
        tailNumberList = list;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getRefs() {
        return refs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param refs
     */
    public void setRefs(String refs) {
        this.refs = refs;
    }
}
