
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Airline Profile Sender pushes Airline Profile or link to Airline Profile Receivers that have been activated/authorized, including Profile version number.                              
 The message also returns multi-media content at the message level with media content references at the individual service level.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AirlineProfileNotif">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element ref="ns:Document"/>
 *       &lt;xs:element ref="ns:Party"/>
 *       &lt;xs:element name="Query">
 *         &lt;xs:complexType>
 *           &lt;xs:sequence>
 *             &lt;xs:element name="ReceiverID" minOccurs="0"/>
 *             &lt;xs:element type="ns:AirlineID_Type" name="ProfileOwner"/>
 *             &lt;xs:element name="SourceFiles" minOccurs="0">
 *               &lt;!-- Reference to inner class SourceFiles -->
 *             &lt;/xs:element>
 *             &lt;xs:element name="ActionType" minOccurs="0">
 *               &lt;!-- Reference to inner class ActionType -->
 *             &lt;/xs:element>
 *           &lt;/xs:sequence>
 *         &lt;/xs:complexType>
 *       &lt;/xs:element>
 *     &lt;/xs:sequence>
 *     &lt;xs:attributeGroup ref="ns:IATA_PayloadStdAttributes"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class AirlineProfileNotif implements Serializable
{
    private MsgDocumentType document;
    private MsgPartiesType party;
    private boolean queryReceiverID;
    private AirlineIDType queryProfileOwner;
    private SourceFiles sourceFiles;
    private ActionType actionType;
    private IATAPayloadStdAttributes IATAPayloadStdAttributes;

    /** 
     * Get the 'Document' element value.
     * 
     * @return value
     */
    public MsgDocumentType getDocument() {
        return document;
    }

    /** 
     * Set the 'Document' element value.
     * 
     * @param document
     */
    public void setDocument(MsgDocumentType document) {
        this.document = document;
    }

    /** 
     * Get the 'Party' element value.
     * 
     * @return value
     */
    public MsgPartiesType getParty() {
        return party;
    }

    /** 
     * Set the 'Party' element value.
     * 
     * @param party
     */
    public void setParty(MsgPartiesType party) {
        this.party = party;
    }

    /** 
     * Check if the 'ReceiverID' element is present.
     * 
     * @return <code>true</code> if present, <code>false</code> if not
     */
    public boolean ifQueryReceiverIDPresent() {
        return queryReceiverID;
    }

    /** 
     * Set flag for 'ReceiverID' element present.
     * 
     * @param queryReceiverID
     */
    public void flagQueryReceiverIDPresent(boolean queryReceiverID) {
        this.queryReceiverID = queryReceiverID;
    }

    /** 
     * Get the 'ProfileOwner' element value. Profile owner (Airline)
     * 
     * @return value
     */
    public AirlineIDType getQueryProfileOwner() {
        return queryProfileOwner;
    }

    /** 
     * Set the 'ProfileOwner' element value. Profile owner (Airline)
     * 
     * @param queryProfileOwner
     */
    public void setQueryProfileOwner(AirlineIDType queryProfileOwner) {
        this.queryProfileOwner = queryProfileOwner;
    }

    /** 
     * Get the 'SourceFiles' element value. Core Query for requesting Airline Profiles.
     * 
     * @return value
     */
    public SourceFiles getSourceFiles() {
        return sourceFiles;
    }

    /** 
     * Set the 'SourceFiles' element value. Core Query for requesting Airline Profiles.
     * 
     * @param sourceFiles
     */
    public void setSourceFiles(SourceFiles sourceFiles) {
        this.sourceFiles = sourceFiles;
    }

    /** 
     * Get the 'ActionType' element value. Core Query for requesting Airline Profiles.
     * 
     * @return value
     */
    public ActionType getActionType() {
        return actionType;
    }

    /** 
     * Set the 'ActionType' element value. Core Query for requesting Airline Profiles.
     * 
     * @param actionType
     */
    public void setActionType(ActionType actionType) {
        this.actionType = actionType;
    }

    /** 
     * Get the 'IATA_PayloadStdAttributes' attributeGroup value.
     * 
     * @return value
     */
    public IATAPayloadStdAttributes getIATAPayloadStdAttributes() {
        return IATAPayloadStdAttributes;
    }

    /** 
     * Set the 'IATA_PayloadStdAttributes' attributeGroup value.
     * 
     * @param IATAPayloadStdAttributes
     */
    public void setIATAPayloadStdAttributes(
            IATAPayloadStdAttributes IATAPayloadStdAttributes) {
        this.IATAPayloadStdAttributes = IATAPayloadStdAttributes;
    }
    /** 
     * Airline Profile Data elements or Link
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SourceFiles" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="SourceFile" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class SourceFile -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class SourceFiles implements Serializable
    {
        private List<SourceFile> sourceFileList = new ArrayList<SourceFile>();

        /** 
         * Get the list of 'SourceFile' element items.
         * 
         * @return list
         */
        public List<SourceFile> getSourceFileList() {
            return sourceFileList;
        }

        /** 
         * Set the list of 'SourceFile' element items.
         * 
         * @param list
         */
        public void setSourceFileList(List<SourceFile> list) {
            sourceFileList = list;
        }
        /** 
         * Airline Profile Data elements or Link
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SourceFile" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:choice>
         *       &lt;xs:element type="xs:string" name="MediaLink"/>
         *       &lt;xs:element name="DataItems">
         *         &lt;!-- Reference to inner class DataItems -->
         *       &lt;/xs:element>
         *     &lt;/xs:choice>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class SourceFile implements Serializable
        {
            private int sourceFileListSelect = -1;
            private static final int MEDIA_LINK_CHOICE = 0;
            private static final int DATA_ITEMS_CHOICE = 1;
            private String mediaLink;
            private DataItems dataItems;

            private void setSourceFileListSelect(int choice) {
                if (sourceFileListSelect == -1) {
                    sourceFileListSelect = choice;
                } else if (sourceFileListSelect != choice) {
                    throw new IllegalStateException(
                            "Need to call clearSourceFileListSelect() before changing existing choice");
                }
            }

            /** 
             * Clear the choice selection.
             */
            public void clearSourceFileListSelect() {
                sourceFileListSelect = -1;
            }

            /** 
             * Check if MediaLink is current selection for choice.
             * 
             * @return <code>true</code> if selection, <code>false</code> if not
             */
            public boolean ifMediaLink() {
                return sourceFileListSelect == MEDIA_LINK_CHOICE;
            }

            /** 
             * Get the 'MediaLink' element value. Link to Airline Profile Source File. Alows large AP file to be distributed over FTP, FTPS, ... as agreed bilaterally with Profile Owner
             * 
             * @return value
             */
            public String getMediaLink() {
                return mediaLink;
            }

            /** 
             * Set the 'MediaLink' element value. Link to Airline Profile Source File. Alows large AP file to be distributed over FTP, FTPS, ... as agreed bilaterally with Profile Owner
             * 
             * @param mediaLink
             */
            public void setMediaLink(String mediaLink) {
                setSourceFileListSelect(MEDIA_LINK_CHOICE);
                this.mediaLink = mediaLink;
            }

            /** 
             * Check if DataItems is current selection for choice.
             * 
             * @return <code>true</code> if selection, <code>false</code> if not
             */
            public boolean ifDataItems() {
                return sourceFileListSelect == DATA_ITEMS_CHOICE;
            }

            /** 
             * Get the 'DataItems' element value.
             * 
             * @return value
             */
            public DataItems getDataItems() {
                return dataItems;
            }

            /** 
             * Set the 'DataItems' element value.
             * 
             * @param dataItems
             */
            public void setDataItems(DataItems dataItems) {
                setSourceFileListSelect(DATA_ITEMS_CHOICE);
                this.dataItems = dataItems;
            }
            /** 
             * Actual Data Elements of the Profile
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DataItems">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="ns:GeographicSpecificationType" name="POSGeoSpecification" minOccurs="0" maxOccurs="unbounded"/>
             *       &lt;xs:element type="ns:NonGeographicSpecificationType" name="POSNonGeoSpecification" minOccurs="0" maxOccurs="unbounded"/>
             *       &lt;xs:element type="ns:OfferGeographicSpecificationType" name="OfferGeoSpecification" minOccurs="0" maxOccurs="unbounded"/>
             *       &lt;xs:element name="OfferedService" minOccurs="0" maxOccurs="4">
             *         &lt;!-- Reference to inner class OfferedService -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:anySimpleType" use="required" name="ActionType"/>
             *     &lt;xs:attribute type="xs:long" use="required" name="SequenceNumber"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class DataItems implements Serializable
            {
                private List<GeographicSpecificationType> POSGeoSpecificationList = new ArrayList<GeographicSpecificationType>();
                private List<NonGeographicSpecificationType> POSNonGeoSpecificationList = new ArrayList<NonGeographicSpecificationType>();
                private List<OfferGeographicSpecificationType> offerGeoSpecificationList = new ArrayList<OfferGeographicSpecificationType>();
                private List<OfferedService> offeredServiceList = new ArrayList<OfferedService>();
                private String actionType;
                private long sequenceNumber;

                /** 
                 * Get the list of 'POSGeoSpecification' element items. Point of sale Geographic Specification information.
                 * 
                 * @return list
                 */
                public List<GeographicSpecificationType> getPOSGeoSpecificationList() {
                    return POSGeoSpecificationList;
                }

                /** 
                 * Set the list of 'POSGeoSpecification' element items. Point of sale Geographic Specification information.
                 * 
                 * @param list
                 */
                public void setPOSGeoSpecificationList(
                        List<GeographicSpecificationType> list) {
                    POSGeoSpecificationList = list;
                }

                /** 
                 * Get the list of 'POSNonGeoSpecification' element items. Point of sale Non Geographic Specification information.
                 * 
                 * @return list
                 */
                public List<NonGeographicSpecificationType> getPOSNonGeoSpecificationList() {
                    return POSNonGeoSpecificationList;
                }

                /** 
                 * Set the list of 'POSNonGeoSpecification' element items. Point of sale Non Geographic Specification information.
                 * 
                 * @param list
                 */
                public void setPOSNonGeoSpecificationList(
                        List<NonGeographicSpecificationType> list) {
                    POSNonGeoSpecificationList = list;
                }

                /** 
                 * Get the list of 'OfferGeoSpecification' element items. Offer Geographic Specification
                 * 
                 * @return list
                 */
                public List<OfferGeographicSpecificationType> getOfferGeoSpecificationList() {
                    return offerGeoSpecificationList;
                }

                /** 
                 * Set the list of 'OfferGeoSpecification' element items. Offer Geographic Specification
                 * 
                 * @param list
                 */
                public void setOfferGeoSpecificationList(
                        List<OfferGeographicSpecificationType> list) {
                    offerGeoSpecificationList = list;
                }

                /** 
                 * Get the list of 'OfferedService' element items.
                 * 
                 * @return list
                 */
                public List<OfferedService> getOfferedServiceList() {
                    return offeredServiceList;
                }

                /** 
                 * Set the list of 'OfferedService' element items.
                 * 
                 * @param list
                 */
                public void setOfferedServiceList(List<OfferedService> list) {
                    offeredServiceList = list;
                }

                /** 
                 * Get the 'ActionType' attribute value. Add, Delete, Or Change
                 * 
                 * @return value
                 */
                public String getActionType() {
                    return actionType;
                }

                /** 
                 * Set the 'ActionType' attribute value. Add, Delete, Or Change
                 * 
                 * @param actionType
                 */
                public void setActionType(String actionType) {
                    this.actionType = actionType;
                }

                /** 
                 * Get the 'SequenceNumber' attribute value. Global sequence number of this record in the Airline profile.
                 * 
                 * @return value
                 */
                public long getSequenceNumber() {
                    return sequenceNumber;
                }

                /** 
                 * Set the 'SequenceNumber' attribute value. Global sequence number of this record in the Airline profile.
                 * 
                 * @param sequenceNumber
                 */
                public void setSequenceNumber(long sequenceNumber) {
                    this.sequenceNumber = sequenceNumber;
                }
                /** 
                 * Offered Service.      Example:                         1. Transportation               2. Baggage                      3. Seats                           4. Other     
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OfferedService" minOccurs="0" maxOccurs="4">
                 *   &lt;xs:complexType>
                 *     &lt;xs:simpleContent>
                 *       &lt;xs:extension base="ns:OfferedServiceType">
                 *         &lt;xs:attribute type="xs:anySimpleType" name="Permitted"/>
                 *       &lt;/xs:extension>
                 *     &lt;/xs:simpleContent>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class OfferedService implements Serializable
                {
                    private OfferedServiceType offeredServiceType;
                    private String permitted;

                    /** 
                     * Get the extension value.
                     * 
                     * @return value
                     */
                    public OfferedServiceType getOfferedServiceType() {
                        return offeredServiceType;
                    }

                    /** 
                     * Set the extension value.
                     * 
                     * @param offeredServiceType
                     */
                    public void setOfferedServiceType(
                            OfferedServiceType offeredServiceType) {
                        this.offeredServiceType = offeredServiceType;
                    }

                    /** 
                     * Get the 'Permitted' attribute value. Specify whether the service is offered. Example: True
                     * 
                     * @return value
                     */
                    public String getPermitted() {
                        return permitted;
                    }

                    /** 
                     * Set the 'Permitted' attribute value. Specify whether the service is offered. Example: True
                     * 
                     * @param permitted
                     */
                    public void setPermitted(String permitted) {
                        this.permitted = permitted;
                    }
                }
            }
        }
    }
    /** 
     * Type of action. Examples:  Create, Update, Delete.
                
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ActionType" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:simpleContent>
     *       &lt;xs:extension base="xs:string">
     *         &lt;xs:attribute type="xs:string" use="optional" name="Context"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:simpleContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class ActionType implements Serializable
    {
        private String string;
        private String context;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public String getString() {
            return string;
        }

        /** 
         * Set the extension value.
         * 
         * @param string
         */
        public void setString(String string) {
            this.string = string;
        }

        /** 
         * Get the 'Context' attribute value. Action Type Context.
         * 
         * @return value
         */
        public String getContext() {
            return context;
        }

        /** 
         * Set the 'Context' attribute value. Action Type Context.
         * 
         * @param context
         */
        public void setContext(String context) {
            this.context = context;
        }
    }
}
