
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Request from an Airline Profile Receiver to an Airline Profile Sender to send one or more Airlines’ Profiles.                                             The Airline Profile (AP) aims at streamlining the volume of NDC shopping requests sent to airline systems by Aggregators or Seller systems.                              
 The message also returns multi-media content at the message level with media content references at the individual service level.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AirlineProfileRQ">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element ref="ns:PointOfSale" minOccurs="0"/>
 *       &lt;xs:element ref="ns:Document"/>
 *       &lt;xs:element ref="ns:Party"/>
 *       &lt;xs:element name="Query">
 *         &lt;xs:complexType>
 *           &lt;xs:choice>
 *             &lt;xs:element name="ProfileOwner" maxOccurs="unbounded">
 *               &lt;!-- Reference to inner class ProfileOwner -->
 *             &lt;/xs:element>
 *             &lt;xs:element name="AllProfiles">
 *               &lt;xs:complexType>
 *                 &lt;xs:complexContent>
 *                   &lt;xs:extension base="ns:SuccessType">
 *                     &lt;xs:attribute type="xs:boolean" name="MediaLinkInd"/>
 *                   &lt;/xs:extension>
 *                 &lt;/xs:complexContent>
 *               &lt;/xs:complexType>
 *             &lt;/xs:element>
 *           &lt;/xs:choice>
 *         &lt;/xs:complexType>
 *       &lt;/xs:element>
 *     &lt;/xs:sequence>
 *     &lt;xs:attributeGroup ref="ns:IATA_PayloadStdAttributes"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class AirlineProfileRQ implements Serializable
{
    private PointOfSaleType pointOfSale;
    private MsgDocumentType document;
    private MsgPartiesType party;
    private int querySelect = -1;
    private static final int PROFILE_OWNER_LIST_CHOICE = 0;
    private static final int QUERY_ALL_PROFILES_CHOICE = 1;
    private List<ProfileOwner> profileOwnerList = new ArrayList<ProfileOwner>();
    private SuccessType queryAllProfilesSuccessType;
    private Boolean queryAllProfilesMediaLinkInd;
    private IATAPayloadStdAttributes IATAPayloadStdAttributes;

    /** 
     * Get the 'PointOfSale' element value.
     * 
     * @return value
     */
    public PointOfSaleType getPointOfSale() {
        return pointOfSale;
    }

    /** 
     * Set the 'PointOfSale' element value.
     * 
     * @param pointOfSale
     */
    public void setPointOfSale(PointOfSaleType pointOfSale) {
        this.pointOfSale = pointOfSale;
    }

    /** 
     * Get the 'Document' element value.
     * 
     * @return value
     */
    public MsgDocumentType getDocument() {
        return document;
    }

    /** 
     * Set the 'Document' element value.
     * 
     * @param document
     */
    public void setDocument(MsgDocumentType document) {
        this.document = document;
    }

    /** 
     * Get the 'Party' element value.
     * 
     * @return value
     */
    public MsgPartiesType getParty() {
        return party;
    }

    /** 
     * Set the 'Party' element value.
     * 
     * @param party
     */
    public void setParty(MsgPartiesType party) {
        this.party = party;
    }

    private void setQuerySelect(int choice) {
        if (querySelect == -1) {
            querySelect = choice;
        } else if (querySelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearQuerySelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearQuerySelect() {
        querySelect = -1;
    }

    /** 
     * Check if ProfileOwnerList is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifProfileOwnerList() {
        return querySelect == PROFILE_OWNER_LIST_CHOICE;
    }

    /** 
     * Get the list of 'ProfileOwner' element items. Core Query for requesting Airline Profiles.
     * 
     * @return list
     */
    public List<ProfileOwner> getProfileOwnerList() {
        return profileOwnerList;
    }

    /** 
     * Set the list of 'ProfileOwner' element items. Core Query for requesting Airline Profiles.
     * 
     * @param list
     */
    public void setProfileOwnerList(List<ProfileOwner> list) {
        setQuerySelect(PROFILE_OWNER_LIST_CHOICE);
        profileOwnerList = list;
    }

    /** 
     * Check if QueryAllProfiles is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifQueryAllProfiles() {
        return querySelect == QUERY_ALL_PROFILES_CHOICE;
    }

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public SuccessType getQueryAllProfilesSuccessType() {
        return queryAllProfilesSuccessType;
    }

    /** 
     * Set the extension value.
     * 
     * @param queryAllProfilesSuccessType
     */
    public void setQueryAllProfilesSuccessType(
            SuccessType queryAllProfilesSuccessType) {
        setQuerySelect(QUERY_ALL_PROFILES_CHOICE);
        this.queryAllProfilesSuccessType = queryAllProfilesSuccessType;
    }

    /** 
     * Get the 'MediaLinkInd' attribute value. When True, only media link to profile location is requested and is expected to be returned.
     * 
     * @return value
     */
    public Boolean getQueryAllProfilesMediaLinkInd() {
        return queryAllProfilesMediaLinkInd;
    }

    /** 
     * Set the 'MediaLinkInd' attribute value. When True, only media link to profile location is requested and is expected to be returned.
     * 
     * @param queryAllProfilesMediaLinkInd
     */
    public void setQueryAllProfilesMediaLinkInd(
            Boolean queryAllProfilesMediaLinkInd) {
        setQuerySelect(QUERY_ALL_PROFILES_CHOICE);
        this.queryAllProfilesMediaLinkInd = queryAllProfilesMediaLinkInd;
    }

    /** 
     * Get the 'IATA_PayloadStdAttributes' attributeGroup value.
     * 
     * @return value
     */
    public IATAPayloadStdAttributes getIATAPayloadStdAttributes() {
        return IATAPayloadStdAttributes;
    }

    /** 
     * Set the 'IATA_PayloadStdAttributes' attributeGroup value.
     * 
     * @param IATAPayloadStdAttributes
     */
    public void setIATAPayloadStdAttributes(
            IATAPayloadStdAttributes IATAPayloadStdAttributes) {
        this.IATAPayloadStdAttributes = IATAPayloadStdAttributes;
    }
    /** 
     * Profile owner (Airline)
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ProfileOwner" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:complexContent>
     *       &lt;xs:extension base="xs:string">
     *         &lt;xs:attribute type="xs:boolean" name="MediaLinkInd"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:complexContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class ProfileOwner implements Serializable
    {
        private Boolean mediaLinkInd;

        /** 
         * Get the 'MediaLinkInd' attribute value. When True, only media link to profile location is requested and is expected to be returned.
         * 
         * @return value
         */
        public Boolean getMediaLinkInd() {
            return mediaLinkInd;
        }

        /** 
         * Set the 'MediaLinkInd' attribute value. When True, only media link to profile location is requested and is expected to be returned.
         * 
         * @param mediaLinkInd
         */
        public void setMediaLinkInd(Boolean mediaLinkInd) {
            this.mediaLinkInd = mediaLinkInd;
        }
    }
}
