
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Response from an Airline Profile Sender to an Airline Profile Receiver to get one or more Airlines’ Profiles            
 The message also returns multi-media content at the message level with media content references at the individual service level.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AirlineProfileRS">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element ref="ns:Document"/>
 *       &lt;xs:choice>
 *         &lt;xs:sequence>
 *           &lt;!-- Reference to inner class Sequence -->
 *         &lt;/xs:sequence>
 *         &lt;xs:element ref="ns:Errors"/>
 *       &lt;/xs:choice>
 *     &lt;/xs:sequence>
 *     &lt;xs:attributeGroup ref="ns:IATA_PayloadStdAttributes"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class AirlineProfileRS implements Serializable
{
    private MsgDocumentType document;
    private int choiceSelect = -1;
    private static final int SEQUENCE_CHOICE = 0;
    private static final int ERRORS_CHOICE = 1;
    private Sequence sequence;
    private ErrorsType errors;
    private IATAPayloadStdAttributes IATAPayloadStdAttributes;

    /** 
     * Get the 'Document' element value.
     * 
     * @return value
     */
    public MsgDocumentType getDocument() {
        return document;
    }

    /** 
     * Set the 'Document' element value.
     * 
     * @param document
     */
    public void setDocument(MsgDocumentType document) {
        this.document = document;
    }

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if Sequence is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifSequence() {
        return choiceSelect == SEQUENCE_CHOICE;
    }

    /** 
     * Get the sequence value.
     * 
     * @return value
     */
    public Sequence getSequence() {
        return sequence;
    }

    /** 
     * Set the sequence value.
     * 
     * @param sequence
     */
    public void setSequence(Sequence sequence) {
        setChoiceSelect(SEQUENCE_CHOICE);
        this.sequence = sequence;
    }

    /** 
     * Check if Errors is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifErrors() {
        return choiceSelect == ERRORS_CHOICE;
    }

    /** 
     * Get the 'Errors' element value.
     * 
     * @return value
     */
    public ErrorsType getErrors() {
        return errors;
    }

    /** 
     * Set the 'Errors' element value.
     * 
     * @param errors
     */
    public void setErrors(ErrorsType errors) {
        setChoiceSelect(ERRORS_CHOICE);
        this.errors = errors;
    }

    /** 
     * Get the 'IATA_PayloadStdAttributes' attributeGroup value.
     * 
     * @return value
     */
    public IATAPayloadStdAttributes getIATAPayloadStdAttributes() {
        return IATAPayloadStdAttributes;
    }

    /** 
     * Set the 'IATA_PayloadStdAttributes' attributeGroup value.
     * 
     * @param IATAPayloadStdAttributes
     */
    public void setIATAPayloadStdAttributes(
            IATAPayloadStdAttributes IATAPayloadStdAttributes) {
        this.IATAPayloadStdAttributes = IATAPayloadStdAttributes;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:sequence xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema">
     *   &lt;xs:element type="ns:WarningsType" name="Warnings" minOccurs="0"/>
     *   &lt;xs:element type="ns:SuccessType" name="Success"/>
     *   &lt;xs:element name="Profiles">
     *     &lt;xs:complexType>
     *       &lt;xs:sequence>
     *         &lt;xs:element name="Profile" maxOccurs="unbounded">
     *           &lt;!-- Reference to inner class Profile -->
     *         &lt;/xs:element>
     *       &lt;/xs:sequence>
     *     &lt;/xs:complexType>
     *   &lt;/xs:element>
     *   &lt;xs:element name="SupportedMessageInfo" minOccurs="0" maxOccurs="unbounded">
     *     &lt;!-- Reference to inner class SupportedMessageInfo -->
     *   &lt;/xs:element>
     * &lt;/xs:sequence>
     * </pre>
     */
    public static class Sequence implements Serializable
    {
        private WarningsType warnings;
        private SuccessType success;
        private List<Profile> profileList = new ArrayList<Profile>();
        private List<SupportedMessageInfo> supportedMessageInfoList = new ArrayList<SupportedMessageInfo>();

        /** 
         * Get the 'Warnings' element value. Used in conjunction with the Success element to define one or more business errors.
         * 
         * @return value
         */
        public WarningsType getWarnings() {
            return warnings;
        }

        /** 
         * Set the 'Warnings' element value. Used in conjunction with the Success element to define one or more business errors.
         * 
         * @param warnings
         */
        public void setWarnings(WarningsType warnings) {
            this.warnings = warnings;
        }

        /** 
         * Get the 'Success' element value. The presence of the empty Success element explicitly indicates that the message succeeded.
         * 
         * @return value
         */
        public SuccessType getSuccess() {
            return success;
        }

        /** 
         * Set the 'Success' element value. The presence of the empty Success element explicitly indicates that the message succeeded.
         * 
         * @param success
         */
        public void setSuccess(SuccessType success) {
            this.success = success;
        }

        /** 
         * Get the list of 'Profile' element items.
         * 
         * @return list
         */
        public List<Profile> getProfileList() {
            return profileList;
        }

        /** 
         * Set the list of 'Profile' element items.
         * 
         * @param list
         */
        public void setProfileList(List<Profile> list) {
            profileList = list;
        }

        /** 
         * Get the list of 'SupportedMessageInfo' element items.
         * 
         * @return list
         */
        public List<SupportedMessageInfo> getSupportedMessageInfoList() {
            return supportedMessageInfoList;
        }

        /** 
         * Set the list of 'SupportedMessageInfo' element items.
         * 
         * @param list
         */
        public void setSupportedMessageInfoList(List<SupportedMessageInfo> list) {
            supportedMessageInfoList = list;
        }
        /** 
         * Query result.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Profile" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="xs:string" name="RecordCount" minOccurs="0"/>
         *       &lt;xs:element type="xs:string" name="ProfileOwner"/>
         *       &lt;xs:element name="SourceFiles">
         *         &lt;xs:complexType>
         *           &lt;xs:sequence>
         *             &lt;xs:element name="SourceFile" maxOccurs="unbounded">
         *               &lt;!-- Reference to inner class SourceFile -->
         *             &lt;/xs:element>
         *           &lt;/xs:sequence>
         *         &lt;/xs:complexType>
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Profile implements Serializable
        {
            private String recordCount;
            private String profileOwner;
            private List<SourceFile> sourceFileList = new ArrayList<SourceFile>();

            /** 
             * Get the 'RecordCount' element value. The number of decompressed records contained in this file.
             * 
             * @return value
             */
            public String getRecordCount() {
                return recordCount;
            }

            /** 
             * Set the 'RecordCount' element value. The number of decompressed records contained in this file.
             * 
             * @param recordCount
             */
            public void setRecordCount(String recordCount) {
                this.recordCount = recordCount;
            }

            /** 
             * Get the 'ProfileOwner' element value. Profile owner (Airline).          The standard industry alphanumeric code for the airline.  
             * 
             * @return value
             */
            public String getProfileOwner() {
                return profileOwner;
            }

            /** 
             * Set the 'ProfileOwner' element value. Profile owner (Airline).          The standard industry alphanumeric code for the airline.  
             * 
             * @param profileOwner
             */
            public void setProfileOwner(String profileOwner) {
                this.profileOwner = profileOwner;
            }

            /** 
             * Get the list of 'SourceFile' element items. Airline Profile Data elements or Link
             * 
             * @return list
             */
            public List<SourceFile> getSourceFileList() {
                return sourceFileList;
            }

            /** 
             * Set the list of 'SourceFile' element items. Airline Profile Data elements or Link
             * 
             * @param list
             */
            public void setSourceFileList(List<SourceFile> list) {
                sourceFileList = list;
            }
            /** 
             * Airline Profile Data elements or Link
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SourceFile" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:choice>
             *       &lt;xs:element type="xs:string" name="MediaLink"/>
             *       &lt;xs:element name="DataItems">
             *         &lt;!-- Reference to inner class DataItems -->
             *       &lt;/xs:element>
             *     &lt;/xs:choice>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class SourceFile implements Serializable
            {
                private int sourceFileListSelect = -1;
                private static final int MEDIA_LINK_CHOICE = 0;
                private static final int DATA_ITEMS_CHOICE = 1;
                private String mediaLink;
                private DataItems dataItems;

                private void setSourceFileListSelect(int choice) {
                    if (sourceFileListSelect == -1) {
                        sourceFileListSelect = choice;
                    } else if (sourceFileListSelect != choice) {
                        throw new IllegalStateException(
                                "Need to call clearSourceFileListSelect() before changing existing choice");
                    }
                }

                /** 
                 * Clear the choice selection.
                 */
                public void clearSourceFileListSelect() {
                    sourceFileListSelect = -1;
                }

                /** 
                 * Check if MediaLink is current selection for choice.
                 * 
                 * @return <code>true</code> if selection, <code>false</code> if not
                 */
                public boolean ifMediaLink() {
                    return sourceFileListSelect == MEDIA_LINK_CHOICE;
                }

                /** 
                 * Get the 'MediaLink' element value. Link to Airline Profile Source File. Alows large AP file to be distributed over FTP, FTPS, ... as agreed bilaterally with Profile Owner
                 * 
                 * @return value
                 */
                public String getMediaLink() {
                    return mediaLink;
                }

                /** 
                 * Set the 'MediaLink' element value. Link to Airline Profile Source File. Alows large AP file to be distributed over FTP, FTPS, ... as agreed bilaterally with Profile Owner
                 * 
                 * @param mediaLink
                 */
                public void setMediaLink(String mediaLink) {
                    setSourceFileListSelect(MEDIA_LINK_CHOICE);
                    this.mediaLink = mediaLink;
                }

                /** 
                 * Check if DataItems is current selection for choice.
                 * 
                 * @return <code>true</code> if selection, <code>false</code> if not
                 */
                public boolean ifDataItems() {
                    return sourceFileListSelect == DATA_ITEMS_CHOICE;
                }

                /** 
                 * Get the 'DataItems' element value.
                 * 
                 * @return value
                 */
                public DataItems getDataItems() {
                    return dataItems;
                }

                /** 
                 * Set the 'DataItems' element value.
                 * 
                 * @param dataItems
                 */
                public void setDataItems(DataItems dataItems) {
                    setSourceFileListSelect(DATA_ITEMS_CHOICE);
                    this.dataItems = dataItems;
                }
                /** 
                 * Actual Data Elements of the Profile
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DataItems">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element type="ns:GeographicSpecificationType" name="POSGeoSpecification" minOccurs="0" maxOccurs="unbounded"/>
                 *       &lt;xs:element type="ns:NonGeographicSpecificationType" name="POSNonGeoSpecification" minOccurs="0" maxOccurs="unbounded"/>
                 *       &lt;xs:element type="ns:OfferGeographicSpecificationType" name="OfferGeoSpecification" minOccurs="0" maxOccurs="unbounded"/>
                 *       &lt;xs:element name="OfferedService" minOccurs="0" maxOccurs="4">
                 *         &lt;!-- Reference to inner class OfferedService -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:anySimpleType" use="required" name="ActionType"/>
                 *     &lt;xs:attribute type="xs:long" use="required" name="SequenceNumber"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class DataItems implements Serializable
                {
                    private List<GeographicSpecificationType> POSGeoSpecificationList = new ArrayList<GeographicSpecificationType>();
                    private List<NonGeographicSpecificationType> POSNonGeoSpecificationList = new ArrayList<NonGeographicSpecificationType>();
                    private List<OfferGeographicSpecificationType> offerGeoSpecificationList = new ArrayList<OfferGeographicSpecificationType>();
                    private List<OfferedService> offeredServiceList = new ArrayList<OfferedService>();
                    private String actionType;
                    private long sequenceNumber;

                    /** 
                     * Get the list of 'POSGeoSpecification' element items. Point of sale Geographic Specification information.
                     * 
                     * @return list
                     */
                    public List<GeographicSpecificationType> getPOSGeoSpecificationList() {
                        return POSGeoSpecificationList;
                    }

                    /** 
                     * Set the list of 'POSGeoSpecification' element items. Point of sale Geographic Specification information.
                     * 
                     * @param list
                     */
                    public void setPOSGeoSpecificationList(
                            List<GeographicSpecificationType> list) {
                        POSGeoSpecificationList = list;
                    }

                    /** 
                     * Get the list of 'POSNonGeoSpecification' element items. Point of sale Non Geographic Specification information.
                     * 
                     * @return list
                     */
                    public List<NonGeographicSpecificationType> getPOSNonGeoSpecificationList() {
                        return POSNonGeoSpecificationList;
                    }

                    /** 
                     * Set the list of 'POSNonGeoSpecification' element items. Point of sale Non Geographic Specification information.
                     * 
                     * @param list
                     */
                    public void setPOSNonGeoSpecificationList(
                            List<NonGeographicSpecificationType> list) {
                        POSNonGeoSpecificationList = list;
                    }

                    /** 
                     * Get the list of 'OfferGeoSpecification' element items. Offer Geographic Specification
                     * 
                     * @return list
                     */
                    public List<OfferGeographicSpecificationType> getOfferGeoSpecificationList() {
                        return offerGeoSpecificationList;
                    }

                    /** 
                     * Set the list of 'OfferGeoSpecification' element items. Offer Geographic Specification
                     * 
                     * @param list
                     */
                    public void setOfferGeoSpecificationList(
                            List<OfferGeographicSpecificationType> list) {
                        offerGeoSpecificationList = list;
                    }

                    /** 
                     * Get the list of 'OfferedService' element items.
                     * 
                     * @return list
                     */
                    public List<OfferedService> getOfferedServiceList() {
                        return offeredServiceList;
                    }

                    /** 
                     * Set the list of 'OfferedService' element items.
                     * 
                     * @param list
                     */
                    public void setOfferedServiceList(List<OfferedService> list) {
                        offeredServiceList = list;
                    }

                    /** 
                     * Get the 'ActionType' attribute value. Add, Delete, Or Change
                     * 
                     * @return value
                     */
                    public String getActionType() {
                        return actionType;
                    }

                    /** 
                     * Set the 'ActionType' attribute value. Add, Delete, Or Change
                     * 
                     * @param actionType
                     */
                    public void setActionType(String actionType) {
                        this.actionType = actionType;
                    }

                    /** 
                     * Get the 'SequenceNumber' attribute value. Global sequence number of this record in the Airline profile.
                     * 
                     * @return value
                     */
                    public long getSequenceNumber() {
                        return sequenceNumber;
                    }

                    /** 
                     * Set the 'SequenceNumber' attribute value. Global sequence number of this record in the Airline profile.
                     * 
                     * @param sequenceNumber
                     */
                    public void setSequenceNumber(long sequenceNumber) {
                        this.sequenceNumber = sequenceNumber;
                    }
                    /** 
                     * Offered Service.      Example:                         1. Transportation               2. Baggage                      3. Seats                           4. Other     
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OfferedService" minOccurs="0" maxOccurs="4">
                     *   &lt;xs:complexType>
                     *     &lt;xs:simpleContent>
                     *       &lt;xs:extension base="ns:OfferedServiceType">
                     *         &lt;xs:attribute type="xs:anySimpleType" name="Permitted"/>
                     *       &lt;/xs:extension>
                     *     &lt;/xs:simpleContent>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class OfferedService implements Serializable
                    {
                        private OfferedServiceType offeredServiceType;
                        private String permitted;

                        /** 
                         * Get the extension value.
                         * 
                         * @return value
                         */
                        public OfferedServiceType getOfferedServiceType() {
                            return offeredServiceType;
                        }

                        /** 
                         * Set the extension value.
                         * 
                         * @param offeredServiceType
                         */
                        public void setOfferedServiceType(
                                OfferedServiceType offeredServiceType) {
                            this.offeredServiceType = offeredServiceType;
                        }

                        /** 
                         * Get the 'Permitted' attribute value. Specify whether the service is offered. Example: True
                         * 
                         * @return value
                         */
                        public String getPermitted() {
                            return permitted;
                        }

                        /** 
                         * Set the 'Permitted' attribute value. Specify whether the service is offered. Example: True
                         * 
                         * @param permitted
                         */
                        public void setPermitted(String permitted) {
                            this.permitted = permitted;
                        }
                    }
                }
            }
        }
        /** 
         * List of supported messages and respective versions.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SupportedMessageInfo" minOccurs="0" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="xs:string" name="Name"/>
         *       &lt;xs:element name="Version" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class Version -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class SupportedMessageInfo implements Serializable
        {
            private String name;
            private List<Version> versionList = new ArrayList<Version>();

            /** 
             * Get the 'Name' element value. Name of NDC Message.
             * 
             * @return value
             */
            public String getName() {
                return name;
            }

            /** 
             * Set the 'Name' element value. Name of NDC Message.
             * 
             * @param name
             */
            public void setName(String name) {
                this.name = name;
            }

            /** 
             * Get the list of 'Version' element items.
             * 
             * @return list
             */
            public List<Version> getVersionList() {
                return versionList;
            }

            /** 
             * Set the list of 'Version' element items.
             * 
             * @param list
             */
            public void setVersionList(List<Version> list) {
                versionList = list;
            }
            /** 
             * Version of NDC Message.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Version" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="xs:string" name="SupportedElementPath" minOccurs="0" maxOccurs="unbounded"/>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Version implements Serializable
            {
                private List<String> supportedElementPathList = new ArrayList<String>();

                /** 
                 * Get the list of 'SupportedElementPath' element items. X-Path to supported elements and/or attributes with a specific message of a specific version.
                 * 
                 * @return list
                 */
                public List<String> getSupportedElementPathList() {
                    return supportedElementPathList;
                }

                /** 
                 * Set the list of 'SupportedElementPath' element items. X-Path to supported elements and/or attributes with a specific message of a specific version.
                 * 
                 * @param list
                 */
                public void setSupportedElementPathList(List<String> list) {
                    supportedElementPathList = list;
                }
            }
        }
    }
}
