
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;

/** 
 * PROCESSING ALERT definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AlertType">
 *   &lt;xs:choice>
 *     &lt;xs:element ref="ns:InventoryDiscrepancyAlert"/>
 *     &lt;xs:element ref="ns:PIN_AuthenticationAlert"/>
 *     &lt;xs:element ref="ns:SecurePaymentAlert"/>
 *   &lt;/xs:choice>
 * &lt;/xs:complexType>
 * </pre>
 */
public class AlertType implements Serializable
{
    private int choiceSelect = -1;
    private static final int INVENTORY_DISCREPANCY_ALERT_CHOICE = 0;
    private static final int PIN_AUTHENTICATION_ALERT_CHOICE = 1;
    private static final int SECURE_PAYMENT_ALERT_CHOICE = 2;
    private InvDiscrepencyAlertType inventoryDiscrepancyAlert;
    private PINAuthTravelerType PINAuthenticationAlert;
    private SecurePaymentAlertType securePaymentAlert;

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if InventoryDiscrepancyAlert is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifInventoryDiscrepancyAlert() {
        return choiceSelect == INVENTORY_DISCREPANCY_ALERT_CHOICE;
    }

    /** 
     * Get the 'InventoryDiscrepancyAlert' element value.
     * 
     * @return value
     */
    public InvDiscrepencyAlertType getInventoryDiscrepancyAlert() {
        return inventoryDiscrepancyAlert;
    }

    /** 
     * Set the 'InventoryDiscrepancyAlert' element value.
     * 
     * @param inventoryDiscrepancyAlert
     */
    public void setInventoryDiscrepancyAlert(
            InvDiscrepencyAlertType inventoryDiscrepancyAlert) {
        setChoiceSelect(INVENTORY_DISCREPANCY_ALERT_CHOICE);
        this.inventoryDiscrepancyAlert = inventoryDiscrepancyAlert;
    }

    /** 
     * Check if PINAuthenticationAlert is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifPINAuthenticationAlert() {
        return choiceSelect == PIN_AUTHENTICATION_ALERT_CHOICE;
    }

    /** 
     * Get the 'PIN_AuthenticationAlert' element value.
     * 
     * @return value
     */
    public PINAuthTravelerType getPINAuthenticationAlert() {
        return PINAuthenticationAlert;
    }

    /** 
     * Set the 'PIN_AuthenticationAlert' element value.
     * 
     * @param PINAuthenticationAlert
     */
    public void setPINAuthenticationAlert(
            PINAuthTravelerType PINAuthenticationAlert) {
        setChoiceSelect(PIN_AUTHENTICATION_ALERT_CHOICE);
        this.PINAuthenticationAlert = PINAuthenticationAlert;
    }

    /** 
     * Check if SecurePaymentAlert is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifSecurePaymentAlert() {
        return choiceSelect == SECURE_PAYMENT_ALERT_CHOICE;
    }

    /** 
     * Get the 'SecurePaymentAlert' element value.
     * 
     * @return value
     */
    public SecurePaymentAlertType getSecurePaymentAlert() {
        return securePaymentAlert;
    }

    /** 
     * Set the 'SecurePaymentAlert' element value.
     * 
     * @param securePaymentAlert
     */
    public void setSecurePaymentAlert(SecurePaymentAlertType securePaymentAlert) {
        setChoiceSelect(SECURE_PAYMENT_ALERT_CHOICE);
        this.securePaymentAlert = securePaymentAlert;
    }
}
