
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * AIRLINE ALLIANCE PROGRAM Preferences.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AlliancePreferencesType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="Alliance" maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class Alliance -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 *   &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class AlliancePreferencesType implements Serializable
{
    private List<Alliance> allianceList = new ArrayList<Alliance>();
    private String refs;

    /** 
     * Get the list of 'Alliance' element items.
     * 
     * @return list
     */
    public List<Alliance> getAllianceList() {
        return allianceList;
    }

    /** 
     * Set the list of 'Alliance' element items.
     * 
     * @param list
     */
    public void setAllianceList(List<Alliance> list) {
        allianceList = list;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getRefs() {
        return refs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param refs
     */
    public void setRefs(String refs) {
        this.refs = refs;
    }
    /** 
     * Used to specify the alliance CodeSet. Refer to IATA PADIS Code List for data element 9906.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Alliance" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:complexContent>
     *       &lt;xs:extension base="ns:CodesetType">
     *         &lt;xs:sequence>
     *           &lt;xs:element type="xs:string" name="GeoIndicatorType" minOccurs="0"/>
     *           &lt;xs:element type="xs:string" name="FlightHaulLength" minOccurs="0"/>
     *         &lt;/xs:sequence>
     *         &lt;xs:attributeGroup ref="ns:PreferenceAttrGroup"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:complexContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Alliance extends CodesetType implements Serializable
    {
        private String geoIndicatorType;
        private String flightHaulLength;
        private PreferenceAttrGroup preferenceAttrGroup;

        /** 
         * Get the 'GeoIndicatorType' element value. Geographical indicator type.  Example: DOM (DOMESTIC/ DOMESTIC)

        Encoding Scheme: IATA Padis Codeset - List for data element 9970 (Product Details Qualifier)
         * 
         * @return value
         */
        public String getGeoIndicatorType() {
            return geoIndicatorType;
        }

        /** 
         * Set the 'GeoIndicatorType' element value. Geographical indicator type.  Example: DOM (DOMESTIC/ DOMESTIC)

        Encoding Scheme: IATA Padis Codeset - List for data element 9970 (Product Details Qualifier)
         * 
         * @param geoIndicatorType
         */
        public void setGeoIndicatorType(String geoIndicatorType) {
            this.geoIndicatorType = geoIndicatorType;
        }

        /** 
         * Get the 'FlightHaulLength' element value. Flight haul length type.  Example: LH (LONG-HAUL 6 HRS PLUS)

        Encoding Scheme: IATA Padis Codeset - List for data element FHT (Flight Haul Type)
         * 
         * @return value
         */
        public String getFlightHaulLength() {
            return flightHaulLength;
        }

        /** 
         * Set the 'FlightHaulLength' element value. Flight haul length type.  Example: LH (LONG-HAUL 6 HRS PLUS)

        Encoding Scheme: IATA Padis Codeset - List for data element FHT (Flight Haul Type)
         * 
         * @param flightHaulLength
         */
        public void setFlightHaulLength(String flightHaulLength) {
            this.flightHaulLength = flightHaulLength;
        }

        /** 
         * Get the 'PreferenceAttrGroup' attributeGroup value.
         * 
         * @return value
         */
        public PreferenceAttrGroup getPreferenceAttrGroup() {
            return preferenceAttrGroup;
        }

        /** 
         * Set the 'PreferenceAttrGroup' attributeGroup value.
         * 
         * @param preferenceAttrGroup
         */
        public void setPreferenceAttrGroup(
                PreferenceAttrGroup preferenceAttrGroup) {
            this.preferenceAttrGroup = preferenceAttrGroup;
        }
    }
}
