
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AllianceType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="Name" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="Code" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="URL" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:AirlineTypeAIDM" name="Airline" minOccurs="0" maxOccurs="unbounded"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class AllianceType implements Serializable
{
    private String name;
    private String code;
    private String URL;
    private List<AirlineTypeAIDM> airlineList = new ArrayList<AirlineTypeAIDM>();

    /** 
     * Get the 'Name' element value. Two or more airlines participating in a commercial relationship or joint venture, where a joint and commonly identifiable product is marketed under a single commercial name or brand.
     * 
     * @return value
     */
    public String getName() {
        return name;
    }

    /** 
     * Set the 'Name' element value. Two or more airlines participating in a commercial relationship or joint venture, where a joint and commonly identifiable product is marketed under a single commercial name or brand.
     * 
     * @param name
     */
    public void setName(String name) {
        this.name = name;
    }

    /** 
     * Get the 'Code' element value. Used to specify the alliance based on PADIS Code List (code list defined in BDT).
     * 
     * @return value
     */
    public String getCode() {
        return code;
    }

    /** 
     * Set the 'Code' element value. Used to specify the alliance based on PADIS Code List (code list defined in BDT).
     * 
     * @param code
     */
    public void setCode(String code) {
        this.code = code;
    }

    /** 
     * Get the 'URL' element value. Alliance information URL.
    Example: http://www.oneworld.com/home
     * 
     * @return value
     */
    public String getURL() {
        return URL;
    }

    /** 
     * Set the 'URL' element value. Alliance information URL.
    Example: http://www.oneworld.com/home
     * 
     * @param URL
     */
    public void setURL(String URL) {
        this.URL = URL;
    }

    /** 
     * Get the list of 'Airline' element items. An enterprise operating aircraft for commercial purposes
     * 
     * @return list
     */
    public List<AirlineTypeAIDM> getAirlineList() {
        return airlineList;
    }

    /** 
     * Set the list of 'Airline' element items. An enterprise operating aircraft for commercial purposes
     * 
     * @param list
     */
    public void setAirlineList(List<AirlineTypeAIDM> list) {
        airlineList = list;
    }
}
