
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;

/** 
 * A data type definition for Augmentation Point  List.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AugPointListType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:ListBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:element name="List" maxOccurs="unbounded">
 *           &lt;!-- Reference to inner class List -->
 *         &lt;/xs:element>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class AugPointListType extends ListBaseType implements Serializable
{
    private java.util.List<List> listList = new ArrayList<List>();

    /** 
     * Get the list of 'List' element items.
     * 
     * @return list
     */
    public java.util.List<List> getListList() {
        return listList;
    }

    /** 
     * Set the list of 'List' element items.
     * 
     * @param list
     */
    public void setListList(java.util.List<List> list) {
        listList = list;
    }
    /** 
     * Augmentation Point List detail.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="List" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="AugPointAssoc" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class AugPointAssoc -->
     *       &lt;/xs:element>
     *       &lt;xs:element type="ns:NamedAssocType" name="NamedAssocs" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:string" use="optional" name="ListKey"/>
     *     &lt;xs:attribute type="xs:string" use="optional" name="ListName"/>
     *     &lt;xs:attribute type="xs:string" use="optional" name="Owner"/>
     *     &lt;xs:attribute type="xs:integer" use="optional" name="Seq"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class List implements Serializable
    {
        private java.util.List<AugPointAssoc> augPointAssocList = new ArrayList<AugPointAssoc>();
        private NamedAssocType namedAssocs;
        private String listKey;
        private String listName;
        private String owner;
        private BigInteger seq;

        /** 
         * Get the list of 'AugPointAssoc' element items.
         * 
         * @return list
         */
        public java.util.List<AugPointAssoc> getAugPointAssocList() {
            return augPointAssocList;
        }

        /** 
         * Set the list of 'AugPointAssoc' element items.
         * 
         * @param list
         */
        public void setAugPointAssocList(java.util.List<AugPointAssoc> list) {
            augPointAssocList = list;
        }

        /** 
         * Get the 'NamedAssocs' element value. Augmentation Point List Named Association(s).

        Note: This capability supports implementer-specified, or "Named", reference associations to other (target) instantiated objects with @Key, @GroupKey, @GroupTokenKey, @ListKey and @ListTokenKey attributes.
         * 
         * @return value
         */
        public NamedAssocType getNamedAssocs() {
            return namedAssocs;
        }

        /** 
         * Set the 'NamedAssocs' element value. Augmentation Point List Named Association(s).

        Note: This capability supports implementer-specified, or "Named", reference associations to other (target) instantiated objects with @Key, @GroupKey, @GroupTokenKey, @ListKey and @ListTokenKey attributes.
         * 
         * @param namedAssocs
         */
        public void setNamedAssocs(NamedAssocType namedAssocs) {
            this.namedAssocs = namedAssocs;
        }

        /** 
         * Get the 'ListKey' attribute value. Globally Unique Group instance/ class Key.

        Example: {CA2016A0-0AE1-4E65-8EA6-0A16AE906596}
         * 
         * @return value
         */
        public String getListKey() {
            return listKey;
        }

        /** 
         * Set the 'ListKey' attribute value. Globally Unique Group instance/ class Key.

        Example: {CA2016A0-0AE1-4E65-8EA6-0A16AE906596}
         * 
         * @param listKey
         */
        public void setListKey(String listKey) {
            this.listKey = listKey;
        }

        /** 
         * Get the 'ListName' attribute value. List Name. Example: MyList
         * 
         * @return value
         */
        public String getListName() {
            return listName;
        }

        /** 
         * Set the 'ListName' attribute value. List Name. Example: MyList
         * 
         * @param listName
         */
        public void setListName(String listName) {
            this.listName = listName;
        }

        /** 
         * Get the 'Owner' attribute value. Source Entity Code or ID. Examples: BA, WIDGETCO
         * 
         * @return value
         */
        public String getOwner() {
            return owner;
        }

        /** 
         * Set the 'Owner' attribute value. Source Entity Code or ID. Examples: BA, WIDGETCO
         * 
         * @param owner
         */
        public void setOwner(String owner) {
            this.owner = owner;
        }

        /** 
         * Get the 'Seq' attribute value. Sequence ID. Example: 1
         * 
         * @return value
         */
        public BigInteger getSeq() {
            return seq;
        }

        /** 
         * Set the 'Seq' attribute value. Sequence ID. Example: 1
         * 
         * @param seq
         */
        public void setSeq(BigInteger seq) {
            this.seq = seq;
        }
        /** 
         * Associated Augmentation Point(s).
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AugPointAssoc" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" use="required" name="KeyRef"/>
         *     &lt;xs:attribute type="xs:string" use="optional" name="Owner"/>
         *     &lt;xs:attribute type="xs:integer" use="optional" name="Seq"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class AugPointAssoc implements Serializable
        {
            private String keyRef;
            private String owner;
            private BigInteger seq;

            /** 
             * Get the 'KeyRef' attribute value. Reference to globally unique AUGMENTATION POINT instance/ class Key.

            Example: 2B75C565-5BB0- 4DCE-8DE6-67CB7B4F25A7
             * 
             * @return value
             */
            public String getKeyRef() {
                return keyRef;
            }

            /** 
             * Set the 'KeyRef' attribute value. Reference to globally unique AUGMENTATION POINT instance/ class Key.

            Example: 2B75C565-5BB0- 4DCE-8DE6-67CB7B4F25A7
             * 
             * @param keyRef
             */
            public void setKeyRef(String keyRef) {
                this.keyRef = keyRef;
            }

            /** 
             * Get the 'Owner' attribute value. Source Entity Code or ID. Examples: BA, WIDGETCO
             * 
             * @return value
             */
            public String getOwner() {
                return owner;
            }

            /** 
             * Set the 'Owner' attribute value. Source Entity Code or ID. Examples: BA, WIDGETCO
             * 
             * @param owner
             */
            public void setOwner(String owner) {
                this.owner = owner;
            }

            /** 
             * Get the 'Seq' attribute value. Sequence ID. Example: 1
             * 
             * @return value
             */
            public BigInteger getSeq() {
                return seq;
            }

            /** 
             * Set the 'Seq' attribute value. Sequence ID. Example: 1
             * 
             * @param seq
             */
            public void setSeq(BigInteger seq) {
                this.seq = seq;
            }
        }
    }
}
