
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

/** 
 * A data type definition for Augmentation Point.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AugPointType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="OtherServiceInformation" minOccurs="0">
 *       &lt;!-- Reference to inner class OtherServiceInformation -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="SpecialServiceRequest" minOccurs="0">
 *       &lt;!-- Reference to inner class SpecialServiceRequest -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="optional" name="Key"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="Owner"/>
 *   &lt;xs:attribute type="xs:integer" use="optional" name="Seq"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class AugPointType implements Serializable
{
    private OtherServiceInformation otherServiceInformation;
    private SpecialServiceRequest specialServiceRequest;
    private String key;
    private String owner;
    private BigInteger seq;

    /** 
     * Get the 'OtherServiceInformation' element value.
     * 
     * @return value
     */
    public OtherServiceInformation getOtherServiceInformation() {
        return otherServiceInformation;
    }

    /** 
     * Set the 'OtherServiceInformation' element value.
     * 
     * @param otherServiceInformation
     */
    public void setOtherServiceInformation(
            OtherServiceInformation otherServiceInformation) {
        this.otherServiceInformation = otherServiceInformation;
    }

    /** 
     * Get the 'SpecialServiceRequest' element value.
     * 
     * @return value
     */
    public SpecialServiceRequest getSpecialServiceRequest() {
        return specialServiceRequest;
    }

    /** 
     * Set the 'SpecialServiceRequest' element value.
     * 
     * @param specialServiceRequest
     */
    public void setSpecialServiceRequest(
            SpecialServiceRequest specialServiceRequest) {
        this.specialServiceRequest = specialServiceRequest;
    }

    /** 
     * Get the 'Key' attribute value. Globally Unique Object instance/ class Key.

    Example: 2B75C565-5BB0- 4DCE-8DE6-67CB7B4F25A7
     * 
     * @return value
     */
    public String getKey() {
        return key;
    }

    /** 
     * Set the 'Key' attribute value. Globally Unique Object instance/ class Key.

    Example: 2B75C565-5BB0- 4DCE-8DE6-67CB7B4F25A7
     * 
     * @param key
     */
    public void setKey(String key) {
        this.key = key;
    }

    /** 
     * Get the 'Owner' attribute value. Source Entity Code or ID. Examples: BA, WIDGETCO
     * 
     * @return value
     */
    public String getOwner() {
        return owner;
    }

    /** 
     * Set the 'Owner' attribute value. Source Entity Code or ID. Examples: BA, WIDGETCO
     * 
     * @param owner
     */
    public void setOwner(String owner) {
        this.owner = owner;
    }

    /** 
     * Get the 'Seq' attribute value. Sequence ID. Example: 1
     * 
     * @return value
     */
    public BigInteger getSeq() {
        return seq;
    }

    /** 
     * Set the 'Seq' attribute value. Sequence ID. Example: 1
     * 
     * @param seq
     */
    public void setSeq(BigInteger seq) {
        this.seq = seq;
    }
    /** 
     * Other service information group.  If TravelerAssociationNumber is not included, then OSI applies to all travelers.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OtherServiceInformation" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="TravelerIDRef" minOccurs="0" maxOccurs="unbounded"/>
     *       &lt;xs:element type="xs:string" name="AirlineCode" minOccurs="0"/>
     *       &lt;xs:element type="xs:string" name="OSICode" minOccurs="0"/>
     *       &lt;xs:element type="xs:string" name="Text"/>
     *       &lt;xs:element type="xs:string" name="ActionCode" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class OtherServiceInformation implements Serializable
    {
        private List<String> travelerIDRefList = new ArrayList<String>();
        private String airlineCode;
        private String OSICode;
        private String text;
        private String actionCode;

        /** 
         * Get the list of 'TravelerIDRef' element items. Unique association ID reference of the traveler associated to this item. No comma separated lists and no ranges allowed.        Example: T1
         * 
         * @return list
         */
        public List<String> getTravelerIDRefList() {
            return travelerIDRefList;
        }

        /** 
         * Set the list of 'TravelerIDRef' element items. Unique association ID reference of the traveler associated to this item. No comma separated lists and no ranges allowed.        Example: T1
         * 
         * @param list
         */
        public void setTravelerIDRefList(List<String> list) {
            travelerIDRefList = list;
        }

        /** 
         * Get the 'AirlineCode' element value. Airline code.  Example: AA
         * 
         * @return value
         */
        public String getAirlineCode() {
            return airlineCode;
        }

        /** 
         * Set the 'AirlineCode' element value. Airline code.  Example: AA
         * 
         * @param airlineCode
         */
        public void setAirlineCode(String airlineCode) {
            this.airlineCode = airlineCode;
        }

        /** 
         * Get the 'OSICode' element value. Conventional code (AIRIMP code) for other service information. Recommended to use when sending OSI to airline. Example: CTCA
         * 
         * @return value
         */
        public String getOSICode() {
            return OSICode;
        }

        /** 
         * Set the 'OSICode' element value. Conventional code (AIRIMP code) for other service information. Recommended to use when sending OSI to airline. Example: CTCA
         * 
         * @param OSICode
         */
        public void setOSICode(String OSICode) {
            this.OSICode = OSICode;
        }

        /** 
         * Get the 'Text' element value. Information text or error text. Example: Free flow text.  
         * 
         * @return value
         */
        public String getText() {
            return text;
        }

        /** 
         * Set the 'Text' element value. Information text or error text. Example: Free flow text.  
         * 
         * @param text
         */
        public void setText(String text) {
            this.text = text;
        }

        /** 
         * Get the 'ActionCode' element value. Action code.  Example: HK
         * 
         * @return value
         */
        public String getActionCode() {
            return actionCode;
        }

        /** 
         * Set the 'ActionCode' element value. Action code.  Example: HK
         * 
         * @param actionCode
         */
        public void setActionCode(String actionCode) {
            this.actionCode = actionCode;
        }
    }
    /** 
     * Special service request group.  If TravelerAssociationNumber is not included, then SSR applies to all travelers.  Same for SegmentAssociationNumber
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SpecialServiceRequest" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="TravelerIDRef" minOccurs="0" maxOccurs="unbounded"/>
     *       &lt;xs:element type="xs:string" name="SegmentIDRef" minOccurs="0"/>
     *       &lt;xs:element type="xs:string" name="AirlineCode" minOccurs="0"/>
     *       &lt;xs:element type="xs:string" name="SSRCode"/>
     *       &lt;xs:element type="xs:string" name="Text" minOccurs="0"/>
     *       &lt;xs:choice minOccurs="0">
     *         &lt;!-- Reference to inner class Choice -->
     *       &lt;/xs:choice>
     *       &lt;xs:element type="xs:string" name="ActionCode" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class SpecialServiceRequest implements Serializable
    {
        private List<String> travelerIDRefList = new ArrayList<String>();
        private String segmentIDRef;
        private String airlineCode;
        private String SSRCode;
        private String text;
        private Choice choice;
        private String actionCode;

        /** 
         * Get the list of 'TravelerIDRef' element items. Unique association ID reference of the traveler associated to this item. No comma separated lists and no ranges allowed.        Example: T1
         * 
         * @return list
         */
        public List<String> getTravelerIDRefList() {
            return travelerIDRefList;
        }

        /** 
         * Set the list of 'TravelerIDRef' element items. Unique association ID reference of the traveler associated to this item. No comma separated lists and no ranges allowed.        Example: T1
         * 
         * @param list
         */
        public void setTravelerIDRefList(List<String> list) {
            travelerIDRefList = list;
        }

        /** 
         * Get the 'SegmentIDRef' element value. ID reference used to associate this item to a segment. No comma separated lists and no ranges supported. Example: F1
         * 
         * @return value
         */
        public String getSegmentIDRef() {
            return segmentIDRef;
        }

        /** 
         * Set the 'SegmentIDRef' element value. ID reference used to associate this item to a segment. No comma separated lists and no ranges supported. Example: F1
         * 
         * @param segmentIDRef
         */
        public void setSegmentIDRef(String segmentIDRef) {
            this.segmentIDRef = segmentIDRef;
        }

        /** 
         * Get the 'AirlineCode' element value. Airline code.  Example: AA
         * 
         * @return value
         */
        public String getAirlineCode() {
            return airlineCode;
        }

        /** 
         * Set the 'AirlineCode' element value. Airline code.  Example: AA
         * 
         * @param airlineCode
         */
        public void setAirlineCode(String airlineCode) {
            this.airlineCode = airlineCode;
        }

        /** 
         * Get the 'SSRCode' element value. Special service request code.  IATA standard.  Example: VGML
         * 
         * @return value
         */
        public String getSSRCode() {
            return SSRCode;
        }

        /** 
         * Set the 'SSRCode' element value. Special service request code.  IATA standard.  Example: VGML
         * 
         * @param SSRCode
         */
        public void setSSRCode(String SSRCode) {
            this.SSRCode = SSRCode;
        }

        /** 
         * Get the 'Text' element value. Information text or error text. Example: Free flow text.  
         * 
         * @return value
         */
        public String getText() {
            return text;
        }

        /** 
         * Set the 'Text' element value. Information text or error text. Example: Free flow text.  
         * 
         * @param text
         */
        public void setText(String text) {
            this.text = text;
        }

        /** 
         * Get the choice value.
         * 
         * @return value
         */
        public Choice getChoice() {
            return choice;
        }

        /** 
         * Set the choice value.
         * 
         * @param choice
         */
        public void setChoice(Choice choice) {
            this.choice = choice;
        }

        /** 
         * Get the 'ActionCode' element value. Action code.  Example: HK
         * 
         * @return value
         */
        public String getActionCode() {
            return actionCode;
        }

        /** 
         * Set the 'ActionCode' element value. Action code.  Example: HK
         * 
         * @param actionCode
         */
        public void setActionCode(String actionCode) {
            this.actionCode = actionCode;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:choice xmlns:xs="http://www.w3.org/2001/XMLSchema" minOccurs="0">
         *   &lt;xs:element type="xs:integer" name="NumberInParty" minOccurs="0"/>
         *   &lt;xs:element type="xs:integer" name="NumberOfServices" minOccurs="0"/>
         * &lt;/xs:choice>
         * </pre>
         */
        public static class Choice implements Serializable
        {
            private int choiceSelect = -1;
            private static final int NUMBER_IN_PARTY_CHOICE = 0;
            private static final int NUMBER_OF_SERVICES_CHOICE = 1;
            private BigInteger numberInParty;
            private BigInteger numberOfServices;

            private void setChoiceSelect(int choice) {
                if (choiceSelect == -1) {
                    choiceSelect = choice;
                } else if (choiceSelect != choice) {
                    throw new IllegalStateException(
                            "Need to call clearChoiceSelect() before changing existing choice");
                }
            }

            /** 
             * Clear the choice selection.
             */
            public void clearChoiceSelect() {
                choiceSelect = -1;
            }

            /** 
             * Check if NumberInParty is current selection for choice.
             * 
             * @return <code>true</code> if selection, <code>false</code> if not
             */
            public boolean ifNumberInParty() {
                return choiceSelect == NUMBER_IN_PARTY_CHOICE;
            }

            /** 
             * Get the 'NumberInParty' element value. Number of passengers/items.  Example: 1
             * 
             * @return value
             */
            public BigInteger getNumberInParty() {
                return numberInParty;
            }

            /** 
             * Set the 'NumberInParty' element value. Number of passengers/items.  Example: 1
             * 
             * @param numberInParty
             */
            public void setNumberInParty(BigInteger numberInParty) {
                setChoiceSelect(NUMBER_IN_PARTY_CHOICE);
                this.numberInParty = numberInParty;
            }

            /** 
             * Check if NumberOfServices is current selection for choice.
             * 
             * @return <code>true</code> if selection, <code>false</code> if not
             */
            public boolean ifNumberOfServices() {
                return choiceSelect == NUMBER_OF_SERVICES_CHOICE;
            }

            /** 
             * Get the 'NumberOfServices' element value. Number of services provided with this SSR. Primarily appliicable to XBAG, BIKE etc.
             * 
             * @return value
             */
            public BigInteger getNumberOfServices() {
                return numberOfServices;
            }

            /** 
             * Set the 'NumberOfServices' element value. Number of services provided with this SSR. Primarily appliicable to XBAG, BIKE etc.
             * 
             * @param numberOfServices
             */
            public void setNumberOfServices(BigInteger numberOfServices) {
                setChoiceSelect(NUMBER_OF_SERVICES_CHOICE);
                this.numberOfServices = numberOfServices;
            }
        }
    }
}
