
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;
import java.math.BigInteger;

/** 
 * REDEMPTION helper object.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AwardRedemptionType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="Unit">
 *       &lt;xs:complexType>
 *         &lt;xs:simpleContent>
 *           &lt;xs:extension base="xs:string">
 *             &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
 *           &lt;/xs:extension>
 *         &lt;/xs:simpleContent>
 *       &lt;/xs:complexType>
 *     &lt;/xs:element>
 *     &lt;xs:element type="xs:integer" name="Quantity"/>
 *     &lt;xs:element name="Conversion" minOccurs="0">
 *       &lt;!-- Reference to inner class Conversion -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 *   &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class AwardRedemptionType implements Serializable
{
    private String unitString;
    private String unitRefs;
    private BigInteger quantity;
    private Conversion conversion;
    private String refs;

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public String getUnitString() {
        return unitString;
    }

    /** 
     * Set the extension value.
     * 
     * @param unitString
     */
    public void setUnitString(String unitString) {
        this.unitString = unitString;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getUnitRefs() {
        return unitRefs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param unitRefs
     */
    public void setUnitRefs(String unitRefs) {
        this.unitRefs = unitRefs;
    }

    /** 
     * Get the 'Quantity' element value. Value containing the quantity of frequent flyer program redemption units.
     * 
     * @return value
     */
    public BigInteger getQuantity() {
        return quantity;
    }

    /** 
     * Set the 'Quantity' element value. Value containing the quantity of frequent flyer program redemption units.
     * 
     * @param quantity
     */
    public void setQuantity(BigInteger quantity) {
        this.quantity = quantity;
    }

    /** 
     * Get the 'Conversion' element value.
     * 
     * @return value
     */
    public Conversion getConversion() {
        return conversion;
    }

    /** 
     * Set the 'Conversion' element value.
     * 
     * @param conversion
     */
    public void setConversion(Conversion conversion) {
        this.conversion = conversion;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getRefs() {
        return refs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param refs
     */
    public void setRefs(String refs) {
        this.refs = refs;
    }
    /** 
     * Redemption amount/ unit equivalents.
    Unit (Miles, Points) and Quantity (30000). Used on conjunction withNote: A currency value  or conversion ratio may be specified.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Conversion" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="ns:CurrencyAmountOptType" name="Amount"/>
     *       &lt;xs:element type="xs:string" name="Ratio"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Conversion implements Serializable
    {
        private CurrencyAmountOptType amount;
        private String ratio;

        /** 
         * Get the 'Amount' element value. Currency equivalent of redemption amount.  Example: 50000
         * 
         * @return value
         */
        public CurrencyAmountOptType getAmount() {
            return amount;
        }

        /** 
         * Set the 'Amount' element value. Currency equivalent of redemption amount.  Example: 50000
         * 
         * @param amount
         */
        public void setAmount(CurrencyAmountOptType amount) {
            this.amount = amount;
        }

        /** 
         * Get the 'Ratio' element value. Redemption unit to currency ratio.  Example: 2:1 (two redemption units = one currency unit.)
         * 
         * @return value
         */
        public String getRatio() {
            return ratio;
        }

        /** 
         * Set the 'Ratio' element value. Redemption unit to currency ratio.  Example: 2:1 (two redemption units = one currency unit.)
         * 
         * @param ratio
         */
        public void setRatio(String ratio) {
            this.ratio = ratio;
        }
    }
}
