
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/** 
 * A data type for Baggage Allowance by Dimensions.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BagAllowanceDimensionType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="ApplicableParty" minOccurs="0"/>
 *     &lt;xs:element type="ns:SizeUnitSimpleType" name="DimensionUOM"/>
 *     &lt;xs:choice>
 *       &lt;xs:sequence>
 *         &lt;xs:element name="MaxLinear">
 *           &lt;xs:complexType>
 *             &lt;xs:simpleContent>
 *               &lt;xs:extension base="xs:string">
 *                 &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
 *               &lt;/xs:extension>
 *             &lt;/xs:simpleContent>
 *           &lt;/xs:complexType>
 *         &lt;/xs:element>
 *         &lt;xs:element name="MinLinear">
 *           &lt;xs:complexType>
 *             &lt;xs:simpleContent>
 *               &lt;xs:extension base="xs:string">
 *                 &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
 *               &lt;/xs:extension>
 *             &lt;/xs:simpleContent>
 *           &lt;/xs:complexType>
 *         &lt;/xs:element>
 *       &lt;/xs:sequence>
 *       &lt;xs:element name="Dimensions" maxOccurs="unbounded">
 *         &lt;!-- Reference to inner class Dimensions -->
 *       &lt;/xs:element>
 *     &lt;/xs:choice>
 *     &lt;xs:element type="xs:string" name="ApplicableBag" minOccurs="0"/>
 *     &lt;xs:element type="ns:Descriptions" name="Descriptions" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class BagAllowanceDimensionType implements Serializable
{
    private String applicableParty;
    private SizeUnitSimpleType dimensionUOM;
    private int choiceSelect = -1;
    private static final int MAX_LINEAR_CHOICE = 0;
    private static final int DIMENSION_LIST_CHOICE = 1;
    private String maxLinearString;
    private String maxLinearRefs;
    private String minLinearString;
    private String minLinearRefs;
    private List<Dimensions> dimensionList = new ArrayList<Dimensions>();
    private String applicableBag;
    private Descriptions descriptions;
    private String refs;

    /** 
     * Get the 'ApplicableParty' element value. Baggage weight restriction application. Examples: Party, Traveler

    Note: Party applies to all Travelers.
     * 
     * @return value
     */
    public String getApplicableParty() {
        return applicableParty;
    }

    /** 
     * Set the 'ApplicableParty' element value. Baggage weight restriction application. Examples: Party, Traveler

    Note: Party applies to all Travelers.
     * 
     * @param applicableParty
     */
    public void setApplicableParty(String applicableParty) {
        this.applicableParty = applicableParty;
    }

    /** 
     * Get the 'DimensionUOM' element value. Baggage dimension UOM (unit of measure). Example: Centimeter, Inch
     * 
     * @return value
     */
    public SizeUnitSimpleType getDimensionUOM() {
        return dimensionUOM;
    }

    /** 
     * Set the 'DimensionUOM' element value. Baggage dimension UOM (unit of measure). Example: Centimeter, Inch
     * 
     * @param dimensionUOM
     */
    public void setDimensionUOM(SizeUnitSimpleType dimensionUOM) {
        this.dimensionUOM = dimensionUOM;
    }

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if MaxLinear is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifMaxLinear() {
        return choiceSelect == MAX_LINEAR_CHOICE;
    }

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public String getMaxLinearString() {
        return maxLinearString;
    }

    /** 
     * Set the extension value.
     * 
     * @param maxLinearString
     */
    public void setMaxLinearString(String maxLinearString) {
        setChoiceSelect(MAX_LINEAR_CHOICE);
        this.maxLinearString = maxLinearString;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getMaxLinearRefs() {
        return maxLinearRefs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param maxLinearRefs
     */
    public void setMaxLinearRefs(String maxLinearRefs) {
        setChoiceSelect(MAX_LINEAR_CHOICE);
        this.maxLinearRefs = maxLinearRefs;
    }

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public String getMinLinearString() {
        return minLinearString;
    }

    /** 
     * Set the extension value.
     * 
     * @param minLinearString
     */
    public void setMinLinearString(String minLinearString) {
        setChoiceSelect(MAX_LINEAR_CHOICE);
        this.minLinearString = minLinearString;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getMinLinearRefs() {
        return minLinearRefs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param minLinearRefs
     */
    public void setMinLinearRefs(String minLinearRefs) {
        setChoiceSelect(MAX_LINEAR_CHOICE);
        this.minLinearRefs = minLinearRefs;
    }

    /** 
     * Check if DimensionList is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifDimensionList() {
        return choiceSelect == DIMENSION_LIST_CHOICE;
    }

    /** 
     * Get the list of 'Dimensions' element items. A choice between specifying baggage dimensions as:
    - Total linear dimensions
    - Individual length, height and/ or width
     * 
     * @return list
     */
    public List<Dimensions> getDimensionList() {
        return dimensionList;
    }

    /** 
     * Set the list of 'Dimensions' element items. A choice between specifying baggage dimensions as:
    - Total linear dimensions
    - Individual length, height and/ or width
     * 
     * @param list
     */
    public void setDimensionList(List<Dimensions> list) {
        setChoiceSelect(DIMENSION_LIST_CHOICE);
        dimensionList = list;
    }

    /** 
     * Get the 'ApplicableBag' element value. Applicable bag type.
    Examples: Carry-On, 1st Checked Bag, 2nd Checked Bag
     * 
     * @return value
     */
    public String getApplicableBag() {
        return applicableBag;
    }

    /** 
     * Set the 'ApplicableBag' element value. Applicable bag type.
    Examples: Carry-On, 1st Checked Bag, 2nd Checked Bag
     * 
     * @param applicableBag
     */
    public void setApplicableBag(String applicableBag) {
        this.applicableBag = applicableBag;
    }

    /** 
     * Get the 'Descriptions' element value.
     * 
     * @return value
     */
    public Descriptions getDescriptions() {
        return descriptions;
    }

    /** 
     * Set the 'Descriptions' element value.
     * 
     * @param descriptions
     */
    public void setDescriptions(Descriptions descriptions) {
        this.descriptions = descriptions;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getRefs() {
        return refs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param refs
     */
    public void setRefs(String refs) {
        this.refs = refs;
    }
    /** 
     * Maximum baggage dimension category and value.

    Notes: Baggage Size UOM (unit of measure) is specified in BagUOM.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Dimensions" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="Category"/>
     *       &lt;xs:element type="xs:decimal" name="MaxValue"/>
     *       &lt;xs:element name="MinValue" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *     &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * 
     * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
     *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
     * &lt;/xs:attributeGroup>
     * </pre>
     */
    public static class Dimensions implements Serializable
    {
        private String category;
        private BigDecimal maxValue;
        private boolean minValue;
        private String refs;

        /** 
         * Get the 'Category' element value. Baggage dimensions category.
        Examples: Length, Height, Width
         * 
         * @return value
         */
        public String getCategory() {
            return category;
        }

        /** 
         * Set the 'Category' element value. Baggage dimensions category.
        Examples: Length, Height, Width
         * 
         * @param category
         */
        public void setCategory(String category) {
            this.category = category;
        }

        /** 
         * Get the 'MaxValue' element value. Maximum dimension value.  Example: 30
         * 
         * @return value
         */
        public BigDecimal getMaxValue() {
            return maxValue;
        }

        /** 
         * Set the 'MaxValue' element value. Maximum dimension value.  Example: 30
         * 
         * @param maxValue
         */
        public void setMaxValue(BigDecimal maxValue) {
            this.maxValue = maxValue;
        }

        /** 
         * Check if the 'MinValue' element is present.
         * 
         * @return <code>true</code> if present, <code>false</code> if not
         */
        public boolean ifMinValuePresent() {
            return minValue;
        }

        /** 
         * Set flag for 'MinValue' element present.
         * 
         * @param minValue
         */
        public void flagMinValuePresent(boolean minValue) {
            this.minValue = minValue;
        }

        /** 
         * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @return value
         */
        public String getRefs() {
            return refs;
        }

        /** 
         * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @param refs
         */
        public void setRefs(String refs) {
            this.refs = refs;
        }
    }
}
