
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

/** 
 * A data type for Baggage Allowance by Piece.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BagAllowancePieceType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="ApplicableParty"/>
 *     &lt;xs:element type="xs:integer" name="TotalQuantity"/>
 *     &lt;xs:element type="xs:string" name="BagType" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="ApplicableBag" minOccurs="0"/>
 *     &lt;xs:element type="ns:Descriptions" name="Descriptions" minOccurs="0"/>
 *     &lt;xs:element name="PieceMeasurements" maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class PieceMeasurements -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute name="PieceAllowanceCombination">
 *     &lt;xs:simpleType>
 *       &lt;!-- Reference to inner class PieceAllowanceCombination -->
 *     &lt;/xs:simpleType>
 *   &lt;/xs:attribute>
 *   &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class BagAllowancePieceType implements Serializable
{
    private String applicableParty;
    private BigInteger totalQuantity;
    private String bagType;
    private String applicableBag;
    private Descriptions descriptions;
    private List<PieceMeasurements> pieceMeasurementList = new ArrayList<PieceMeasurements>();
    private PieceAllowanceCombination pieceAllowanceCombination;
    private String refs;

    /** 
     * Get the 'ApplicableParty' element value. Baggage weight restriction application. Examples: Party, Traveler

    Note: Party applies to all Travelers.
     * 
     * @return value
     */
    public String getApplicableParty() {
        return applicableParty;
    }

    /** 
     * Set the 'ApplicableParty' element value. Baggage weight restriction application. Examples: Party, Traveler

    Note: Party applies to all Travelers.
     * 
     * @param applicableParty
     */
    public void setApplicableParty(String applicableParty) {
        this.applicableParty = applicableParty;
    }

    /** 
     * Get the 'TotalQuantity' element value. Maximum pieces.
    Example: 4
     * 
     * @return value
     */
    public BigInteger getTotalQuantity() {
        return totalQuantity;
    }

    /** 
     * Set the 'TotalQuantity' element value. Maximum pieces.
    Example: 4
     * 
     * @param totalQuantity
     */
    public void setTotalQuantity(BigInteger totalQuantity) {
        this.totalQuantity = totalQuantity;
    }

    /** 
     * Get the 'BagType' element value. Type of Bag,.
    Example: Golf Equipment, Bag, Fishing, Car Seat
     * 
     * @return value
     */
    public String getBagType() {
        return bagType;
    }

    /** 
     * Set the 'BagType' element value. Type of Bag,.
    Example: Golf Equipment, Bag, Fishing, Car Seat
     * 
     * @param bagType
     */
    public void setBagType(String bagType) {
        this.bagType = bagType;
    }

    /** 
     * Get the 'ApplicableBag' element value. Applicable bag type.
    Examples: Carry-On, 1st Checked Bag, 2nd Checked Bag
     * 
     * @return value
     */
    public String getApplicableBag() {
        return applicableBag;
    }

    /** 
     * Set the 'ApplicableBag' element value. Applicable bag type.
    Examples: Carry-On, 1st Checked Bag, 2nd Checked Bag
     * 
     * @param applicableBag
     */
    public void setApplicableBag(String applicableBag) {
        this.applicableBag = applicableBag;
    }

    /** 
     * Get the 'Descriptions' element value.
     * 
     * @return value
     */
    public Descriptions getDescriptions() {
        return descriptions;
    }

    /** 
     * Set the 'Descriptions' element value.
     * 
     * @param descriptions
     */
    public void setDescriptions(Descriptions descriptions) {
        this.descriptions = descriptions;
    }

    /** 
     * Get the list of 'PieceMeasurements' element items.
     * 
     * @return list
     */
    public List<PieceMeasurements> getPieceMeasurementList() {
        return pieceMeasurementList;
    }

    /** 
     * Set the list of 'PieceMeasurements' element items.
     * 
     * @param list
     */
    public void setPieceMeasurementList(List<PieceMeasurements> list) {
        pieceMeasurementList = list;
    }

    /** 
     * Get the 'PieceAllowanceCombination' attribute value. Provides logical combiinaton between  allowances pieces. Enumaration with OR and AND as posisble values.
     * 
     * @return value
     */
    public PieceAllowanceCombination getPieceAllowanceCombination() {
        return pieceAllowanceCombination;
    }

    /** 
     * Set the 'PieceAllowanceCombination' attribute value. Provides logical combiinaton between  allowances pieces. Enumaration with OR and AND as posisble values.
     * 
     * @param pieceAllowanceCombination
     */
    public void setPieceAllowanceCombination(
            PieceAllowanceCombination pieceAllowanceCombination) {
        this.pieceAllowanceCombination = pieceAllowanceCombination;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getRefs() {
        return refs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param refs
     */
    public void setRefs(String refs) {
        this.refs = refs;
    }
    /** 
     * Provides information on per piece weight and dimensions.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PieceMeasurements" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="ns:BagAllowanceWeightType" name="PieceWeightAllowance" minOccurs="0" maxOccurs="unbounded"/>
     *       &lt;xs:element type="ns:BagAllowanceDimensionType" name="PieceDimensionAllowance" minOccurs="0" maxOccurs="unbounded"/>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:int" use="required" name="Quantity"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class PieceMeasurements implements Serializable
    {
        private List<BagAllowanceWeightType> pieceWeightAllowanceList = new ArrayList<BagAllowanceWeightType>();
        private List<BagAllowanceDimensionType> pieceDimensionAllowanceList = new ArrayList<BagAllowanceDimensionType>();
        private Integer quantity;

        /** 
         * Get the list of 'PieceWeightAllowance' element items. BAGGAGE WEIGHT allowance per baggage piece.
         * 
         * @return list
         */
        public List<BagAllowanceWeightType> getPieceWeightAllowanceList() {
            return pieceWeightAllowanceList;
        }

        /** 
         * Set the list of 'PieceWeightAllowance' element items. BAGGAGE WEIGHT allowance per baggage piece.
         * 
         * @param list
         */
        public void setPieceWeightAllowanceList(
                List<BagAllowanceWeightType> list) {
            pieceWeightAllowanceList = list;
        }

        /** 
         * Get the list of 'PieceDimensionAllowance' element items. BAGGAGE DIMENSION allowance per baggage piece.
         * 
         * @return list
         */
        public List<BagAllowanceDimensionType> getPieceDimensionAllowanceList() {
            return pieceDimensionAllowanceList;
        }

        /** 
         * Set the list of 'PieceDimensionAllowance' element items. BAGGAGE DIMENSION allowance per baggage piece.
         * 
         * @param list
         */
        public void setPieceDimensionAllowanceList(
                List<BagAllowanceDimensionType> list) {
            pieceDimensionAllowanceList = list;
        }

        /** 
         * Get the 'Quantity' attribute value. Quantity of pieces with these measurements.
         * 
         * @return value
         */
        public Integer getQuantity() {
            return quantity;
        }

        /** 
         * Set the 'Quantity' attribute value. Quantity of pieces with these measurements.
         * 
         * @param quantity
         */
        public void setQuantity(Integer quantity) {
            this.quantity = quantity;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
     *   &lt;xs:restriction base="xs:string">
     *     &lt;xs:enumeration value="OR"/>
     *     &lt;xs:enumeration value="AND"/>
     *   &lt;/xs:restriction>
     * &lt;/xs:simpleType>
     * </pre>
     */
    public static enum PieceAllowanceCombination implements Serializable {
        OR, AND
    }
}
