
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/** 
 * A data type for Baggage Allowance by Weight.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BagAllowanceWeightType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="ApplicableParty" minOccurs="0"/>
 *     &lt;xs:element name="MaximumWeight" maxOccurs="2">
 *       &lt;!-- Reference to inner class MaximumWeight -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="xs:string" name="ApplicableBag" minOccurs="0"/>
 *     &lt;xs:element type="ns:Descriptions" name="Descriptions" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class BagAllowanceWeightType implements Serializable
{
    private String applicableParty;
    private List<MaximumWeight> maximumWeightList = new ArrayList<MaximumWeight>();
    private String applicableBag;
    private Descriptions descriptions;
    private String refs;

    /** 
     * Get the 'ApplicableParty' element value. Baggage weight restriction application. Examples: Party, Traveler

    Note: Party applies to all Travelers.
     * 
     * @return value
     */
    public String getApplicableParty() {
        return applicableParty;
    }

    /** 
     * Set the 'ApplicableParty' element value. Baggage weight restriction application. Examples: Party, Traveler

    Note: Party applies to all Travelers.
     * 
     * @param applicableParty
     */
    public void setApplicableParty(String applicableParty) {
        this.applicableParty = applicableParty;
    }

    /** 
     * Get the list of 'MaximumWeight' element items.
     * 
     * @return list
     */
    public List<MaximumWeight> getMaximumWeightList() {
        return maximumWeightList;
    }

    /** 
     * Set the list of 'MaximumWeight' element items.
     * 
     * @param list
     */
    public void setMaximumWeightList(List<MaximumWeight> list) {
        maximumWeightList = list;
    }

    /** 
     * Get the 'ApplicableBag' element value. Applicable bag type.
    Examples: Carry-On, 1st Checked Bag, 2nd Checked Bag
     * 
     * @return value
     */
    public String getApplicableBag() {
        return applicableBag;
    }

    /** 
     * Set the 'ApplicableBag' element value. Applicable bag type.
    Examples: Carry-On, 1st Checked Bag, 2nd Checked Bag
     * 
     * @param applicableBag
     */
    public void setApplicableBag(String applicableBag) {
        this.applicableBag = applicableBag;
    }

    /** 
     * Get the 'Descriptions' element value.
     * 
     * @return value
     */
    public Descriptions getDescriptions() {
        return descriptions;
    }

    /** 
     * Set the 'Descriptions' element value.
     * 
     * @param descriptions
     */
    public void setDescriptions(Descriptions descriptions) {
        this.descriptions = descriptions;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getRefs() {
        return refs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param refs
     */
    public void setRefs(String refs) {
        this.refs = refs;
    }
    /** 
     * Maximum weight value and unit of measure.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MaximumWeight" maxOccurs="2">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:decimal" name="Value"/>
     *       &lt;xs:element type="xs:string" name="UOM"/>
     *       &lt;xs:element type="xs:int" name="SpreadOverBagsQuantity" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *     &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * 
     * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
     *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
     * &lt;/xs:attributeGroup>
     * </pre>
     */
    public static class MaximumWeight implements Serializable
    {
        private BigDecimal value;
        private String UOM;
        private Integer spreadOverBagsQuantity;
        private String refs;

        /** 
         * Get the 'Value' element value. Maximum weight value.  Example: 50
         * 
         * @return value
         */
        public BigDecimal getValue() {
            return value;
        }

        /** 
         * Set the 'Value' element value. Maximum weight value.  Example: 50
         * 
         * @param value
         */
        public void setValue(BigDecimal value) {
            this.value = value;
        }

        /** 
         * Get the 'UOM' element value. Baggage weight unit of measure.  

        Encoding Scheme: IATA Padis Codeset - List for data element 6411
         * 
         * @return value
         */
        public String getUOM() {
            return UOM;
        }

        /** 
         * Set the 'UOM' element value. Baggage weight unit of measure.  

        Encoding Scheme: IATA Padis Codeset - List for data element 6411
         * 
         * @param UOM
         */
        public void setUOM(String UOM) {
            this.UOM = UOM;
        }

        /** 
         * Get the 'SpreadOverBagsQuantity' element value.
         * 
         * @return value
         */
        public Integer getSpreadOverBagsQuantity() {
            return spreadOverBagsQuantity;
        }

        /** 
         * Set the 'SpreadOverBagsQuantity' element value.
         * 
         * @param spreadOverBagsQuantity
         */
        public void setSpreadOverBagsQuantity(Integer spreadOverBagsQuantity) {
            this.spreadOverBagsQuantity = spreadOverBagsQuantity;
        }

        /** 
         * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @return value
         */
        public String getRefs() {
            return refs;
        }

        /** 
         * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @param refs
         */
        public void setRefs(String refs) {
            this.refs = refs;
        }
    }
}
